﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<ClubActivity>>" %>
<% string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");%>
<div id="ListClubActivitiesBlock">
    <% 
        IList<ClubActivity> clubActivities = Model;

        if (TempData["StatusMessageData"] != null)
        {
            StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
            if (statusMessageData.MessageType == StatusMessageType.Success)
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData, 3000, false));
            else
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
            TempData["StatusMessageData"] = null;
        }
        bool HasClubManagerPermission = ViewData.GetBool("HasClubManagerPermission", false);
        int applicationID = ApplicationIDs.Instance().Club();

        if (clubActivities.Count > 0)
        {%>
    <div class="spb-new-activities">
        <ul class="tn-list tn-helper-reset">
            <% 
                Dictionary<int, Application> applications = Applications.GetApplications();
                string applicationKey = "default";
                string applicationName = GetResourceString("Description_ClubDynamic", applicationID);

                foreach (ClubActivity clubActivity in clubActivities)
                {%>
            <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
                <div class="tn-list-item-area-left">
                    <%
                        if (applications.ContainsKey(clubActivity.ApplicationID))
                        {
                            applicationKey = applications[clubActivity.ApplicationID].ApplicationKey;
                            applicationName = applications[clubActivity.ApplicationID].GetMultilingualApplicationName(CurrentUserLanguage);
                        }
                        string filePath = Globals.GetFullUrlInResourceSite(string.Format("~/Themes/Shared/Styles/Icons/activity_{0}.gif", applicationKey.ToLower()));
                    %>
                    <img src="<%=filePath %>" title="<%=string.Format(GetResourceString("Description_Pattern_ClubDynamic",ApplicationIDs.Instance().Club()),applicationName)%>"
                        alt="<%=string.Format(GetResourceString("Description_Pattern_ClubDynamic",ApplicationIDs.Instance().Club()),applicationName)%>" /></div>
                <% if (HasClubManagerPermission)
                   {                               
                %>
                <a class="tn-icon tn-icon-cross tn-helper-right" onclick="DeleteThisActivity('<%=SPBUrlHelper.Action("DeleteClubActivityInBlock","ClubDomain",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"applicationID",clubActivity.ApplicationID},{"activityID",clubActivity.ActivityID},{"displayItemCount", this.Html.GetParameterFromRouteDateOrQueryString("displayItemCount",10) }}) %>')">
                </a>
                <%} %>
                <div class="tn-list-item-area-main tn-helper-flowfix">
                    <div class="tn-list-item-row">
                        <cite>
                            <a class="tn-author" href="<%=SiteUrls.Instance().UserDomainHome(clubActivity.LeadingActorUserID) %>"
                                target="_blank">
                                <%=SPBHtmlHelper.Instance().UserDisplayName(clubActivity.LeadingActorUserID,true )%></a>
                        </cite>
                        <%=clubActivity.Subject %>
                        <em class="tn-text-note tn-date">
                            <%=Formatter.FormatFriendlyDate(clubActivity.DateCreated)%></em></div>
                    <div class="tn-list-item-row tn-list-item-summary">
                        <p class="tn-helper-reset">
                            <%= HtmlUtils.TrimHtml(clubActivity.Body, 140)%></p>
                    </div>
                </div>
            </li>
            <%} %>
        </ul>
    </div>

    <script type="text/javascript">
        function DeleteThisActivity(url) {
            $('#ListClubActivitiesBlock').parent().load(url);
        }
    </script>

    <%} %>
</div>
