﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ClubSharedContent>>" %>
<% Club currentClub = Clubs.GetClub(Html.GetParameterFromRouteDateOrQueryString("clubDomainName"), false);
   if (ViewData["StatusMessageContent"] != null)
   {
       Response.Write(ViewData["StatusMessageContent"].ToString());
   }
   int applicationID = ApplicationIDs.Instance().Club();
   Application a = null;
   if (ViewData["application"] != null)
   {
       a = ViewData["application"] as Application;
   }
%>
<ul class="tn-list tn-helper-reset">
    <%  if (Model != null && Model.Records != null && Model.Records.Count > 0)
        {
            foreach (var item in Model.Records)
            {
    %>
    <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
        <%
            if (!string.IsNullOrEmpty(item.ThumbnailUrl))
            {
        %>
        <div class="tn-list-item-area-left">
            <a href="<%=item.DetailsUrl %>">
                <img src="<%=item.ThumbnailUrl %>" alt="<%=item.Subject %>" /></a>
        </div>
        <%} %>
        <div class="tn-list-item-area-main">
            <div class="tn-list-item-row tn-list-item-heading">
                <h5 class="tn-helper-reset">
                    <a href="<%=item.DetailsUrl %>">
                        <%=item.Subject %></a>
                    <%
                        if (item.IsSticky)
                            Response.Write("&nbsp;" + SPBHtmlHelper.Instance().Icon(IconTypes.Top, GetResourceString("Common_SetTop"), new RouteValueDictionary { { "class", " tn-icon-inline" } }));
                        if (item.IsEssential)
                            Response.Write("&nbsp;" + SPBHtmlHelper.Instance().Icon(IconTypes.Elite, GetResourceString("Common_Essential"), new RouteValueDictionary { { "class", " tn-icon-inline" } }));
                    %>
                </h5>
            </div>
            <div class="tn-list-item-row">
                <cite>
                    <a class="tn-user-name" target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(item.SharerUserID,item.ApplicationID) %>">
                        <%=item.Sharer %></a></cite><em class="tn-date tn-text-note">
                            <%=string.Format( GetResourceString("Label_Pattern_ShareDate", applicationID),Formatter.FormatDate(item.DateCreated))%>
                        </em>
                <% if (item.Tags.Count > 0)
                   {
                       Response.Write("<em class=\"tn-text-note\">" + GetResourceString("Label_BelongTags", applicationID) + "：</em>");
                       foreach (string tagName in item.Tags)
                       {
                %>
                <a href="<%=SPBUrlHelper.Action("Share","ClubDomain",new RouteValueDictionary(){{"clubDomainName",currentClub.DomainName},{"TagName",WebUtils.UrlEncode(tagName)}}) %>">
                    <%=tagName%></a>
                &nbsp;
                <%
                    }
                   }%>
            </div>
            <div class="tn-list-item-row tn-list-item-summary">
                <p class="tn-helper-reset">
                    <%=item.Body %></p>
                <%--<div class="spb-i-said">
                    &nbsp;<span class="tn-icon tn-icon-quotes-before tn-icon-inline"></span>如果是评语，就是用这一段<span
                        class="tn-icon tn-icon-quotes-after tn-icon-inline"></span></div>--%>
            </div>
            <div class="tn-list-item-row">
                <%
                    if (Globals.GetCurrentUser() != null && ClubPermission.Validate(currentClub, Globals.GetCurrentUser(), PermissionItemKeys.Instance().ManageShareItemOfClub()))
                    {
                %>
                <span class="tn-action">
                    <a class="tn-action-text" href="<%=SPBUrlHelper.Action("DeleteShareContent", "ClubManage", new RouteValueDictionary { { "clubDomainName", currentClub.DomainName }, { "contentID", item.ContentID }, { "returnUrl",Request.Url } })%>"
                        onclick="if(!confirm('<%=GetResourceString("Message_DeleteShareMessage",applicationID)%>'))return false;">
                        <%=GetResourceString("Action_DeleteShare", applicationID)%></a></span>
                <span class="tn-action">
                    <a class="tn-action-text nyroModal" href="<%=SPBUrlHelper.Action("Control_ShareContentTag", "ClubDomain", new RouteValueDictionary() { {"clubDomainName",currentClub.DomainName},{ "shareContentID",item.ContentID } })%>">
                        <%=GetResourceString("Action_TagsSetting", applicationID)%></a></span>
                <span class="tn-action">
                    <a class="tn-action-text" id="setEssential<%=item.ContentID %>" href="javascript:;"
                        onclick="<% if (item.IsEssential) Response.Write("essentialManage('" + SPBUrlHelper.Action("ShareContentSetEssential","ClubManage",new RouteValueDictionary{{"contentID",item.ContentID},{"isEssential",false}}) + "'," + item.ContentID + ");"); else Response.Write("essentialManage('" + SPBUrlHelper.Action("ShareContentSetEssential", "ClubManage", new RouteValueDictionary { { "contentID", item.ContentID }, { "isEssential", true } }) + "'," + item.ContentID + ");"); %>">
                        <% if (item.IsEssential) Response.Write(GetResourceString("Common_CancelEssential")); else Response.Write(GetResourceString("Common_SetEssential")); %>
                    </a>
                </span>
                <span class="tn-action">
                    <a class="tn-action-text" href="javascript:;" id="setTop<%=item.ContentID %>" onclick="<% if (item.IsSticky) Response.Write("topManage('" + SPBUrlHelper.Action("ShareContentSetSticky","ClubManage",new RouteValueDictionary{{"contentID",item.ContentID},{"isSticky",false}}) + "'," + item.ContentID + ");"); else Response.Write("topManage('" + SPBUrlHelper.Action("ShareContentSetSticky","ClubManage",new RouteValueDictionary{{"contentID",item.ContentID},{"isSticky",true}}) + "'," + item.ContentID + ");"); %>">
                        <% if (item.IsSticky) Response.Write(GetResourceString("Common_CancelPutter")); else Response.Write(GetResourceString("Common_SetTop")); %>
                    </a>
                </span>
                <input type="text" id="essentialHideInputStore<%=item.ContentID %>" value="<%=Convert.ToInt32((item.IsEssential))%>"
                    style="display: none" />
                <input type="text" id="topHideInputStore<%=item.ContentID %>" value="<%=item.SpecialOrder %>"
                    style="display: none" />
            </div>
            <%  } %>
        </div>
    </li>
    <%}
        }
        else
        {
            Response.Write(GetResourceString("Message_NoShareContent", applicationID));
        } %>
</ul>
<div class="tn-pagination tn-helper-align-center">
    <%
        Response.Write(SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 11, null));
    %>
</div>

<script type="text/javascript">
    function essentialManage(Url, ID) {
        if (($('#essentialHideInputStore' + ID.toString()).val()) > 0) {
            $.get(Url, { contentID: ID }, function(data) {
                $('#setEssential' + ID.toString()).text('<%=GetResourceString("Common_SetEssential")%>');
                $('#essentialHideInputStore' + ID.toString()).val('0');
                $('#goodIco' + ID.toString()).toggle();
            });
        }
        else {
            $.get(Url, { contentID: ID }, function(data) {
                $('#setEssential' + ID.toString()).text('<%=GetResourceString("Common_CancelEssential")%>');
                $('#essentialHideInputStore' + ID.toString()).val('1');
                $('#goodIco' + ID.toString()).toggle();
            });
        }
    }
    function topManage(Url, ID) {
        if (($('#topHideInputStore' + ID.toString()).val()) > 0) {
            $.get(Url, { contentID: ID }, function(data) {
                $('#setTop' + ID.toString()).text('<%=GetResourceString("Common_SetTop") %>');
                $('#topHideInputStore' + ID.toString()).val('0');
                $('#topIco' + ID.toString()).toggle();
            });
        }
        else {
            $.get(Url, { contentID: ID }, function(data) {
                $('#setTop' + ID.toString()).text('<%=GetResourceString("Common_CancelPutter")%>');
                $('#topHideInputStore' + ID.toString()).val('1');
                $('#topIco' + ID.toString()).toggle();
            });
        }
    }
    
</script>

