﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<ClubSharedContent>>" %>
<% string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
   int applicationID = ApplicationIDs.Instance().Club();
%>
<ul class="tn-list tn-helper-reset">
    <%
        if (Model.Count > 0)
        {
            foreach (ClubSharedContent clubSharedContent in Model)
            {
    %>
    <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
        <%
            if (!string.IsNullOrEmpty(clubSharedContent.ThumbnailUrl))
            {
        %>
        <div class="tn-list-item-area-left">
            <a href="<%=clubSharedContent.DetailsUrl %>">
                <img src="<%=clubSharedContent.ThumbnailUrl %>" alt="<%=clubSharedContent.Subject %>" /></a></div>
        <%} %>
        <div class="tn-list-item-area-main">
            <div class="tn-list-item-row tn-list-item-heading">
                <h5 class="tn-helper-reset">
                    <a href="<%=clubSharedContent.DetailsUrl %>">
                        <%=clubSharedContent.Subject%></a>
                    <%
                        if (clubSharedContent.IsSticky)
                            Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Top, GetResourceString("Common_SetTop"), new RouteValueDictionary { { "class", " tn-icon-inline" } }));
                        if (clubSharedContent.IsEssential)
                            Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Elite, GetResourceString("Common_Essential"), new RouteValueDictionary { { "class", " tn-icon-inline" } }));
                    %>
                </h5>
            </div>
            <div class="tn-list-item-row">
                <cite><a class="tn-user-name" target="_blank" href="<%=SiteUrls.Instance().UserChannelHome(clubSharedContent.SharerUserID,clubSharedContent.ApplicationID) %>">
                    <%=clubSharedContent.Sharer%></a></cite><em class="tn-date tn-text-note">
                        <%=string.Format(GetResourceString("Label_Pattern_ShareDate", applicationID), Formatter.FormatDate(clubSharedContent.DateCreated))%>
                    </em>
                <% if (clubSharedContent.Tags.Count > 0)
                   {
                       Response.Write("<em class=\"tn-text-note\">" + GetResourceString("Label_BelongTags", applicationID) + "：</em>");
                       foreach (string tagName in clubSharedContent.Tags)
                       {
                %>
                <a href="<%=SPBUrlHelper.Action("Share","ClubDomain",new RouteValueDictionary(){{"clubDomainName",Html.GetParameterFromRouteDateOrQueryString("clubDomainName")},{"TagName",tagName}}) %>">
                    <%=tagName%></a>
                <%
                    }
                   }%>
            </div>
            <div class="tn-list-item-row tn-list-item-summary">
                <p class="tn-helper-reset">
                    <%=HtmlUtils.TrimHtml(clubSharedContent.Body, 140)%></p>
            </div>
        </div>
    </li>
    <%}
        } %>
</ul>
