﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<spb:Script runat="server" ID="CollapsibleBox" Src="~/Utility/jquery/plugin/jquery.spb.CollapsibleBox.js"
    SetExpireDays="30" />

<script type="text/javascript" src="~/Utility/jquery/plugin/jquery.spb.sideMenu.js"
    setexpiredays="30"></script>

<% int applicationID = ApplicationIDs.Instance().Club(); %>
<%ManageClubSubMenu? manageClubSubMenu = null;
  ManageClubMenu? manageClubMenu = null;
  if (ViewData["manageClubMenu"] != null)
      manageClubMenu = ViewData.Get<ManageClubMenu>("manageClubMenu");
  if (ViewData["manageClubSubMenu"] != null)
      manageClubSubMenu = ViewData.Get<ManageClubSubMenu>("manageClubSubMenu");
  PresentArea presentArea = PresentAreas.GetPresentArea(PresentAreaIDs.Instance().ClubDomain(), false);
%>
<div id="manageMeun" class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset">
            <%=GetResourceString("Title_ManagerControlPanel", applicationID) %></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <% string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
        %>
        <div class="tn-collapsible tn-collapsible-opened">
            <div class="tn-border-bottom tn-border-gray tn-collapsible-header tn-switch-left">
                <h4 class="tn-helper-reset">
                    <span>
                        <%=GetResourceString("Title_ManagerContent",applicationID) %></span>
                </h4>
                <% %>
            </div>
            <div style="" class="tn-collapsible-content">
                <ul class="tn-side-menu">
                    <% if (ClubPermission.Validate(clubDomainName, CurrentUser, PermissionItemKeys.Instance().ManageShareItemOfClub()))
                       {  %>
                    <li <%if (manageClubSubMenu == ManageClubSubMenu.ManageShare) Response.Write("class=\"tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                        <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("Share","ClubManage",new RouteValueDictionary() { {"clubDomainName",clubDomainName} }) %>">
                            <%=GetResourceString("Action_ManagerShareContent", applicationID)%>
                        </a>
                    </li>
                    <%} %>
                    <% if (Applications.IsEnabled(ApplicationIDs.Instance().Vote()))
                       {%>
                    <li <%if (manageClubSubMenu ==ManageClubSubMenu.ManageVoteComments) Response.Write("class=\"tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                        <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageComments","ClubVote",new RouteValueDictionary { {"clubDomainName",clubDomainName}})%>">
                            <%=GetResourceString("Title_MangerVoteReview",ApplicationIDs.Instance().Vote()) %></a></li>
                    <% }%>
                </ul>
            </div>
        </div>
        <div class="tn-collapsible tn-collapsible-opened">
            <div class="tn-border-bottom tn-border-gray tn-collapsible-header tn-switch-left">
                <h4 class="tn-helper-reset">
                    <span>
                        <%=GetResourceString("Action_ManageThread", applicationID)%></span>
                </h4>
                <% %>
            </div>
            <div class="tn-collapsible-content">
                <ul class="tn-side-menu">
                    <% if (Applications.IsEnabled(ApplicationIDs.Instance().Forum()) && ClubPermission.Validate(clubDomainName, CurrentUser, PermissionItemKeys.Instance().ManageClubForumSectioins()))
                       {%>
                    <li <%if (manageClubSubMenu == ManageClubSubMenu.ManageForumThreads) Response.Write("class=\"tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                        <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageForumThreads","ClubForum",new RouteValueDictionary() { {"clubDomainName",clubDomainName}})%>">
                            <%=GetResourceString("Action_ManageThread",applicationID)%></a></li>
                    <li <%if (manageClubSubMenu == ManageClubSubMenu.ManageForumPost) Response.Write("class=\"tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                        <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageForumPosts", "ClubForum",new RouteValueDictionary() { {"clubDomainName",clubDomainName}})%>">
                            <%=GetResourceString("Title_ManageForumPosts",applicationID)%></a></li>
                    <li <%if (manageClubSubMenu == ManageClubSubMenu.ManageForumSections) Response.Write("class=\"tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                        <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageForumSections","ClubForum",new RouteValueDictionary() { {"clubDomainName",clubDomainName}}) %>">
                            <%=GetResourceString("Action_ManagerForumSections", applicationID)%></a></li>
                    <li <%if (manageClubSubMenu == ManageClubSubMenu.ManageForumCategories) Response.Write("class=\"tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                        <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageForumCategories","ClubForum",new RouteValueDictionary() { {"clubDomainName",clubDomainName}})%>">
                            <%=GetResourceString("Title_ManageForumCategories", applicationID)%></a></li>
                    <%}%>
                </ul>
            </div>
        </div>
        <div class="tn-collapsible tn-collapsible-opened">
            <div class="tn-border-bottom tn-border-gray tn-collapsible-header tn-switch-left">
                <h4 class="tn-helper-reset">
                    <span>
                        <%=GetResourceString("Title_BaseSet",applicationID)%>
                    </span>
                </h4>
            </div>
            <div style="" class="tn-collapsible-content">
                <ul class="tn-side-menu">
                    <% if (ClubPermission.Validate(clubDomainName, CurrentUser, PermissionItemKeys.Instance().EditClub()))
                       { %>
                    <li <%if (manageClubSubMenu == ManageClubSubMenu.EditClubPlacard) Response.Write("class=\"tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                        <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("EditClubPlacard","ClubManage",new RouteValueDictionary(){{"clubDomainName",clubDomainName}}) %>">
                            <%=GetResourceString("Action_EditClubPlacard", applicationID)%>
                        </a>
                    </li>
                    <%if (presentArea != null && presentArea.EnableThemes)
                      { %>
                    <li <%if (manageClubSubMenu == ManageClubSubMenu.ModifyHome) Response.Write("class=\"tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                        <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ModifyHome","ClubManage",new RouteValueDictionary(){{"clubDomainName",clubDomainName}}) %>">
                            <%=GetResourceString("Action_ModifyHome", applicationID)%></a></li>
                    <%} %>
                    <li <%if (manageClubSubMenu == ManageClubSubMenu.ManageClubInfo) Response.Write("class=\"tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                        <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ClubInfo","ClubManage",new RouteValueDictionary(){{"clubDomainName",clubDomainName}}) %>">
                            <%=GetResourceString("Action_UpdateClubInfo", applicationID)%></a></li>
                    <li <%if (manageClubSubMenu == ManageClubSubMenu.ClubLogo) Response.Write("class=\"tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                        <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ClubLogo","ClubManage",new RouteValueDictionary(){{"clubDomainName",clubDomainName}}) %>">
                            <%=GetResourceString("Action_UpdateClubLogo", applicationID)%></a></li>
                    <li <%if (manageClubSubMenu == ManageClubSubMenu.ClubBanner) Response.Write("class=\"tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                        <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ClubBanner","ClubManage",new RouteValueDictionary(){{"clubDomainName",clubDomainName}}) %>">
                            <%=GetResourceString("Action_UpdateClubBanner", applicationID)%></a></li>
                    <li <%if (manageClubSubMenu == ManageClubSubMenu.ManageClubNavigations) Response.Write("class=\"tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                        <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageClubNavigations","ClubManage",new RouteValueDictionary(){{"clubDomainName",clubDomainName}}) %>">
                            <%=GetResourceString("Action_ManageClubNavigations", applicationID)%></a></li>
                    <li <%if (manageClubSubMenu == ManageClubSubMenu.ManageApplications) Response.Write("class=\"tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                        <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageApplications","ClubManage",new RouteValueDictionary(){{"clubDomainName",clubDomainName}}) %>">
                            应用管理</a></li>
                    <%} %>
                    <%if (SiteSettingsManager.GetSiteSettings().EnableClubAD && ClubPermission.Validate(clubDomainName, CurrentUser, PermissionItemKeys.Instance().ManageClubAdvertising()))
                      {%>
                    <li <%if (manageClubSubMenu == ManageClubSubMenu.ManageAdvertisings) Response.Write("class=\"tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                        <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageAdvertisings","ClubManage",new RouteValueDictionary(){{"clubDomainName",clubDomainName}}) %>">
                            <%=GetResourceString("Action_ManageAdvertisings", applicationID)%></a></li>
                    <%}%>
                    <%
                        if (ClubPermission.Validate(clubDomainName, CurrentUser, PermissionItemKeys.Instance().ManageClubLink()))
                        {
                    %>
                    <li <%if (manageClubSubMenu == ManageClubSubMenu.ManageClubLinks) Response.Write("class=\"tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                        <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageClubLinks","ClubManage",new RouteValueDictionary(){{"clubDomainName",clubDomainName}}) %>">
                            <%=GetResourceString("Action_ManageClubLinks", applicationID)%></a></li>
                    <li <%if (manageClubSubMenu == ManageClubSubMenu.ManageClubLinkCategories) Response.Write("class=\"tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                        <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageClubLinkCategories","ClubManage",new RouteValueDictionary(){{"clubDomainName",clubDomainName}}) %>">
                            <%=GetResourceString("Action_ManageClubLinkCategories", applicationID)%></a></li>
                    <%} %>
                </ul>
            </div>
        </div>
        <%
            if (ClubPermission.Validate(clubDomainName, CurrentUser, PermissionItemKeys.Instance().ManageClubMember()))
            {
        %>
        <div class="tn-collapsible tn-collapsible-opened">
            <div class="tn-border-bottom tn-border-gray tn-collapsible-header tn-switch-left">
                <h4 class="tn-helper-reset">
                    <span>
                        <%=GetResourceString("Title_ManagerMember",applicationID) %></span>
                </h4>
            </div>
            <div style="" class="tn-collapsible-content">
                <ul class="tn-side-menu">
                    <li <%if (manageClubSubMenu == ManageClubSubMenu.ManageClubMembers) Response.Write("class=\"tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                        <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageClubMembers","ClubMember",new RouteValueDictionary(){{"clubDomainName",clubDomainName}}) %>">
                            <%=GetResourceString("Action_ManageClubMembers", applicationID)%></a>
                    </li>
                    <li <%if (manageClubSubMenu == ManageClubSubMenu.ManagePendingClubMembers) Response.Write("class=\"tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                        <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManagePendingClubMembers","ClubMember",new RouteValueDictionary(){{"clubDomainName",clubDomainName}}) %>">
                            <%=GetResourceString("Action_ManagePendingClubMembers", applicationID)%></a>
                    </li>
                </ul>
            </div>
        </div>
        <%} %>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $(".tn-collapsible").collapsibleBox();
    });
</script>

