﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<ForumThreadCategory>>" %>
<spb:Script runat="server" ID="nyroModal" Src="~/Utility/jquery/plugin/jquery.nyroModal-1.6.2.min.js"
    SetExpireDays="30" />
<%   ForumSection section = ViewData.Get<ForumSection>("section");
     int applicationID = ApplicationIDs.Instance().Club();
     if (section != null)
     {
         int sectionID = section.SectionID;
         string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
%>
<%=SPBHtmlHelper.Instance().LinkButton("nyroModal", GetResourceString("Action_AddNewCategories", applicationID), SPBUrlHelper.Action("Control_EditForumThreadCategory", "ClubForum", new RouteValueDictionary { { "sectionID", sectionID }, { "clubDomainName", clubDomainName } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText, new RouteValueDictionary { { "class", "nyroModal" } }, null)%>
<table class="tn-table-grid" id="Categorieslist">
    <tr class="tn-table-grid-header">
        <th class="tn-border-gray tn-border-bottom tn-text-note">
            <%=GetResourceString("Label_CategoriesName",applicationID)%>
        </th>
        <th class="tn-border-gray tn-border-bottom tn-text-note">
            <%=GetResourceString("Label_Description")%>
        </th>
        <th class="tn-border-gray tn-border-bottom tn-text-note">
            <%=GetResourceString("Label_OrderNum",applicationID)%>
        </th>
        <th class="tn-border-gray tn-border-bottom tn-text-note">
            <%=GetResourceString("Label_Actions")%>
        </th>
    </tr>
    <%
            
        foreach (ForumThreadCategory category in Model)
        {%>
    <tr class="tn-table-grid-row">
        <td class="tn-border-gray tn-border-bottom tn-width-category tn-nowrap">
            <%=category.CategoryName%>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-width-category tn-nowrap" title="<%=category.CategoryDescription%>">
            <%=StringUtils.Trim(category.CategoryDescription,20)%>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
            <%=category.DisplayOrder%>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap">
            <a class="nyroModal submit edit" href="<%=SPBUrlHelper.Action("Control_EditForumThreadCategory", "ClubForum", new RouteValueDictionary { { "sectionID", sectionID },{"categoryID",category.CategoryID },{"clubDomainName",clubDomainName} })%>">
                <%= GetResourceString("Action_Edit")%></a> <a href="javascript:;" onclick="if (confirm('<%=GetResourceString("Description_DeleteCategoriesSure",applicationID)%>')) $('#Categorieslist').parent().load('<%=SPBUrlHelper.Action("DeleteForumThreadCategory", "ClubForum", new RouteValueDictionary { { "categoryID", category.CategoryID },{"clubDomainName",Html.GetParameterFromRouteDateOrQueryString("clubDomainName")} })%>');">
                    <%=GetResourceString("Action_Delete")%></a>
        </td>
    </tr>
    <%}%>
</table>

<script type="text/javascript">
         $(document).ready(function() 
          {
              $('#nyroModal').nyroModal({
                resizeable: true,
                endRemove: function() {
                    $("#Categorieslist").parent().load("<%=SPBUrlHelper.Action("Control_ListForumCategories", "ClubForum", new RouteValueDictionary { { "sectionID",sectionID }, { "clubDomainName", clubDomainName } })%>");   
            
                }
            });     
              $('.edit').nyroModal({
                resizeable: true,
                endRemove: function() {
                    $("#Categorieslist").parent().load("<%=SPBUrlHelper.Action("Control_ListForumCategories", "ClubForum", new RouteValueDictionary { { "sectionID",sectionID }, { "clubDomainName", clubDomainName } })%>");   
            
                }
            });              

         });
      
</script>

<%} %>