﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ClubSharedContent>>" %>
<spb:Script ID="jquery_form" runat="server" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    SetExpireDays="30" />
<%
    int clubApplicationID = ApplicationIDs.Instance().Club();
    IList<int> list = ClubDomainConfiguration.Instance().EnabledSharedApplicationIDs;
    int applicationID = -1;
    if (ViewData["applicationID"] != null)
        applicationID = (int)ViewData["applicationID"];
%>
<% 
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 2000));
        TempData["StatusMessageType"] = null;
        %>
        <div class="tn-blank10"></div>
   <% }
        %>
<div class="tn-list-header">
    <div class="tn-toolbar tn-helper-clearfix">
        <div class="tn-tool-form">
        <%=GetResourceString("Lable_Select") %><%=GetResourceString("Common_Colon")%>
            <select onchange="window.location.href='?applicationID='+$(this).val();">
                <option value="-1" <%if (applicationID == -1) Response.Write("selected=\"selected\""); %>>
                    <%=GetResourceString("Enum_All",clubApplicationID) %></option>
                <%
                    foreach (var item in list)
                    {
                %>
                <option value="<%=item %>" <%if (applicationID == item) Response.Write("selected=\"selected\""); %>>
                    <%=Applications.GetApplication(item).GetMultilingualApplicationName(CurrentUserLanguage)%>
                </option>
                <%        
                    }
                %>
            </select>
            <%=SPBHtmlHelper.Instance().Button("deleteShares",GetResourceString("Action_Delete"), ButtonSizes.Default, HighlightStyles.Default,null,null) %>
        </div>
    </div>
</div>
<form id="manageClubCommendItemsForm" method="post">
<table class="tn-table-grid">
    <tr class="tn-table-grid-header">
        <td class="tn-border-gray tn-border-bottom tn-text-note">
            <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'commendItemsCheckBoxGroup')" />
        </td>
        <td class="tn-border-gray tn-border-bottom tn-text-note">
            <%=GetResourceString("Label_Theme", clubApplicationID)%>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-text-note">
            <%=GetResourceString("Label_FormerlyAuthor", clubApplicationID)%>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-text-note">
            <%=GetResourceString("Label_ShareUser", clubApplicationID)%>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-text-note">
            <%=GetResourceString("Label_ShareTime", clubApplicationID)%>
        </td>
    </tr>
    <% foreach (var item in Model.Records)
       {
           if (item != null)
           {
    %>
    <tr class="tn-table-grid-row">
        <td class="tn-border-gray tn-border-bottom tn-width-check">
            <input type="checkbox" class="tn-checkbox" name="commendItemsCheckBoxGroup" value="<%=item.ContentID %>" />
        </td>
        <td class="tn-border-gray tn-border-bottom tn-width-auto">
            <span><a href="<%=item.DetailsUrl %>" target="_blank" title="<%=item.Subject %>">
              <%=item.Subject %>
              </a> </span>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
            <a href=" <%=SiteUrls.Instance().UserDomainHome(item.AuthorUserID) %>" target="_blank">
                <%=item.Author%></a>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
            <a href=" <%=SiteUrls.Instance().UserDomainHome(item.SharerUserID) %>" target="_blank">
                <%=item.Sharer%></a>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
            <%=Formatter.FormatDate(item.DateCreated) %>
        </td>
    </tr>
    <%}

       } %>
</table>
</form>
<div class="tn-pagination tn-helper-align-center">
    <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 7, SPBUrlHelper.Action("Control_ListShareContents", "ClubManage", new RouteValueDictionary() { { "clubDomainName", Html.GetParameterFromRouteDateOrQueryString("clubDomainName") }, { "pageIndex", "{0}" }, { "applicationID", applicationID } }), "pageIndexChange")%>
</div>

<script type="text/javascript">
    function pageIndexChange(url) {
        $('#manageClubShareItemDiv').load(url);
    }
    $(document).ready(function() {
        $("#deleteShares").click(function() {
            if ($("#manageClubCommendItemsForm :checkbox:checked").length <= 0) {
                alert('<%=GetResourceString("Message_SelectOneThread",clubApplicationID) %>');
                return false;
            }
            $('#manageClubCommendItemsForm').ajaxSubmit({ target: '#manageClubShareItemDiv', url: '<%=SPBUrlHelper.Action("DeleteShareContents", "ClubManage", new RouteValueDictionary { { "clubDomainName", Html.GetParameterFromRouteDateOrQueryString("clubDomainName") } })%>', type: 'post' });
        });
    });
</script>

