﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ClubMember>>" %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        if (messageType == StatusMessageType.Success)
        {
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessage", string.Empty), 4000));
        }
        TempData["StatusMessageType"] = null;
    }
    string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
    int applicationID = ApplicationIDs.Instance().Club();
%>
<spb:Script runat="server" ID="jquery_form" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    SetExpireDays="30" />
<%
    int returnToPageIndex = ViewData.Model.PageIndex;
    if (ViewData.Model.TotalRecords == ViewData.Model.PageIndex * ViewData.Model.PageSize + 1)
        returnToPageIndex = returnToPageIndex + 1; %>
<form id="manageClubMemberForm" method="post">
<div class="tn-list-header">
    <div class="tn-toolbar tn-helper-clearfix">
        <div class="tn-tool-form">
            <% ClubMemberRoles? currentClubMemberRole = (ClubMemberRoles?)ViewData["clubMemberRoles"];
               ClubMemberStatuses? currentClubMemberStatues = (ClubMemberStatuses?)ViewData["clubMemberStatuses"];
               bool isTopManager = ViewData.GetBool("isTopManager", false); %>
            <select onchange="resortMemberListForManage()" class="dropDownList" id="clubMemberRolesDropDownList"
                name="clubMemberRolesDropDownList">
                <option <% if (!currentClubMemberRole.HasValue) Response.Write("selected=\"selected\""); %>
                    value="">
                    <%=GetResourceString("Enum_ClubMemberRoles_All", applicationID)%></option>
                <option <% if (currentClubMemberRole.HasValue && ((ClubMemberRoles)currentClubMemberRole == ClubMemberRoles.ClubOwner)) Response.Write("selected=\"selected\""); %>
                    value="<%=ClubMemberRoles.ClubOwner %>">
                    <%=GetResourceString("Enum_ClubMemberRoles_ClubOwner", applicationID)%></option>
                <option <% if (currentClubMemberRole.HasValue && ((ClubMemberRoles)currentClubMemberRole == ClubMemberRoles.ClubAssistant)) Response.Write("selected=\"selected\""); %>
                    value="<%=ClubMemberRoles.ClubAssistant %>">
                    <%=GetResourceString("Enum_ClubMemberRoles_ClubAssistant", applicationID)%></option>
                <option <% if (currentClubMemberRole.HasValue && ((ClubMemberRoles)currentClubMemberRole == ClubMemberRoles.ClubMember)) Response.Write("selected=\"selected\""); %>
                    value="<%=ClubMemberRoles.ClubMember %>">
                    <%=GetResourceString("Enum_ClubMemberRoles_ClubMember", applicationID)%></option>
            </select>
            <select onchange="resortMemberListForManage()" class="dropDownList" id="clubMemberStatusesDropDownList"
                name="clubMemberStatusesDropDownList">
                <option <% if (!currentClubMemberStatues.HasValue) Response.Write("selected=\"selected\""); %>
                    value="">
                    <%=GetResourceString("Enum_AccountStatuses_All") %></option>
                <%--<option <% if (currentClubMemberStatues.HasValue && ((ClubMemberStatuses)currentClubMemberStatues == ClubMemberStatuses.Banned)) Response.Write("selected=\"selected\""); %>
                    value="<%=ClubMemberStatuses.Banned %>">
                    <%=GetResourceString("Enum_AccountStatuses_Banned")%></option>--%>
                <option <% if (currentClubMemberStatues.HasValue && ((ClubMemberStatuses)currentClubMemberStatues == ClubMemberStatuses.NotApproved)) Response.Write("selected=\"selected\""); %>
                    value="<%=ClubMemberStatuses.NotApproved %>">
                    <%=GetResourceString("Enum_AccountStatuses_Disapproved")%></option>
                <option <% if (currentClubMemberStatues.HasValue && ((ClubMemberStatuses)currentClubMemberStatues == ClubMemberStatuses.Pending)) Response.Write("selected=\"selected\""); %>
                    value="<%=ClubMemberStatuses.Pending %>">
                    <%=GetResourceString("Enum_AccountStatuses_ApprovalPending")%>
                </option>
                <option <% if (currentClubMemberStatues.HasValue && ((ClubMemberStatuses)currentClubMemberStatues == ClubMemberStatuses.IsApproved)) Response.Write("selected=\"selected\""); %>
                    value="<%=ClubMemberStatuses.IsApproved %>">
                    <%=GetResourceString("Enum_AccountStatuses_Approved")%></option>
            </select>
            <%=SPBHtmlHelper.Instance().Button("deleteMembers",GetResourceString("Action_Delete"), ButtonSizes.Default, HighlightStyles.Default,null,null) %>
            <%=SPBHtmlHelper.Instance().Button("ApproveMember", GetResourceString("Button_Approve"), ButtonSizes.Default, HighlightStyles.Default, null, null)%>
            <%=SPBHtmlHelper.Instance().Button("NoApproveMember", GetResourceString("Button_NoApprove"), ButtonSizes.Default, HighlightStyles.Default, null, null)%>
        </div>
    </div>
</div>
<table class="tn-table-grid">
    <tbody>
        <tr class="tn-table-grid-header">
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <input class="tn-checkbox" type="checkbox" id="checkbox" onclick="checkAll(this,'clubMembersCheckBoxGroup')" />
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_MemberRule", applicationID)%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_UserName", applicationID)%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_InviteUser", applicationID)%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_JoinDate", applicationID)%>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_Status") %>
            </th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">
                <%=GetResourceString("Label_Actions")%>
            </th>
        </tr>
        <%
            if (ViewData.Model != null && ViewData.Model.Records.Count > 0)
            {
                foreach (ClubMember clubMember in ViewData.Model.Records)
                {
                    if (clubMember != null)
                    {%>
        <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom tn-width-check">
                <% 
                    if (clubMember.ClubMemberRole != ClubMemberRoles.ClubOwner)
                    {
                        if (clubMember.ClubMemberRole != ClubMemberRoles.ClubAssistant || isTopManager)
                        {%>
                <input class="tn-checkbox" type="checkbox" name="clubMembersCheckBoxGroup" value="<%=clubMember.UserID %>" />
                <%}
                    } %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-status tn-nowrap">
                <%=clubMember.ClubRole %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                <a class="tn-action-text" title="<%= clubMember.DisplayName %>" href="<%=SiteUrls.Instance().UserDomainHome(clubMember.UserID) %>">
                    <%if (!string.IsNullOrEmpty(clubMember.DisplayName)) Response.Write(clubMember.DisplayName); else if (clubMember.User != null) Response.Write(clubMember.User.DisplayName); %></a>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                <%=clubMember.InviteUserDisplayName %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                <%=Formatter.FormatDate(clubMember.JoinDate) %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-status tn-nowrap">
                <%=clubMember.StatusText %>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap">
                <% if (clubMember.ClubMemberRole == ClubMemberRoles.ClubMember)
                   { %>
                <% if (isTopManager)
                   {%>
                <a href="javascript:;" class="tn-action-text" id="setClubAssistantA<%=clubMember.UserID %>"
                    onclick="setClubAssistantFunction(<%=clubMember.UserID %>)">
                    <%=GetResourceString("Action_SetBecomeAdmin", applicationID)%></a>
                <%}
                   else
                   { %>
                <%=GetResourceString("Enum_ClubMemberRoles_ClubMember", applicationID)%>
                <%} %>
                <%}
                   else if (clubMember.ClubMemberRole == ClubMemberRoles.ClubOwner)
                   {%>
                <%=GetResourceString("Enum_ClubMemberRoles_ClubOwner", applicationID)%>
                <%}
                   else if (clubMember.ClubMemberRole == ClubMemberRoles.ClubAssistant)
                   {%>
                <% if (isTopManager)
                   {%>
                <a href="javascript:;" class="tn-action-text" id="cancelClubAssistantA<%=clubMember.UserID %>"
                    onclick="cancelClubAssistantFunction(<%=clubMember.UserID %>)">
                    <%=GetResourceString("Action_CanceledAdmin", applicationID)%></a>
                <%}
                   else
                   {%>
                <%=GetResourceString("Label_Admin", applicationID)%>
                <%} %>
                <%}
                   else
                   {%>
                <%=GetResourceString("Label_Other", applicationID)%>
                <% }%>
            </td>
        </tr>
        <%}
                }
            }%>
    </tbody>
</table>
</form>
<div class="tn-pagination tn-helper-align-center">
    <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex, 7, SPBUrlHelper.Action("Control_ManageClubMembers", "ClubMember", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
</div>

<script type="text/javascript">
                    function pageIndexChange(url) {
                        $('#manageClubMemberDiv').load(url);
                    }

                    function resortMemberListForManage() {
                        $('#manageClubMemberDiv').load('<%=SPBUrlHelper.Action("Control_ManageClubMembers","ClubMember",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"pageIndex",ViewData.Model.PageIndex}}) %>' + '&clubMemberRoles=' + $("#clubMemberRolesDropDownList").val().toString() + '&clubMemberStatuses=' + $("#clubMemberStatusesDropDownList").val().toString());
                    }

                    function setClubAssistantFunction(userID) {
                        $.get('<%=SPBUrlHelper.Action("SetClubAssistant","ClubMember",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"pageIndex",returnToPageIndex}}) %>' + '&userID=' + userID.toString(), function(data) {
                            $("#setClubAssistantA" + userID.toString()).text("<%=GetResourceString("Label_AlreadySetBecomeAdmin",applicationID)%>");
                            $("#setClubAssistantA" + userID.toString()).attr("class", "false");
                        });
                    }

                    function cancelClubAssistantFunction(userID) {
                        $.get('<%=SPBUrlHelper.Action("CancelClubAssistant","ClubMember",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"pageIndex",returnToPageIndex}}) %>' + '&userID=' + userID.toString(), function(data) {
                            $("#cancelClubAssistantA" + userID.toString()).text("<%=GetResourceString("Label_AlreadyCanceledAdmin",applicationID)%>");
                            $("#cancelClubAssistantA" + userID.toString()).attr("class", "false");
                        });
                    }
                    $(document).ready(function(){
                    $("#deleteMembers").click(function(){
                    if ($("#manageClubMemberForm :checkbox:checked").length <= 0) {
                alert('<%=GetResourceString("Message_SelectOneMember",applicationID) %>');
                return false;
            }
                    $('#manageClubMemberForm').ajaxSubmit({target:'#manageClubMemberDiv',url:'<%=SPBUrlHelper.Action("DeleteClubMembers","ClubMember",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"clubMemberStatuses",currentClubMemberStatues},{"clubMemberRole",currentClubMemberRole},{"pageIndex",ViewData.Model.PageIndex}}) %>',type:'post'});
                    });
                    
                    $("#ApproveMember").click(function(){
                    if ($("#manageClubMemberForm :checkbox:checked").length <= 0) {
                alert('<%=GetResourceString("Message_SelectOneMember",applicationID) %>');
                return false;
            }
                    $('#manageClubMemberForm').ajaxSubmit({target:'#manageClubMemberDiv',url:'<%=SPBUrlHelper.Action("SetMembersStatus","ClubMember",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"updateStatus",ClubMemberStatuses.IsApproved},{"clubMemberRole",currentClubMemberRole},{"isPending",false},{"pageIndex",ViewData.Model.PageIndex}}) %>'+ '&status=' + $("#clubMemberStatusesDropDownList").val().toString()});
                    });
                    $("#NoApproveMember").click(function(){
                    if ($("#manageClubMemberForm :checkbox:checked").length <= 0) {
                alert('<%=GetResourceString("Message_SelectOneMember",applicationID) %>');
                return false;
            }
                    $('#manageClubMemberForm').ajaxSubmit({target:'#manageClubMemberDiv',url:'<%=SPBUrlHelper.Action("SetMembersStatus","ClubMember",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"updateStatus",ClubMemberStatuses.NotApproved},{"clubMemberRole",currentClubMemberRole},{"isPending",false},{"pageIndex",ViewData.Model.PageIndex}}) %>'+ '&status=' + $("#clubMemberStatusesDropDownList").val().toString()});
                    });
                    });
</script>

