﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<ForumSection>>" %>
<% string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
   int applicationID = ApplicationIDs.Instance().Club();%>
<%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Button_AddForumSection", applicationID),SPBUrlHelper.Action("EditForumSection", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%>
<table class="tn-table-grid">
    <tr class="tn-table-grid-header">
        <th class="tn-border-gray tn-border-bottom tn-text-note">
            <%=GetResourceString("Label_ForumSectionName", applicationID)%>
        </th>
        <th class="tn-border-gray tn-border-bottom tn-text-note">
            <%=GetResourceString("Label_Actions")%>
        </th>
    </tr>
    <%if (ViewData.Model != null && ViewData.Model.Count > 0)
      {

          foreach (var currentSection in ViewData.Model)
          {%>
    <tr class="tn-table-grid-row">
        <td class="tn-border-gray tn-border-bottom tn-width-auto">
            <%for (int i = 0; i < currentSection.Depth; i++)
              { Response.Write("&nbsp &nbsp "); } %>
            <a title="<%=currentSection.SectionName %>" href="<%=SiteUrls.Instance().ShowForumSectionInClub(clubDomainName,currentSection.SectionID) %>">
                <%=StringUtils.Trim(currentSection.SectionName,20)%></a>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap">
            <span class="tn-action">
                <a name="updateButton" href="<%=SPBUrlHelper.Action("EditForumSection","ClubForum",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"sectionID",currentSection.SectionID }}) %>">
                    <%=GetResourceString("Action_Edit")%></a>
            </span>
            <span class="tn-action tn-action-text-icon-right tn-action-has-drop-menu tn-border-trl"
                menu="#moreOptions3_<%=currentSection.SectionID%>">
                <span class="tn-icon tn-icon-triangle-down"></span>
                <a href="javascript:;" onclick="if (confirm('<%=GetResourceString("Message_DeleteForumSection",applicationID)%>')) { $('#listSectionForLoad').load('<%=SPBUrlHelper.Action("DeleteForumSection","ClubForum",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"sectionID",currentSection.SectionID}}) %>')}"
                    class="tn-action-text">
                    <%=GetResourceString("Action_Delete")%></a></span>
            <div id="moreOptions3_<%=currentSection.SectionID%>" class="tn-drop-menu ui-widget-content"
                style="display: none;">
                <ul class="tn-menu-drop-list">
                    <li class="tn-menu-drop-item">
                        <a href="<%=SPBUrlHelper.Action("ManageForumThreads", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "sectionID",currentSection.SectionID },{"groupID",currentSection.GroupID}})%>">
                            <%=GetResourceString("Action_ManageThread",applicationID)%></a></li>
                    <li class="tn-menu-drop-item">
                        <a href="<%=SPBUrlHelper.Action("ManageForumPosts", "ClubForum", new RouteValueDictionary {{"clubDomainName",clubDomainName},{"forumSectionSselect",currentSection.SectionID }})%>">
                            <%=GetResourceString("Action_ManagePost",applicationID)%></a></li>
                    <li class="tn-menu-drop-item">
                        <a title="<%=GetResourceString("Message_MoveForumSectionAndDeleteForumSection",applicationID)%>"
                            class="sectionModal" href="<%=SPBUrlHelper.Action("Control_MergeSection", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "filterID", currentSection.SectionID } })%>">
                            <%=GetResourceString("Action_Merge", applicationID)%></a></li>
                </ul>
            </div>
        </td>
    </tr>
    <%                  
        }
      }
    %>
</table>

<script type="text/javascript">
    $(document).ready(function() {
        $('.sectionModal').nyroModal({
            resizeable: true,
            endRemove: function(elts, settings) {
                $('#listSectionForLoad').load('<%=SPBUrlHelper.Action("Control_ManageForumSections","ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }}) %>');
            }
        });
        $("tr span[menu]").menuButton({ buttonHoverClass: 'ui-widget-content tn-action-hover' });
    }); 
</script>

