﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ClubMember>>" %>
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        if (messageType == StatusMessageType.Success)
        {
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessage", string.Empty), 4000));
        }
        TempData["StatusMessageType"] = null;
    }
    string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
    int applicationID = ApplicationIDs.Instance().Club();
%>
<spb:Script runat="server" ID="jquery_form" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    SetExpireDays="30" />
<%
    int returnToPageIndex = ViewData.Model.PageIndex;
    if (ViewData.Model.TotalRecords == ViewData.Model.PageIndex * ViewData.Model.PageSize + 1)
        returnToPageIndex = returnToPageIndex + 1; %>
<form id="manageClubMemberForm" method="post">
<div class="tn-list-header">
    <div class="tn-toolbar tn-helper-clearfix">
        <div class="tn-tool-form">
            <%=SPBHtmlHelper.Instance().Button("ApproveMember", GetResourceString("Button_Approve"), ButtonSizes.Default, HighlightStyles.Default, null, null)%>
            <%=SPBHtmlHelper.Instance().Button("NoApproveMember", GetResourceString("Button_NoApprove"), ButtonSizes.Default, HighlightStyles.Default, null, null)%>
        </div>
    </div>
</div>
<table class="tn-table-grid">
    <tbody>
                        <tr class="tn-table-grid-header">
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                <input class="tn-checkbox" type="checkbox" id="checkbox" onclick="checkAll(this,'clubMembersCheckBoxGroup')" />
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                               <%=GetResourceString("Label_UserName", applicationID)%> 
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                               <%=GetResourceString("Label_InviteUser", applicationID)%> 
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                <%=GetResourceString("Label_ApplyMessage", applicationID)%>
                            </th>
                            <th class="tn-border-gray tn-border-bottom tn-text-note">
                                <%=GetResourceString("Label_JoinDate", applicationID)%>
                            </th>
                        </tr>
                        <%
                            if (ViewData.Model != null && ViewData.Model.Records.Count > 0)
                            {
                                foreach (ClubMember clubMember in ViewData.Model.Records)
                                {
                                    if (clubMember != null)
                                    {%>
                        <tr class="tn-table-grid-row">
                            <td class="tn-border-gray tn-border-bottom tn-width-check">
                                <% 
                                    if (clubMember.ClubMemberRole != ClubMemberRoles.ClubOwner && clubMember.ClubMemberRole != ClubMemberRoles.ClubAssistant)
                                    {%>
                                <input class="tn-checkbox" type="checkbox" name="clubMembersCheckBoxGroup" value="<%=clubMember.UserID %>" />
                                <%} %>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                                <%=clubMember.DisplayName %>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                                <%=clubMember.InviteUserDisplayName %>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-width-auto">
                                <%=clubMember.ApplyRemark %>
                            </td>
                            <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                                <%=Formatter.FormatDate(clubMember.JoinDate) %>
                            </td>
                        </tr>
                        <%}
                                }
                            }%>
                    </tbody>
</table>
</form>
<div class="tn-pagination tn-helper-align-center">
    <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NumericNextPrevious, ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex,"pageIndexChange")%>
</div>

<script type="text/javascript">
    function pageIndexChange(url) {
        $('#manageClubMemberDiv').load(url);
    }
    $(document).ready(function() {

        $("#ApproveMember").click(function() {
            if ($("#manageClubMemberForm :checkbox:checked").length <= 0) {
                alert('<%=GetResourceString("Message_SelectOneMember",applicationID) %>');
                return false;
            }
            $('#manageClubMemberForm').ajaxSubmit({ target: '#manageClubMemberDiv', url: '<%=SPBUrlHelper.Action("SetMembersStatus","ClubMember",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"status",ClubMemberStatuses.Pending},{"updateStatus",ClubMemberStatuses.IsApproved},{"isPending",true},{"pageIndex",ViewData.Model.PageIndex}}) %>' });
        });
        $("#NoApproveMember").click(function() {
            if ($("#manageClubMemberForm :checkbox:checked").length <= 0) {
                alert('<%=GetResourceString("Message_SelectOneMember",applicationID) %>');
                return false;
            }
            $('#manageClubMemberForm').ajaxSubmit({ target: '#manageClubMemberDiv', url: '<%=SPBUrlHelper.Action("SetMembersStatus","ClubMember",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"status",ClubMemberStatuses.Pending},{"updateStatus",ClubMemberStatuses.NotApproved},{"isPending",true},{"pageIndex",ViewData.Model.PageIndex}}) %>' });
        });
    });
</script>

