﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<ForumSection>" %>
<% string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName"); %>
<%   
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        if (messageType == StatusMessageType.Success)
        {
            //关闭模式窗口            
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">$.nyroModalRemove();</script>"));
        }
        else
        {
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
        }
        TempData["StatusMessageType"]=null;
    }
    int applicationID = ApplicationIDs.Instance().Club();
%>
<%if (ViewData.Model != null)
  {
      ForumSection fromSection = ViewData.Model;%>
<form id="editor" action="<%=SPBUrlHelper.Action("MergeSection","ClubForum",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"fromSectionID",fromSection.SectionID}}) %>"
method="post" class="nyroModal">
<div class="tn-form tn-label-right">        
    <div class="tn-text-heading tn-border-gray tn-border-bottom">
              <h4>  <%=GetResourceString("Label_Merge", applicationID)%></h4>
        </div>
     <div class="tn-form-row">
              <label class="tn-form-label"> <%=GetResourceString("Label_CurrentlyForumSection", applicationID)%><%=GetResourceString("Common_Colon") %></label>
               <input type="text" class="textBox" maxlength="256" id="title" name="title" disabled="disabled"
                    value="<%=fromSection.SectionName %>" />
                <span class="tn-form-required"><%=GetResourceString("Description_Required")%></span>
      </div>
      <div class="tn-form-row">
              <label class="tn-form-label">  <%=GetResourceString("Label_TargetForumSection", applicationID)%><%=GetResourceString("Common_Colon") %></label>
              <%= SPBHtmlHelper.Instance().ForumSectionsDropDownList("sectionDDL", ViewData.GetInt("ClubID", 0), fromSection.SectionID, string.Empty, false, " --" +GetResourceString("Common_PleaseChoose") + "-- ", new RouteValueDictionary { { "Class", "dropDownList" } })%>
      </div>
      <div class="tn-form-row tn-form-row-button">
              <label class="tn-form-label"> </label>
             <%-- <input type="submit" value="<%=GetResourceString("Button_Save", applicationID)%>" id="SaveButton"  />
              <input type="button" value="<%=GetResourceString("Button_Cancel", applicationID)%>" class="inputCancel nyroModalClose" />--%>
              <%=SPBHtmlHelper.Instance().SubmitButton("SaveButton",GetResourceString("Button_Save", applicationID),ButtonSizes.Default,new RouteValueDictionary {{"class","inputSubmit"}},null) %>
              <%=SPBHtmlHelper.Instance().CancelButton(ButtonSizes.Default,new RouteValueDictionary {{"class","nyroModalClose"}}) %>
       </div>  
</div>
</form>
<%} %>

<script type="text/javascript" rel="forceLoad">
    <!--
        $(document).ready(function() {
            $("#editor").validate({
                rules: {
                    sectionDDL: "required"
                },
                messages: {
                    sectionDDL: "<%=GetResourceString("Validate_SectionDDL_PleaseChooseForumSection",applicationID)%>"
                }
            });

            $("#SaveButton").click(function() {
                if (!$("#editor").valid()) {
                    return false;
                  
                }
            });
        }); 
   //--> 
</script>

