﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<div class="tn-text-heading tn-border-gray tn-border-bottom">
    <h4>
        移动主题</h4>
</div>
<div class="tn-blank10">
</div>
<%    if (TempData["StatusMessageType"] != null)
      {
          StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
          Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), false));

          //关闭模式窗口
          if (messageType != StatusMessageType.Hint)
          {
              Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
          }
          TempData["StatusMessageType"] = null;
      }
      string strThreadIDs = ViewData.GetString("threadIDs");
      string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
      Club currentClub = Clubs.GetClub(clubDomainName, false);
      if (currentClub == null)
          currentClub = new Club();
    
%>
<%if (!string.IsNullOrEmpty(strThreadIDs))
  { %>
<form class="tn-helper-reset nyroModal" method="post" action="<%=SPBUrlHelper.Action("BatchMoveThreads","ClubForum",new RouteValueDictionary{{"clubDomainName",clubDomainName}}) %>"
id="MoveSection">
<div class="tn-form tn-label-right">
    <div class="tn-form-row">
        <label class="tn-form-label">
            目标版块：
        </label>
        <%=SPBHtmlHelper.Instance().ForumSectionsDropDownList("toSectionID", currentClub.ClubID, null, string.Empty, false, GetResourceString("Common_PleaseChoose"), new RouteValueDictionary { { "Class", "tn-dropdownlist" }, { "id", "sectionID" } })%>
    </div>
    <input type="hidden" name="threadIDs" value="<%=strThreadIDs %>" />
    <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label">
        </label>
        <%=SPBHtmlHelper.Instance().SubmitButton("","确定",ButtonSizes.Default,null,null) %>
        <%=SPBHtmlHelper.Instance().Button("", "取消", ButtonSizes.Default, HighlightStyles.Secondary, new RouteValueDictionary { { "class", "nyroModalClose" } } , null)%>
    </div>
</div>

<script type="text/javascript">
    $("#MoveSection").validate({
        rules: {
            toSectionID: { required: true }
        },
        messages: {
            toSectionID: { required: "请选择要移动的版块" }
        }
    });
</script>

</form>
<%} %>
