﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ClubMember>>" %>
<spb:Script runat="server" ID="qtip" Src="~/Utility/jquery/plugin/jquery.qtip-1.0.0-rc3.js"
    SetExpireDays="30" />
<% 
    int applicationID = ApplicationIDs.Instance().Club();

    string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
    ClubMembersSortBy clubMemberSortBy = ClubMembersSortBy.JoinDate;
    Club currentClub = ViewData.Get<Club>("currentClub");
    ICollection<ClubMember> clubAssistants = ViewData.Get<ICollection<ClubMember>>("clubAssistants", null);
    ClubMember clubOwner = ViewData.Get<ClubMember>("clubOwner", null);
    if (ViewData["SortBy"] != null)
        clubMemberSortBy = (ClubMembersSortBy)ViewData["SortBy"];
    int pageIndex = Html.GetParameterFromRouteDateOrQueryString("pageIndex", 0);
%>
<%if (pageIndex < 2)
  { %>

<div class="tn-list-header tn-helper-clearfix tn-border-gray tn-border-bottom">
  <div class="tn-list-header-row"> <strong> <%=GetResourceString("Title_ManageMember",applicationID) %></strong></div>
</div>
<ul id="clubManagerUL" class="tn-list tn-helper-clearfix">
  <li class="tn-list-item">
    <div class="tn-list-item-area-left">
      <div class="tn-avatar" value="<%=currentClub.ClubOwnerUserID %>"> <%=SPBHtmlHelper.Instance().ShowUserAvatar(currentClub.ClubOwnerUserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small,null)%></div>
    </div>
    <div class="tn-list-item-area-main">
      <div class="tn-list-item-row"> &nbsp<span class="tn-icon tn-icon-creator tn-icon-inline" title="<%=GetResourceString("Title_ClubOwner",applicationID) %>"></span> <a href="<%=SiteUrls.Instance().UserDomainHome(currentClub.ClubOwnerUserID)%>"><strong> <%=SPBHtmlHelper.Instance().UserDisplayName(currentClub.ClubOwner.UserID,true) %></strong></a> </div>
      <div class="tn-list-item-row"> <em class="tn-date tn-text-note"> <%=GetResourceString("Lable_ClubMembersSortBy_JoinDate",applicationID) %><%=GetResourceString("Common_Colon") %>
        <%if (clubOwner != null) { Response.Write(Formatter.FormatDate(clubOwner.JoinDate, false)); } %>
        </em> </div>
      <div class="tn-list-item-row"> <em class="tn-date tn-text-note"> <%=GetResourceString("Lable_ClubMembersSortBy_LastVisitTime", applicationID)%><%=GetResourceString("Common_Colon") %>
        <%if (clubOwner != null) { Response.Write(Formatter.FormatDate(clubOwner.VisitLastestDate, false)); } %>
        </em> </div>
    </div>
  </li>
  <% if (clubAssistants != null && clubAssistants.Count > 0)
       {
           foreach (ClubMember clubMember in clubAssistants)
           {
               if (clubMember != null)
               {%>
  <li class="tn-list-item">
    <div class="tn-list-item-area-left">
      <div class="tn-avatar" value="<%=clubMember.UserID %>"> <%=SPBHtmlHelper.Instance().ShowUserAvatar(clubMember.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small,null)%></div>
    </div>
    <div class="tn-list-item-area-main">
      <div class="tn-list-item-row"> &nbsp<span class="tn-icon tn-icon-manager tn-icon-inline" title="<%=GetResourceString("Title_ClubAssistant",applicationID) %>"> </span><a href="<%=SiteUrls.Instance().UserDomainHome(clubMember.UserID)%>"><strong> <%=SPBHtmlHelper.Instance().UserDisplayName(clubMember.User) %></strong></a> </div>
      <div class="tn-list-item-row"> <em class="tn-date tn-text-note"> <%=GetResourceString("Lable_ClubMembersSortBy_JoinDate",applicationID) %><%=GetResourceString("Common_Colon") %>
        <%if (clubMember != null) { Response.Write(Formatter.FormatDate(clubMember.JoinDate, false)); } %>
        </em> </div>
      <div class="tn-list-item-row"> <em class="tn-date tn-text-note"> <%=GetResourceString("Lable_ClubMembersSortBy_LastVisitTime", applicationID)%><%=GetResourceString("Common_Colon") %>
        <%if (clubMember != null) { Response.Write(Formatter.FormatDate(clubMember.VisitLastestDate, false)); } %>
        </em> </div>
    </div>
  </li>
  <%}
           } %>
  <%} %>
</ul>
<%} %>
<div class="tn-list-header tn-helper-clearfix tn-border-gray tn-border-bottom">
  <div class="tn-list-header-row"> <span class="tn-helper-right"> <%=GetResourceString("Label_SortOrder")%><%=GetResourceString("Common_Colon") %><span
                class="tn-action <%if (clubMemberSortBy == ClubMembersSortBy.JoinDate) { Response.Write(" tn-selected tn-text-note"); } %>"><a
                    class="tn-action-text" href="<%=SPBUrlHelper.Action("Home","ClubMember",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"sortBy",ClubMembersSortBy.JoinDate}}) %>"><%=GetResourceString("Lable_ClubMembersSortBy_JoinDate",applicationID) %></a></span><span
                        class="tn-action <%if (clubMemberSortBy == ClubMembersSortBy.LastVisitTime) { Response.Write(" tn-selected tn-text-note"); } %>"><a
                            class="tn-action-text" href="<%=SPBUrlHelper.Action("Home","ClubMember",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"sortBy",ClubMembersSortBy.LastVisitTime}}) %>"><%=GetResourceString("Lable_ClubMembersSortBy_LastVisitTime", applicationID)%></a></span></span> <strong> <%=GetResourceString("Title_ClubMember", applicationID)%></strong></div>
</div>
<ul id="clubMemberUL" class="tn-list tn-helper-clearfix">
  <% if (ViewData.Model != null && ViewData.Model.Records.Count > 0)
       {
           foreach (ClubMember clubMember in ViewData.Model.Records)
           {
               if (clubMember != null)
               {%>
  <li class="tn-list-item">
    <div class="tn-list-item-area-left">
      <div class="tn-avatar" value="<%=clubMember.UserID %>"> <%=SPBHtmlHelper.Instance().ShowUserAvatar(clubMember.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small,null)%></div>
    </div>
    <div class="tn-list-item-area-main">
      <div class="tn-list-item-row"> <a href="<%=SiteUrls.Instance().UserDomainHome(clubMember.UserID)%>"><strong>
        <%if (!string.IsNullOrEmpty(clubMember.DisplayName)) Response.Write(SPBHtmlHelper.Instance().UserDisplayName(clubMember.UserID,true)); else if (clubMember.User != null) Response.Write(SPBHtmlHelper.Instance().UserDisplayName(clubMember.User.UserID,true)); %>
        </strong></a></div>
      <div class="tn-list-item-row"> <em class="tn-date tn-text-note"> <%=GetResourceString("Lable_ClubMembersSortBy_JoinDate",applicationID) %><%=GetResourceString("Common_Colon") %>
        <%if (clubMember != null) { Response.Write(Formatter.FormatDate(clubMember.JoinDate, false)); } %>
        </em> </div>
      <div class="tn-list-item-row"> <em class="tn-date tn-text-note"> <%=GetResourceString("Lable_ClubMembersSortBy_LastVisitTime", applicationID)%><%=GetResourceString("Common_Colon") %>
        <%if (clubMember != null) { Response.Write(Formatter.FormatDate(clubMember.VisitLastestDate, false)); } %>
        </em></div>
    </div>
  </li>
  <%}
           } %>
  <%} %>
</ul>
<div class="tn-pagination tn-helper-align-center"> <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex)%> </div>
<script type="text/javascript">
    $(document).ready(function() {
        $("div.tn-avatar", $("#clubManagerUL,#clubMemberUL")).each(function() {
            var self = $(this);
            self.qtip({
                content: '<div class="tn-loading"></div>',
                position: {
                    corner: {
                        target: 'rightTop',
                        tooltip: 'leftTop'
                    },
                    adjust: {
                        screen: true
                    }
                },
                show: {
                    when: 'mouseover',
                    solo: true,
                    delay: 1000
                },
                hide: { when: 'mouseout', fixed: true, delay: 480 },
                style: {
                    tip: false,
                    border: {
                        width: 0,
                        radius: 0
                    },
                    background: 'none',
                    name: 'light',
                    width: 325,
                    padding: 1
                },
                api: { onShow: function() {
                    if (self.qtip('api').elements.content.is(":has(div.tn-loading)"))
                        $.get('<%=SPBUrlHelper.Action("Control_MemberCard", "Channel")%>', { userID: self.attr("value") }, function(data) {
                            self.qtip('api').updateContent(data);
                        });
                }
                }
            });
        });
    });
</script>
