﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ClubSharedContent>>" %>
<%int applicationID=ApplicationIDs.Instance().Club(); %>

<div class="tn-box tn-widget tn-widget-content tn-corner-all">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset">
      <%
                if (ViewData["application"] != null)
                {
                    Application a = ViewData["application"] as Application;
                    if (a != null)
                        Response.Write(string.Format(GetResourceString("Title_Pattern_MyShare",applicationID), a.GetMultilingualApplicationName(CurrentUserLanguage)));
                    else
                    {
                        Response.Write(GetResourceString("Title_MyShare", applicationID));
                    }
                }
                else
                {
                    Response.Write(GetResourceString("Title_MyShare", applicationID));
                }
            %>
    </h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <% 
            if (Model != null && Model.Records != null && Model.Records.Count > 0)
            { %>
    <ul class="tn-list">
      <%  foreach (var shareContent in Model.Records)
                    {
                        if (shareContent != null)
                        { %>
      <li><a href="<%=shareContent.DetailsUrl %>" title="<%=shareContent.Subject %>" target="_blank"> <%=StringUtils.Trim(shareContent.Subject, 15)%></a> </li>
      <%}
                    } %>
    </ul>
    <%}
    else
    {
        %>
    <%=GetResourceString("Message_NoShareContent", applicationID) %>
    <%} %>
  </div>
</div>
