﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    if (TempData["statusMessageData"] != null)
    {
        StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("statusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData));
        if (statusMessageData.MessageType == StatusMessageType.Success)
        {
            //关闭模式窗口
            Response.Write(string.Format("<script type=\"text/javascript\" rel=\"forceLoad\">setTimeout('$.nyroModalRemove();refresh();',2000)</script>"));
        }
        TempData["statusMessageData"] = null;
    }
    int shareContentID = Request.QueryString.GetInt("shareContentID", -1);
    string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
    int applicationID = ApplicationIDs.Instance().Club();
%>
<spb:Script runat="server" ID="jquery_form" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    ForceLoad="true" SetExpireDays="30">
</spb:Script>
<form id="EditUserTagForm" class="tn-helper-reset nyroModal" action="<%=SPBUrlHelper.Action("UpdateShareContentTag","ClubDomain",new RouteValueDictionary(){{"shareContentID",shareContentID},{"clubDomainName",clubDomainName}}) %>"
method="post">
<div class="tn-form tn-label-right">
    <h4 class="tn-text-heading tn-border-gray tn-border-bottom">
        <% 
            string tagNames = string.Empty;
            if (ViewData["tagNames"] != null)
            {
                Response.Write(GetResourceString("Title_UpdateTag", applicationID));
                tagNames = ViewData["tagNames"].ToString();
            }
            else
            { Response.Write(GetResourceString("Title_CreateTag", applicationID)); }
        %>
    </h4>
    <div class="tn-form-row">
        <label class="tn-form-label">
            <%=GetResourceString("Label_TagName", applicationID)%><%=GetResourceString("Common_Colon") %>
        </label>
        <input type="text" name="itemTag" id="itemTag" class="tn-textbox tn-input-long tn-border-gray"
            value="<%=tagNames %>" style="width: 200px" maxlength="100" />
    </div>
    <div class="tn-form-row">
        <label class="tn-form-label">
        </label>
        <%=GetResourceString("Description_TagMessage", applicationID)%>
    </div>
    <div class="tn-form-row tn-form-row-button">
        <label class="tn-form-label">
        </label>
        <%=SPBHtmlHelper.Instance().SubmitButton("postButton", GetResourceString("Button_OK"),ButtonSizes.Default,null ,null)%>
        <%=SPBHtmlHelper.Instance().CancelButton( new RouteValueDictionary {  { "class", "nyroModalClose" } })%>
    </div>
</div>
</form>

<script type="text/javascript">
    $(document).ready(function() {
        $("#EditUserTagForm").validate({
            rules: {
                itemTag: "required"
            },
            messages: {
                itemTag: "<%=GetResourceString("Validate_itemTag_PleaseWriteTagName",applicationID)%>"
            }
        });
        $("#postButton").click(function() {
            if (!$("#EditUserTagForm").valid()) {
                return false;
            }
            $("#postButton").hide();
            $("#postButton_ForHide").show();
        });
    }); 
</script>

