﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<ClubSharedContent>>" %>
<%int applicationID = ApplicationIDs.Instance().Club(); %>

<div class="tn-box tn-widget tn-widget-content tn-corner-all">
  <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <h3 class="tn-helper-reset">
      <%
                if (ViewData["application"] != null)
                {
                    Application a = ViewData["application"] as Application;
                    if (a != null)
                        Response.Write(string.Format(GetResourceString("Title_Pattern_ShareEssence", applicationID), a.GetMultilingualApplicationName(CurrentUserLanguage)));
                    else
                    {
                        Response.Write(GetResourceString("Title_ShareEssence", applicationID));
                    }
                }
                else
                {
                    Response.Write(GetResourceString("Title_ShareEssence", applicationID));
                }
            %>
    </h3>
  </div>
  <div class="tn-box-content tn-widget-content tn-corner-bottom">
    <% 
            if (Model != null && Model.Records != null && Model.Records.Count > 0)
            { %>
    <ul class="tn-list">
      <%  foreach (var shareContent in Model.Records)
                {
                    if (shareContent != null)
                    { %>
      <li><a class="tn-author tn-text-note tn-helper-right" href="<%=SiteUrls.Instance().UserDomainHome(shareContent.Sharer) %>"> <%=StringUtils.Trim(shareContent.Sharer,5) %></a><a href="<%=shareContent.DetailsUrl %>" title="<%=shareContent.Subject %>" target="_blank"> <%=shareContent.Subject%></a> </li>
      <%}
                    } %>
    </ul>
    <%}
            else
            {
        %>
    <%=GetResourceString("Message_NoShareContent", applicationID) %>
    <%} %>
  </div>
</div>
