﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<VoteThread>>" %>
<spb:Script runat="server" ID="jquery_form" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
    SetExpireDays="30" />
<%string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");

  Club currentClub = Clubs.GetClub(clubDomainName, false);
  if (TempData["StatusMessageData"] != null)
  {
      StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, string.Empty));
      Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData, 3000, false));
  }
  TempData["StatusMessageData"] = null;
%>
<%VoteScopes scopes = ViewData.Get<VoteScopes>("scopes", VoteScopes.myCreated);%>
<%if (Model.Records.Count > 0)
  { %>
<ul class="tn-list tn-helper-reset" id="ListMyVotes">
    <%
        foreach (VoteThread thread in Model.Records)
        {%>
    <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
        <div class="tn-list-item-area-left">
            <div class="tn-avatar">
                <a href="<%=SiteUrls.Instance().UserChannelHome(thread.UserID,ApplicationIDs.Instance().Vote()) %>">
                    <%=SPBHtmlHelper.Instance().ShowUserAvatar(thread.UserID,false,HyperLinkTarget._blank,AvatarSizeTypes.Small) %></a>
            </div>
        </div>
        <div class="tn-list-item-area-right">
            <div class="tn-list-figure tn-widget">
                <div class="tn-list-figure-count tn-widget-content tn-corner-top">
                    <%=thread.VoterCount%></div>
                <a class="tn-list-figure-button tn-state-default tn-corner-bottom" href="<%=SPBUrlHelper.Action("ShowClubVoteThread","ClubVote",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"threadID",thread.ThreadID}}) %>">
                    <%= GetResourceString("Label_GoVote", ApplicationIDs.Instance().Vote())%></a>
            </div>
        </div>
        <div class="tn-list-item-area-main">
            <div class="tn-list-item-row">
                <h5 class="tn-helper-reset">
                    <a target="_blank" href="<%=SPBUrlHelper.Action("ShowClubVoteThread", "ClubVote", new RouteValueDictionary { { "clubDomainName", clubDomainName }, {"threadID",thread.ThreadID} }) %>"
                        title="<%=StringUtils.Trim(thread.Subject,200)%>">
                        <%=StringUtils.Trim(thread.Subject, 22)%></a></h5>
            </div>
            <div class="tn-list-item-row">
                <cite><a href="<%=SiteUrls.Instance().UserDomainHome(thread.UserID) %>" title="<%=thread.Author%>">
                    <%=thread.Author%></a></cite> <em class="tn-date tn-text-note">
                        <%=GetResourceString("Label_VoteStartTime", ApplicationIDs.Instance().Vote())%>
                        <%=Formatter.FormatFriendlyDate(thread.DateCreated)%></em> <em class="tn-date tn-text-note">
                            <%=GetResourceString("Label_IsTime", ApplicationIDs.Instance().Vote())%>
                            <%=Formatter.FormatFriendlyDate(thread.EndDate)%></em>
            </div>
            <div class="tn-list-item-row tn-list-item-summary">
                <%if (thread.VoteOptions.Count >= 0)
                  {
                      foreach (KeyValuePair<int, VoteOption> pair in thread.VoteOptions.Take(2))
                      {%>
                <%if (thread.IsMultiple)
                  { %>
                <p class="tn-helper-reset">
                    <input class="tn-checkbox" type="checkbox" disabled="disabled" />
                    <%=StringUtils.Trim(pair.Value.OptionName, 7)%>
                </p>
                <%}
                  else
                  { %>
                <p class="tn-helper-reset">
                    <input class="tn-radiobutton" type="radio" disabled="disabled" />
                    <%=StringUtils.Trim(pair.Value.OptionName, 7)%>
                </p>
                <%}
                      }
                      Response.Write("<p class=\"tn-helper-reset\">……</p>");
                  } %>
            </div>
            <div class="tn-list-item-row">
                <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Common_Browse") + "&nbsp;" + thread.StageHitTimes, SPBUrlHelper.Action("ShowClubVoteThread", "ClubVote", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "threadID", thread.ThreadID }, { "isResult", null } }), ButtonSizes.Default, HighlightStyles.Lite, IconTypes.View, TextIconLayout.IconText)%>
                <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Common_Comment") + "&nbsp;" + thread.CommentCount, SPBUrlHelper.Action("ShowClubVoteThread", "ClubVote", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "threadID", thread.ThreadID }, { "isResult", null } }) + "#comments", ButtonSizes.Default, HighlightStyles.Lite, IconTypes.Bubble, TextIconLayout.IconText)%>
                <%if (CurrentUser != null && (CurrentUser.IsAdministrator || CurrentUser.UserID == currentClub.ClubOwnerUserID || CurrentUser.UserID == thread.UserID))
                  { %>
                <span class="tn-action"><a onclick="if(!confirm('<%= GetResourceString("Validate_AskDeleteVote",ApplicationIDs.Instance().Vote()) %>')) return false;"
                    href="<%=SPBUrlHelper.Action("DeleteVote","ClubVote",new RouteValueDictionary{ {"threadID",thread.ThreadID},{"userID",thread.UserID},{"clubID",currentClub.ClubID},{"returnUrl",Request.RawUrl}}) %>"
                    class="tn-action-text">
                    <%=GetResourceString("Action_Delete")%></a></span>
                <%} %>
            </div>
        </div>
    </li>
    <%} %>
</ul>
<div class="tn-pagination tn-helper-align-center">
    <%=SPBHtmlHelper.Instance().AjaxPagingButton(Model.TotalRecords, Model.PageSize, Model.PageIndex, 11,
                                                 SPBUrlHelper.Action("Control_ListClubVotethreads", "ClubVote", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "pageIndex", "{0}" } }), "pageIndexChange")%>
    <div class="tn-page-results tn-text-note">
        <%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%>
    </div>
</div>
<%}
  else
  {
      Response.Write("<h3>" + GetResourceString("Title_IsNotHaveVote", ApplicationIDs.Instance().Vote()) + "</h3>");
  } %>

<script type="text/javascript">
    function pageIndexChange(url) {
        $('#ListVotes').parent().load(url);
    }
</script>

