﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<IList<VoteThread>>" %>
<%
    if (Model != null && Model.Count > 0)
    {
        string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
        int applicationID = ApplicationIDs.Instance().Vote();
        int style = ViewData.GetInt("Style", (int)ListBlockStyle.Detailed);
        bool hasBorder = ViewData.GetBool("hasBorder", false);
%>
<ul class="<%if (style == (int)ListBlockStyle.Detailed) Response.Write("tn-helper-reset tn-list"); else Response.Write("tn-helper-reset tn-helper-clearfix tn-list tn-list-triserial"); %>">
    <%foreach (VoteThread thread in Model)
      {
          if (thread == null)
              continue;
          if (style == (int)ListBlockStyle.Detailed)
          {%>
    <li><em class="tn-text-note tn-date tn-helper-right">
        <%=GetResourceString("Label_FromIssue", applicationID)%><%=GetResourceString("Common_Colon")%><%=Formatter.FormatFriendlyDate(thread.DateCreated)%></em><cite
            class="tn-helper-right"><a class="tn-text-note tn-author" href="<%=SiteUrls.Instance().UserChannelHome(thread.UserID,applicationID) %>"><%=thread.Author%></a></cite><a
                href="<%=SiteUrls.Instance().ShowClubVoteThread(clubDomainName,thread.ThreadID,true) %>"
                title="<%=thread.Subject %>"><%=StringUtils.Trim(thread.Subject, 20)%>
            </a><em class="tn-count tn-text-note">
                <%Response.Write(thread.VoterCount + GetResourceString("Label_PartIn", applicationID));%>
            </em></li>
    <%}
                  else
                  {%>
    <li><a href="<%=SiteUrls.Instance().ShowVoteThread(thread.ThreadID) %>" title="<%=thread.Subject %>">
        <%=StringUtils.Trim(thread.Subject, 11)%></a></li>
    <%}
              }%>
</ul>
<div class="tn-blank10">
</div>
<%} %>
