﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<PagingDataSet<VoteRecord>>" %>
<%  string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
    if (Model != null)
    {
        int optionID = ViewData.GetInt("optionID", 0);%>
<ul class="tn-avatar-list tn-helper-reset">
    <% 

        if (optionID > 0)
        {

            foreach (VoteRecord voteRecord in Model.Records)
            {%>
    <li class="tn-avatar-item">
        <%if (voteRecord.IsAnonymousVote)
          { %>
        <div class="tn-avatar">
            <%=SPBHtmlHelper.Instance().ShowUserAvatar(0, AvatarSizeTypes.Small)%><span class="tn-round-corner"></span></div>
        匿名用户
        <%}
          else
          { %>
        <div class="tn-avatar">
            <%=SPBHtmlHelper.Instance().ShowUserAvatar(voteRecord.UserID, true, HyperLinkTarget._blank, AvatarSizeTypes.Small)%><span
                class="tn-round-corner"></span></div>
        <a href="<%=SiteUrls.Instance().UserDomainHome(voteRecord.UserID) %>" class="tn-user-name">
            <%=SPBHtmlHelper.Instance().UserDisplayName(voteRecord.UserID)%>
        </a>
        <%} %>
    </li>
    <%}
        } %>
</ul>
<%if (Model.TotalRecords > Model.PageSize)
  { %>
<div class="tn-pagination tn-helper-align-right">
    <%=SPBHtmlHelper.Instance().AjaxPagingButton(PaginationMode.NextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 0, SPBUrlHelper.Action("Control_ListOptionVoters", "ChannelVote", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "optionID", optionID }, { "pageSize", ViewData.GetInt("pageSize", 8) }, { "pageIndex", "{0}" } }), "pageIndexChange_" + optionID)%>
</div>
<%} %>

<script type="text/javascript">
    function pageIndexChange_<%=optionID %>(url) {
        $('#RecordForLoad_<%=optionID %>').load(url);
    }
    
</script>

<%} %>
