﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl<List<VoteThread>>" %>
<div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <%string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");%>
        <% VoteThreadSortBy sortBy = ViewData.Get<VoteThreadSortBy>("sortBy");%>
        <h3 class="tn-helper-reset">
            <%=ViewData.GetString("title",string.Empty)%>
        </h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <ul class="tn-helper-reset tn-list">
            <%if (Model.Count > 0)
              { %>
            <%
                foreach (VoteThread thread in Model)
                {
                    Club ownerClub = Clubs.GetClub(thread.OwnerID, false);
            %>
            <li><em class="tn-count tn-text-note tn-helper-right">
                <%if (sortBy == VoteThreadSortBy.StageHitTimes)
                  { %><%=thread.StageHitTimes %><%}
                  else
                  { %><%=thread.HitTimes %><%} %></em><a target="_blank" href="<%=SiteUrls.Instance().ShowVoteThread(thread.ThreadID) %>"
                          title="<%=thread.Subject %>">
                          <%=StringUtils.Trim(thread.Subject,25) %></a></li>
            <%}
              }
              else
              { %>
            <li><span>
                <%=GetResourceString("Title_IsNotHaveVote",ApplicationIDs.Instance().Vote())%></span></li>
            <%} %>
        </ul>
    </div>
</div>
<div class="tn-blank10">
</div>
