﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ClubDomainViewPage<Club>" %>

<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server">
    id="Club-ApplyClubMember"
</asp:content>
<asp:content contentplaceholderid="mainContent" runat="server">
            <% 
                Club club = (Club)ViewData.Model;

                int inviteUserID = ViewData.GetInt("inviteUserID");
                int currentUserID = 0;
                if (CurrentUser != null)
                    currentUserID = CurrentUser.UserID;
                int applicationId = ApplicationIDs.Instance().Club();
                bool isAllowApply = ViewData.GetBool("isAllowApply", true);
                            %>
    
          <%if (!isAllowApply)
            {
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Hint, string.Format("{3}{2}<a href=\"{0}\">{1}</a>", SiteUrls.Instance().ClubDomainHome(club.DomainName), club.ClubName, GetResourceString("Message_LookClubDomainHome", applicationId), GetResourceString("Message_YouAlreadyBecomeMember", applicationId)), false));
            }
            else
            { %>
             <div class="tn-box tn-widget tn-widget-content tn-corner-all">
          <div class="tn-box-content tn-widget-content tn-corner-all">
                <%
                    if (TempData["StatusMessageType"] != null)
                    {
                        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                        if (messageType == StatusMessageType.Success)
                            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, string.Format("{0}<a href=\"{1}\">{4}{2}</a>，<a href=\"{3}\">{5}</a>", TempData.GetString("StatusMessageSuccessMessage", string.Empty), SiteUrls.Instance().ClubDomainHome(club.DomainName), club.ClubName, SiteUrls.Instance().ChannelClubHome(), GetResourceString("Message_LookClubDomainHome", applicationId), GetResourceString("Message_GoChannelClubHome", applicationId)), false));
                        else if (messageType == StatusMessageType.Error)
                            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageSuccessMessage", GetResourceString("Message_CreateError", applicationId)), false));
                        else if (messageType == StatusMessageType.Hint)
                            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageSuccessMessage", string.Empty)));

                        TempData["StatusMessageType"] = null;
                        TempData["StatusMessageSuccessMessage"] = null;
                    }%>
              
          <div class="tn-widget">
                <div class="tn-cue-tips tn-corner-all tn-message-box tn-widget-content tn-border-gray tn-bg-gray"><span class="tn-helper-left"><span class="tn-icon tn-icon-exclamation"></span></span>
                  <div class="tn-helper-flowfix"> <strong><%=GetResourceString("Message_Tips") %><%=GetResourceString("Common_Colon") %></strong>
                  <% if (club.IsMemberNeedAuthorize)
                     { %>
                  <%=string.Format(GetResourceString("Description_Pattern_IsMemberNeedAuthorizeTrue", applicationId), club.ClubName)%>
                  <%}
                     else if (!club.IsPublic)
                     {
                         Response.Write(club.ClubName + "的类型属于“私密”，提交申请后需要群组管理员审核，审核通过才能加入群组");
                     }
                     else
                     { %>
                  <%=string.Format(GetResourceString("Description_Pattern_IsMemberNeedAuthorizeFlase", applicationId), club.ClubName)%>
                  <%} %>
                  <%if (!string.IsNullOrEmpty(club.JoinNotice))
                    { %>
                  <div><%=GetResourceString("Description_JoinNotice", applicationId)%><%=GetResourceString("Common_Colon") %><%=club.JoinNotice %></div>
                  <%} %>
                  </div>
                </div>
              </div>
           <div class="tn-blank10"></div>
          <form id="CreateClubMemberForm" class="tn-helper-reset" action="<%=SPBUrlHelper.Action("ApplyClubMemberManage","ClubDomain",new RouteValueDictionary{{"clubDomainName",club.DomainName},{"inviteUserID",inviteUserID}}) %>"
                            method="post">
                
                <div class="tn-form tn-label-top">
                  <div class="tn-form-row">
                    <div class="tn-form-label"><%=GetResourceString("Label_ApplyMessage", applicationId)%><%=GetResourceString("Common_Colon") %></div>
                      <textarea class="tn-textarea tn-input-longest tn-border-gray" id="applyRemark" name="applyRemark"></textarea>
                      <div class="tn-text-note"><%=GetResourceString("Description_applyRemark", applicationId)%></div>
                  </div>
                  <div class="tn-form-row tn-form-row-button">
                    <div class="formButton">
                      <%=SPBHtmlHelper.Instance().SubmitButton("saveButton", GetResourceString("Button_ApplyClubMember", applicationId), ButtonSizes.Default,new RouteValueDictionary{{"onclick","applyClubMemberSaveFunction();"}},null)%></div>
                  </div>
                </div>
            </form>
            <script type="text/javascript">
                      $(document).ready(function(){
                           $("#CreateClubMemberForm").validate({
		                       rules: {
			                    applyRemark: {required:true,maxBlength:500}
		                      },
		                      messages: {
			                    applyRemark: {required:"<%=GetResourceString("Validate_PleaseWriteApplyMessage", applicationId)%>",maxBlength:"<%=GetResourceString("Validate_LengthForApplyMessage", applicationId)%>"}
		                      }
                            });
                      });
                      
                      var applyClubMemberSaveFunction = function(){
                        if ($("#CreateClubMemberForm").valid()) {
                            $("#saveButton").hide();
                            $("#saveButton_ForHide").show();
                        }
                        else{
                            return false;
                        }
                      }
       </script>
       </div>
        </div>
       <%} %>
          
</asp:content>
