﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ClubDomainViewPage<IList<EventThread>>" %>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="Club-Event-Home"
</asp:content>
<asp:content contentplaceholderid="outerContent" runat="server">
 <%  string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");%>
<div class="tn-wrapper tn-template-r-230 tn-helper-clearfix">
<%=SPBHtmlHelper.Instance().ShowAdvertisingInClubDomain("001300000001", clubDomainName, new RouteValueDictionary { { "class", "spb-ad-banner" } })%>
                    <div class="tn-main">
                        <div class="tn-block">
                            <div id="ListClubEvents">
        <% Html.RenderAction<ClubEventController>(n => n.Control_ListEvents(Html.GetParameterFromRouteDateOrQueryString("ClubDomainName"), null, null, null)); %>
    </div>
                        </div>
                    </div>
                    <div class="tn-block">
                        <%int applicatinID = ApplicationIDs.Instance().Club();
  int EventApplicationID = ApplicationIDs.Instance().Event(); %>
    <div class="tn-box tn-widget tn-widget-content tn-corner-all">
        <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
            <% if (Model.Count >= 10)
               { %>
          <span class="tn-helper-right"> <a href="javascript:;" onclick="$('#ListClubEvents').load('<%=SPBUrlHelper.Action("Control_ListEvents","ClubEvent",new RouteValueDictionary{{"clubDomainName",Html.GetParameterFromRouteDateOrQueryString("ClubDomainName")},{"sortBy",EventThreadSortBy.MemberCount}}) %>');"
                ><%=GetResourceString("Action_More")%></a></span> 
            <%} %>
            <h3 class="tn-helper-reset">
                <%=GetResourceString("Title_HotClubEvent",applicatinID) %></h3>
        </div>
        <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <ul class="tn-helper-reset tn-list">
            <%foreach (EventThread thread in ViewData.Model)
              { 
            %>
            <li class="tn-img-sprite tn-list-bullet"><a href="<%=SiteUrls.Instance().ShowEvent(thread.EventID) %>" title="<%=thread.EventName %>">
                <%=StringUtils.Trim( thread.EventName ,15)%></a><br />
                <em class="tn-date tn-text-note">
                    <%=EventDateFormatter.FormatDate(thread.StartTime, false)%>
                </em><em class="tn-location"><a href="<%=Globals.GetFullUrlInMainSite(SPBUrlHelper.Action("Search","ChannelEvent",new RouteValueDictionary{{"areaCode",thread.AreaCode}})) %>"
                    title="<%=string.Format(GetResourceString("Description_Pattern_CheckAllEvent", EventApplicationID), Formatter.FormatArea(thread.AreaCode,true)) %>">
                    <%=StringUtils.Trim(Formatter.FormatArea(thread.AreaCode,1,2),8)%></a></em><br />
                <em class="tn-count tn-text-note">
                    <%=thread.HitTimes %><%=GetResourceString("Label_Scan", ApplicationIDs.Instance().Event())%></em>
                <em class="tn-count">
                 <a href="<%=SPBUrlHelper.Action("ListEventMembers", "ChannelEvent", new RouteValueDictionary { { "eventID", thread.EventID } })%>">    <%=thread.MemberCount %><%=GetResourceString("Label_Attend", ApplicationIDs.Instance().Event())%></a></em></li>
            <%} %>
        </ul>
            </div>
    </div>
                    </div>
                    <%=SPBHtmlHelper.Instance().ShowAdvertisingInClubDomain("001300000002", clubDomainName, new RouteValueDictionary { { "class", "spb-ad-banner-bottom" } })%>
                </div>
    
</asp:content>
