﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ClubDomainViewPage<PagingDataSet<ForumThread>>" %>

<asp:content contentplaceholderid="outerContent" runat="server">
 <%int applicationID = ApplicationIDs.Instance().Forum();
   string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");%>
<div class="tn-wrapper tn-template-r-230 tn-helper-clearfix">
    <%=SPBHtmlHelper.Instance().ShowAdvertisingInClubDomain("001300000001", clubDomainName, new RouteValueDictionary { { "class", "spb-ad-banner" } })%>
    <div class="tn-main">
        <div class="tn-block">
            <div class="ui-tabs ui-widget ui-widget-content ui-corner-all spb-topics-list" id="tabs">
                <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
                    <li class="ui-state-default ui-corner-top">
                        <a href="#tabs-1">
                            <span>
                                <%=GetResourceString("Action_LastRepliedDate",applicationID) %></span></a></li>
                    <li class="ui-state-default ui-corner-top">
                        <a href="<%=SPBUrlHelper.Action("Control_ListForumThreads", "ClubForum", new RouteValueDictionary { {"clubDomainName",clubDomainName},{"sortBy",ForumThreadSortBy.PostDate}})%>">
                            <span>
                                <%=GetResourceString("Title_NewThread", applicationID)%></span></a></li>
                    <li class="ui-state-default ui-corner-top">
                        <a href="<%=SPBUrlHelper.Action("Control_ListForumThreads", "ClubForum", new RouteValueDictionary { {"clubDomainName",clubDomainName},{"sortBy",ForumThreadSortBy.ReplyCount}})%>">
                            <span>
                                <%=GetResourceString("Action_MostReplay",applicationID) %></span></a></li>
                    <li class="ui-state-default ui-corner-top">
                        <a href="<%=SPBUrlHelper.Action("Control_ListForumThreads", "ClubForum", new RouteValueDictionary { {"clubDomainName",clubDomainName},{"sortBy",ForumThreadSortBy.StageHitTimes}})%>">
                            <span>
                                <%=GetResourceString("Action_WeekHitTimes",applicationID) %></span></a></li>
                </ul>
                <div class="ui-tabs-panel ui-widget-content ui-corner-bottom" id="tabs-1">
                    <%Html.RenderAction<ClubForumController>(n => n.Control_ListForumThreads(clubDomainName, ForumThreadSortBy.LastRepliedDate, null, Request.QueryString.GetInt("pageIndex", 1))); %>
                </div>
            </div>

            <script type="text/javascript">
                $(document).ready(function() {
                    $(".ui-tabs").tabs();
                });
            </script>

        </div>
    </div>
    <div class="tn-block">
        <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-search-box">
          <div class="tn-box-content tn-widget-content tn-corner-all">
            <div class="tn-search-box tn-helper-clearfix">
            
              <form method="get" action="<%=SPBUrlHelper.Action("Search", "ClubForum", new RouteValueDictionary { {"clubDomainName",clubDomainName}})%>" name="searchForum" id="searchForum">
                <input type="text" name="Keyword" maxlength="50" class="tn-search-input tn-border-gray tn-border-tbl" />
                <span class="tn-search-button tn-search-ico-button tn-border-gray tn-bg-gray">
                <button onclick="$('#searchForum').submit();"> <span class="tn-icon tn-icon-find"></span> </button>
                </span>
              </form>
            </div>
          </div>
        </div>
        <div class="tn-blank10">
        </div>
        <% Html.RenderAction<ClubForumController>(n => n.Control_ListSectionsBlock(Html.GetParameterFromRouteDateOrQueryString("clubDomainName"))); %>
    </div>
    <%=SPBHtmlHelper.Instance().ShowAdvertisingInClubDomain("001300000002", clubDomainName, new RouteValueDictionary { { "class", "spb-ad-banner-bottom" } })%>
</div>
 
</asp:content>
<asp:content contentplaceholderid="wideContentRegion" runat="server">
</asp:content>
