﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ClubDomainViewPage<SearchResultDataSet<ForumThread>>" %>

<asp:content runat="server" contentplaceholderid="mainContent">
<%int pageIndex = Html.GetParameterFromRouteDateOrQueryString("pageIndex", 1);
  string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
  ForumPostFullTextQuery query = ViewData.Get<ForumPostFullTextQuery>("Query", null);
  int applicationID = ApplicationIDs.Instance().Forum();
    %>
    <div class="tn-box tn-widget tn-widget-content tn-corner-all"
    id="FourmPostResult">
    <div class="tn-box-content tn-widget-content tn-corner-all">
        <div class="spb-search-results-box">
            <form action="<%=SPBUrlHelper.Action("Search", "ClubForum", new RouteValueDictionary { {"clubDomainName",clubDomainName}})%>" id="searchFourms">
                <div class="tn-form tn-form-single">
                    <input type="text" value="<%=query.Keyword %>" id="forumKeyword" name="Keyword" class="tn-textbox tn-border-gray" style="width: 475px; height:23px;" />
                    <%=SPBHtmlHelper.Instance().SubmitButton("", GetResourceString("Button_Search"), ButtonSizes.Large, null, null)%> 
                </div>
            </form>
        </div>
        <%if (Model != null && Model.Records.Count <= 0)
          {%>
        <div class="tn-list-header">
            <%  Html.RenderPartial("Controls/Forums/NoSearchResult.ascx");%>
        </div>
          <%}
          else
          { %>
         <div>
           <div class="tn-list-header">
               <div class="tn-list-header-row tn-helper-clearfix tn-border-gray tn-border-bottom">
                   <span class="tn-text-note"><%=string.Format(GetResourceString("Description_Pattern_SearchHint", applicationID), Model.TotalRecords, Model.SearchDuration)%></span>
               </div>
           </div>
           <ul class="tn-list tn-helper-reset">
           <%foreach (ForumThread thread in Model.Records)
             { %>
             <li class="tn-list-item tn-helper-clearfix tn-border-gray tn-border-bottom">
               <div class="tn-list-item-area-main">
                 <div class="tn-list-item-row tn-list-item-heading">
                   <h5 class="tn-helper-reset"> <a href="<%=SPBUrlHelper.Action("ShowForumThread", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "threadID", thread.ThreadID } })%>" title="<%=HtmlUtils.StripAllTags(thread.Subject) %>"><%=thread.Subject %></a></h5>
                 </div>
                 <div class="tn-list-item-row tn-list-item-summary">
                   <p class="tn-helper-reset"><%=HtmlUtils.StripForPreview(thread.Body) %></p>
                 </div>                                                                                                   
                 <div class="tn-list-item-row"><cite>
                 <%=SPBHtmlHelper.Instance().UserDisplayNameLink(thread.UserID,thread.Author,applicationID) %>
                 </cite> <em class="tn-date tn-text-note"> <%=GetResourceString("Label_Issue",applicationID) %><%=Formatter.FormatFriendlyDate(thread.PostDate,false)%></em></div>
               </div>
             </li>
             <%} %>
           </ul>
           <div class="tn-pagination tn-helper-align-center">
           <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious,Model.TotalRecords,Model.PageSize,Model.PageIndex) %>
           </div>
        </div>
        <%} %>
    </div>
</div>
</asp:content>
<asp:content runat="server" contentplaceholderid="sidebarContent">
<%Html.RenderAction<ClubForumController>(n => n.Control_ListSectionsBlock(Html.GetParameterFromRouteDateOrQueryString("clubDomainName"))); %>
</asp:content>
<asp:content contentplaceholderid="wideContentRegion" runat="server">
</asp:content>
