﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ClubDomainViewPage<PagingDataSet<ForumThread>>" %>

<asp:content contentplaceholderid="sidebarContent" runat="server">
  <% Html.RenderAction<ClubForumController>(n => n.Control_ListSectionsBlock(Html.GetParameterFromRouteDateOrQueryString("clubDomainName"))); %>
</asp:content>
<asp:content contentplaceholderid="mainContent" runat="server">
<spb:Script runat="server" ID="Script1" Src="~/Utility/jquery/plugin/jquery.spb.CollapsibleBox.js" SetExpireDays="30" />    
<spb:Script runat="server" ID="menuButton" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js" SetExpireDays="30" />
  <% int applicationID = ApplicationIDs.Instance().Forum();
     ForumSection section = ViewData["Section"] as ForumSection;
     int categoryID = Request.QueryString.GetInt("categoryID", 0);
     int sortBy = ViewData.GetInt("sortBy");
     int? scopes = (int?)ViewData["scopes"];
     bool? isEssential = Html.GetParameterFromRouteDateOrQueryString<bool>("isEssential");
     if (!isEssential.Value) isEssential = null;
     int pageIndex = Request.QueryString.GetInt("pageIndex", 1);
     int listID = Html.GetParameterFromRouteDateOrQueryString("ListID", 0);
     bool hasManagePermissions = CurrentUser != null && (CurrentUser.IsAdministrator || CurrentUser.IsContentAdministrator);
     string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
     RouteValueDictionary routeDictionary = new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "sectionID", section != null ? section.SectionID : 0 }, { "isEssential", isEssential }, { "categoryID", categoryID }, { "scopes", scopes }, { "sortBy", sortBy } };
     int i = 0;
     RouteValueDictionary categoriesRoute = new RouteValueDictionary(routeDictionary);
     categoriesRoute.Remove("categoryID");

     if (section != null && pageIndex <= 1)
     {%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-forum-details">
  <div class="tn-box-content tn-widget-content tn-corner-all">
    <div class="spb-head tn-helper-clearfix">
      <div class="spb-forum-icon">
        <%if (!string.IsNullOrEmpty(section.LogoUrl))
          {%>
           <img src="<%=SiteUrls.Instance().ForumSectionLogoUrl(section) %>" alt="" />
           <%}
          else
          {
              string iconSection = "<span class=\"{0}\"></span>";
              Response.Write(section.TodayPostCount > 0 ? string.Format(iconSection, "tn-icon tn-icon-big tn-icon-forum-new") : string.Format(iconSection, "tn-icon tn-icon-big tn-icon-forum-normal"));
          }%>
      </div>
      <div class="tn-actions"><span class="tn-action tn-action-text-icon"><span class="tn-icon tn-icon-feed" title="<%=GetResourceString("Description_UseRss",applicationID)%>"></span><a class="tn-action-text" href="<%=SiteUrls.Instance().ForumRss(section.SectionID,(ForumThreadSortBy)sortBy,isEssential)%>"><%=GetResourceString("Action_Subscribe",applicationID) %></a> </span>
      <% if (hasManagePermissions || section.IsModerator(CurrentUser != null ? CurrentUser.UserID : 0))
         {%>
      <span class="tn-action"><a class="tn-action-text" href="<%=SPBUrlHelper.Action("ManageForumSections", "ClubForum", new RouteValueDictionary { {"clubDomainName",clubDomainName}})%>"><%=GetResourceString("Action_ManageSections",applicationID)%></a></span>
      <%} %>                                                  
      </div>
      <div class="spb-forum-info">
        <h2 class="tn-helper-reset"><%=section.SectionName%></h2>
        <em><%=GetResourceString("Action_Today",applicationID) %><%=GetResourceString("Common_Colon") %><%if (section.TodayPostCount > 0) Response.Write(string.Format("<strong>{0}</strong>", section.TodayPostCount)); else Response.Write("0"); %> </em><em><%=GetResourceString("Label_Thread", applicationID)%><%=GetResourceString("Common_Colon")%><%=section.CumulateThreadCount%></em><em><%=GetResourceString("Label_Topic",applicationID) %><%=GetResourceString("Common_Colon")%><%=section.CumulatePostCount%></em>        
        <%if (section.Moderators != null && section.Moderators.Count > 0)
          {%>
          <p class="tn-helper-reset"><%=GetResourceString("Label_Host",applicationID)%><%=GetResourceString("Common_Colon") %>
          <%foreach (ForumModerator moderator in section.Moderators)
            {
                if (moderator.Inherited) continue;%>                           
          <a class="tn-user-name" href="<%=SiteUrls.Instance().UserChannelHome(moderator.UserID, applicationID)%>"><%=moderator.DisplayName%></a>
          <%}%>
        </p>
       <%}%>
      </div>
    </div>
    <div class="spb-body">
    <%if (!string.IsNullOrEmpty(section.Description))
      { %>
      <div class="tn-collapsible tn-collapsible-opened">
        <div class="tn-border-bottom tn-border-gray tn-collapsible-header tn-switch-left">
          <h4 class="tn-helper-reset"><%=GetResourceString("Action_SectionDescription", applicationID)%></h4>
          <span class="tn-icon tn-switch tn-icon-collapse-close"></span><span class="tn-icon tn-switch tn-icon-collapse-close"></span></div>
        <div style="" class="tn-collapsible-content">
          <p> <%=section.Description%></p>
        </div>
      </div>
      <%} if (!string.IsNullOrEmpty(section.Rules))
      { %>
      <div class="tn-collapsible tn-collapsible-opened">
        <div class="tn-border-bottom tn-border-gray tn-collapsible-header tn-switch-left">
          <h4 class="tn-helper-reset"><%=GetResourceString("Action_SectionRules", applicationID)%></h4>
          <span class="tn-icon tn-switch tn-icon-collapse-close"></span><span class="tn-icon tn-switch tn-icon-collapse-close"></span></div>
        <div style="" class="tn-collapsible-content">
          <p><%=section.Rules%></p>
        </div>
      </div>
      <%} %>
    </div>
  </div>
</div>
<div class="tn-blank10"></div>
<%if (section.ActivedChilds != null && section.ActivedChilds.Count > 0)
  {%>
<div class="tn-widget tn-widget-content tn-corner-all tn-box tn-collapsible tn-collapsible-opened spb-forum-group-detail" id="forumSectionGroup_<%=section.SectionID %>">
  <div class="tn-widget-header tn-corner-top tn-border-bottom tn-box-header tn-collapsible-header tn-state-default tn-switch-right">
    <h3 class="tn-helper-reset"><%=GetResourceString("Action_ChildSections",applicationID)%></h3>
    <span class="tn-icon tn-switch tn-icon-collapse-close"></span>
  </div>
  <div class="tn-widget-content tn-corner-bottom tn-box-content tn-collapsible-content" id="forumSectionDetailForLoad_<%=section.SectionID %>">
    <div class="tn-list-header tn-helper-align-right">
        <span class="tn-helper-left"><em><%=GetResourceString("Label_Thread",applicationID)%><%=GetResourceString("Common_Colon")%><%=section.CumulateThreadCount %></em><em><%=GetResourceString("Label_Topic",applicationID)%><%=GetResourceString("Common_Colon")%><%=section.CumulatePostCount%></em></span>  
        <%=GetResourceString("Action_View")%><%=GetResourceString("Common_Colon") %><span
            class="tn-action tn-action-text-icon tn-selected"><span
                class="tn-icon tn-icon-browse-detail"> </span><a class="tn-action-text" href="javascript:;"
                    id="detail_<%=section.SectionID %>" onclick="toggleMode(this,<%=section.SectionID %>,<%=(int)BrowseMode.detail %>);"><%=GetResourceString("Action_detail",applicationID)%></a></span> <span class="tn-action tn-action-text-icon">
                        <span class="tn-icon tn-icon-browse-medium"></span><a class="tn-action-text" href="javascript:;" onclick="toggleMode(this,<%=section.SectionID %>,<%=(int)BrowseMode.medium %>);"
                            id="medium_<%=section.SectionID %>"><%=GetResourceString("Action_medium",applicationID)%></a></span>
    </div>
    <div id="forumSectionForLoad_<%=(int)BrowseMode.detail%>_<%=section.SectionID %>">
        <%Html.RenderAction<ClubForumController>(n => n.Control_ListForumSection(clubDomainName, section.SectionID, BrowseMode.detail));%>
    </div>
    <div id="forumSectionForLoad_<%=(int)BrowseMode.medium%>_<%=section.SectionID %>" style="display:none">
    </div>
  </div>
</div>
<div class="tn-blank10"></div>
<%}
     }%>
    <%=SPBHtmlHelper.Instance().ShowAdvertisingInClubDomain("001302110001",clubDomainName,new RouteValueDictionary { { "class", "spb-ad-banner" } }) %>
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-topics-list">
  <div class="tn-box-content tn-widget-content tn-corner-all">
    <div class="spb-post-operate tn-helper-clearfix">
      <div class="tn-actions">
         <%if (CurrentUser != null)
               Response.Write(SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Label_SendTopic", applicationID), SPBUrlHelper.Action("NewForumThread", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "sectionID", section.SectionID } }), ButtonSizes.Large, HighlightStyles.Primary, IconTypes.Topic, TextIconLayout.IconText, null, null));
           else
               Response.Write(SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Label_SendTopic", applicationID), SiteUrls.Instance().Login(true), ButtonSizes.Large, HighlightStyles.Primary, IconTypes.Topic, TextIconLayout.IconText, null, null));
             %>
         
         <% if (hasManagePermissions || section.IsModerator(CurrentUser != null ? CurrentUser.UserID : 0))
            {
                Response.Write(SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Action_Manage"), SPBUrlHelper.Action("ManageForumThreads", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "sectionID", section.SectionID } }), ButtonSizes.Large, HighlightStyles.Secondary, IconTypes.Set, TextIconLayout.IconText, null, null));
            }%>
      </div>
      <div class="tn-pagination tn-helper-align-right"><%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious,Model.TotalRecords,Model.PageSize,Model.PageIndex) %></div>
    </div>
    <%if (section.ThreadCategories != null && section.ThreadCategories.Count > 0)
      {%>
    <div class="tn-directory">
      <div class="tn-directory-level tn-border-gray tn-border-bottom">
      <%if (categoryID <= 0)
        {%>
      <span class="tn-directory-item tn-selected"><strong class="tn-text-note"><%=GetResourceString("Action_AllCategories", applicationID)%></strong></span>
      <%}
        else
        {%>
        <span class="tn-directory-item"><a href="<%=SPBUrlHelper.Action("ShowForumSection", "ClubForum", categoriesRoute) %>"><%=GetResourceString("Action_AllCategories", applicationID)%></a></span>   
        <%} %>
        <%foreach (ForumThreadCategory forumCategory in section.ThreadCategories)
          {
              if (categoryID != forumCategory.CategoryID)
              {%>
              <span class="tn-directory-item"><a href="<%=SPBUrlHelper.Action("ShowForumSection", "ClubForum", new RouteValueDictionary(categoriesRoute){{"categoryID",forumCategory.CategoryID}})%>"><%=forumCategory.CategoryName%></a></span>
           <%}
              else
              { %>
              <span class="tn-directory-item tn-selected"><strong class="tn-text-note"><%=forumCategory.CategoryName%></strong></span>
           <%} %>
        <%} %>
      </div>
    </div>
    <%} %>
    <table class="tn-table-grid" id="sectionForumList_<%=section.SectionID %>">
      <tbody>
      <tr class="tn-table-grid-header">
        <td id="menuButtons" class="tn-border-gray tn-border-bottom" colspan="2"><%=GetResourceString("Action_Filter",applicationID)%><%=GetResourceString("Common_Colon")%>
        <%  string dateTitle = GetResourceString("Action_AllTime", applicationID);
            if (scopes.HasValue)
            {
                switch (scopes)
                {
                    case (int)ForumDateScopes.OneDay:
                        dateTitle = GetResourceString("Enum_Pattern_OneDay", applicationID);
                        break;
                    case (int)ForumDateScopes.ThreeDay:
                        dateTitle = GetResourceString("Enum_Pattern_ThreeDay", applicationID);
                        break;
                    case (int)ForumDateScopes.OneWeek:
                        dateTitle = GetResourceString("Enum_Pattern_OneWeek", applicationID);
                        break;
                    case (int)ForumDateScopes.TwoWeek:
                        dateTitle = GetResourceString("Enum_Pattern_TowWeek", applicationID);
                        break;
                    case (int)ForumDateScopes.OneMonth:
                        dateTitle = GetResourceString("Enum_Pattern_OneMonth", applicationID);
                        break;
                    case (int)ForumDateScopes.ThreeMonth:
                        dateTitle = GetResourceString("Enum_Pattern_ThreeMonth", applicationID);
                        break;
                    default:
                        dateTitle = GetResourceString("Action_AllTime", applicationID);
                        break;
                }

            } %>
        <%=SPBHtmlHelper.Instance().Button("", dateTitle, ButtonSizes.Default, HighlightStyles.Lite, IconTypes.TriangleDown, TextIconLayout.MenuButton, null, new RouteValueDictionary { { "menu", "#filterDate" } })%>
        <div id="filterDate" class="tn-menu-button-position tn-menu tn-helper-reset tn-widget-content">
                <% RouteValueDictionary forumScopesRoute = new RouteValueDictionary(routeDictionary);
                   forumScopesRoute.Remove("scopes");%>
          <ul>
              <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ShowForumSection", "ClubForum", forumScopesRoute)%>">
                  <%=GetResourceString("Action_AllTime",applicationID) %></a></li>    
              <li class="tn-menu-item">
              <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ShowForumSection", "ClubForum", new RouteValueDictionary(forumScopesRoute) { { "scopes", (int)ForumDateScopes.OneDay } }) %>">
                  <%=GetResourceString("Enum_Pattern_OneDay", applicationID) %></a></li>
              <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ShowForumSection", "ClubForum", new RouteValueDictionary(forumScopesRoute) { { "scopes", (int)ForumDateScopes.ThreeDay } })%>">
                  <%=GetResourceString("Enum_Pattern_ThreeDay", applicationID) %></a></li>
              <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ShowForumSection", "ClubForum", new RouteValueDictionary(forumScopesRoute) { { "scopes", (int)ForumDateScopes.OneWeek } })%>">
                  <%=GetResourceString("Enum_Pattern_OneWeek",applicationID) %></a></li>
              <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ShowForumSection", "ClubForum", new RouteValueDictionary(forumScopesRoute) { { "scopes", (int)ForumDateScopes.TwoWeek } })%>">
                  <%=GetResourceString("Enum_Pattern_TowWeek",applicationID) %></a></li>
              <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ShowForumSection", "ClubForum", new RouteValueDictionary(forumScopesRoute) { { "scopes", (int)ForumDateScopes.OneMonth } })%>">
                  <%=GetResourceString("Enum_Pattern_OneMonth",applicationID) %></a></li>
              <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ShowForumSection", "ClubForum", new RouteValueDictionary(forumScopesRoute) { { "scopes", (int)ForumDateScopes.ThreeMonth } })%>">
                  <%=GetResourceString("Enum_Pattern_ThreeMonth",applicationID) %></a></li>
          </ul>
        </div>
        <%=GetResourceString("Label_SortOrder") %><%=GetResourceString("Common_Colon") %>
        <% string sortTitle = GetResourceString("Label_NewReply", applicationID);
           switch (sortBy)
           {
               case (int)ForumThreadSortBy.LastRepliedDate:
                   sortTitle = GetResourceString("Label_NewReply", applicationID);
                   break;
               case (int)ForumThreadSortBy.PostDate:
                   sortTitle = GetResourceString("Action_Latest", applicationID);
                   break;
               case (int)ForumThreadSortBy.ReplyCount:
                   sortTitle = GetResourceString("Action_MostResponded", applicationID);
                   break;
               case (int)ForumThreadSortBy.StageHitTimes:
                   sortTitle = GetResourceString("Action_WeekHitTime", applicationID);
                   break;
               default:
                   sortTitle = GetResourceString("Label_NewReply", applicationID);
                   break;
           }%>
        <%=SPBHtmlHelper.Instance().Button("", sortTitle, ButtonSizes.Default, HighlightStyles.Lite, IconTypes.TriangleDown, TextIconLayout.MenuButton, null, new RouteValueDictionary { { "menu", "#sortForum" } })%>
        <div id="sortForum" class="tn-menu-button-position tn-menu tn-helper-reset tn-widget-content">
        <% RouteValueDictionary forumSortRoute = new RouteValueDictionary(routeDictionary);
           forumSortRoute.Remove("sortBy");%>
          <ul>
              <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ShowForumSection", "ClubForum", new RouteValueDictionary(forumSortRoute){{"sortBy",ForumThreadSortBy.PostDate}})%>">
                  <%= GetResourceString("Action_Latest",applicationID) %></a></li>    
              <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ShowForumSection", "ClubForum", new RouteValueDictionary(forumSortRoute){{"sortBy",ForumThreadSortBy.LastRepliedDate}}) %>">
                  <%=GetResourceString("Label_NewReply",applicationID) %></a></li>
              <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ShowForumSection", "ClubForum", new RouteValueDictionary(forumSortRoute){{"sortBy",ForumThreadSortBy.ReplyCount}})%>">
                  <%=GetResourceString("Action_MostResponded",applicationID) %></a></li>
              <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ShowForumSection", "ClubForum",new RouteValueDictionary(forumSortRoute){{"sortBy",ForumThreadSortBy.StageHitTimes}})%>">
                  <%=GetResourceString("Action_WeekHitTime",applicationID) %></a></li>
          </ul>
        </div>
          <input type="checkbox" name="setEssential" id="setEssential" class="tn-checkbox" <%if (isEssential.HasValue && isEssential.Value) Response.Write("checked=\"checked\"");%> />
          <label for="setEssential"><%=GetResourceString("Action_Essential",applicationID) %></label>
          <input type="checkbox" id="OpenBlank" class="tn-checkbox" />
          <label for="OpenBlank">新窗</label>

        </td>
        <td class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_Author",applicationID) %></td>
        <td class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Common_Reply") %>/<%=GetResourceString("Common_Browse") %></td>
        <td class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_LastRepliedDate",applicationID) %></td>
      </tr>
      <%List<ForumThread> stickyThreads = ViewData["StickyThreads"] as List<ForumThread>;
        if (stickyThreads != null && stickyThreads.Count > 0)
        {
            foreach (ForumThread stickyThread in stickyThreads)
            {%>
      <tr id="T<%=stickyThread.ThreadID %>" class="tn-table-grid-row">
        <td class="tn-border-gray tn-border-bottom spb-topic-icon"><a  href="javascript:;" target="_blank" title="<%=GetResourceString("Action_Blank",applicationID)%>"><span class="tn-icon tn-icon-big tn-icon-topic-top"></span></a></td>
        <td class="tn-border-gray tn-border-bottom tn-width-auto">
        <%if (stickyThread.Category != null)
          {%> 
              <a  class="tn-text-heading" href="<%=SPBUrlHelper.Action("ShowForumSection", "ClubForum", new RouteValueDictionary(categoriesRoute){{"categoryID",stickyThread.CategoryID}})%>" title="<%=stickyThread.Category.CategoryName%>">[<%=StringUtils.Trim(stickyThread.Category.CategoryName, 10)%>]</a> &nbsp; &nbsp;
        <%} %>
        <a class="tn-text-heading" <%=stickyThread.HighlightStyle %> href="<%=SPBUrlHelper.Action("ShowForumThread","ClubForum",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"threadID",stickyThread.ThreadID}}) %>"><%=stickyThread.Subject %></a> 
          <%Response.Write(StampManager.Instance().GetStamp(stickyThread.StampID, true));
            if (stickyThread.IsEssential)
                Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Elite, string.Empty, new RouteValueDictionary { { "class", "tn-icon-inline" } }));
            if (stickyThread.Price > 0)
                Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Coins, string.Empty, new RouteValueDictionary { { "class", "tn-icon-inline" } }));
            if (stickyThread.IsHot)
                Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Fire, string.Empty, new RouteValueDictionary { { "class", "tn-icon-inline" } }));
            if (stickyThread.IsLocked)
                Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Lock, string.Empty, new RouteValueDictionary { { "class", "tn-icon-inline" } }));%>
          <%=SPBHtmlHelper.Instance().ContentTypeThumbnail(stickyThread.AttachmentFilename, ContentTypeThumbnailSize.Small)%>
          <span class="spb-topic-pages tn-text-note">        
              <%=SPBHtmlHelper.Instance().ShowForumThreadPager(stickyThread, null)%>
          </span>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap"><cite><a href="<%=SiteUrls.Instance().UserChannelHome(stickyThread.UserID,applicationID)%>" title="<%=stickyThread.Author %>"><%=stickyThread.Author %></a></cite> <em class="tn-text-note"><%=Formatter.FormatFriendlyDate(stickyThread.PostDate,false)%></em></td>
        <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap"><cite><a href="<%=SPBUrlHelper.Action("ShowForumThread","ClubForum",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"threadID",stickyThread.ThreadID}}) %>" title="回复数"><%=stickyThread.ReplyCount%></a></cite> <em class="tn-text-note"><%=stickyThread.HitTimes %></em></td>
        <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
        <%if (stickyThread.MostRecentPostID > 0)
          {%>
        <cite>
        <%if (stickyThread.MostRecentPostAuthorID > 0)
          { %>
        <a href="<%=SiteUrls.Instance().UserChannelHome(stickyThread.MostRecentPostAuthorID,applicationID)  %>" title="<%=stickyThread.MostRecentPostAuthor %>" target="_blank"><%=stickyThread.MostRecentPostAuthor%></a>
        <%}
          else
              Response.Write(stickyThread.MostRecentPostAuthor); %>
        </cite>  
        <a href="<%=SiteUrls.Instance().ShowForumThreadGotoLastPostInClub(clubDomainName,stickyThread.ThreadID,stickyThread.MostRecentPostID) %>" title="<%=stickyThread.LastRepliedDate %>"><em class="tn-text-note"><%=Formatter.FormatFriendlyDate(stickyThread.LastRepliedDate)%></em></a>
        <%} %>
        </td>
      </tr>
          <%i++;
            }%>
      <tr class="spb-topic-space">
        <td class="tn-border-gray tn-bg-gray tn-border-bottom" colspan="5"></td>
      </tr>
      <%} %>
      
      <%if (Model != null)
        {
            foreach (ForumThread thread in Model.Records)
            {%>   
      <tr class="tn-border-gray tn-border-bottom" id="T<%=thread.ThreadID %>">
        <td class="tn-border-gray tn-border-bottom spb-topic-icon"><a href="<%=SPBUrlHelper.Action("ShowForumThread","ClubForum",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"threadID",thread.ThreadID}}) %>">
        <%bool isLock = false;
          bool IsElite = false;
          bool isHot = false;

          if (thread.IsLocked)
          {
              Response.Write("<span class=\"tn-icon tn-icon-big tn-icon-topic-lock\" title=\"锁定主题\"></span>");
              isLock = true;
          }
          else if (thread.IsEssential)
          {
              Response.Write("<span class=\"tn-icon tn-icon-big tn-icon-topic-elite\" title=\"精华主题\"></span>");
              IsElite = true;
          }
          else if (thread.IsHot)
          {
              Response.Write("<span class=\"tn-icon tn-icon-big tn-icon-topic-fire\" title=\"热门主题\"></span>");
              isHot = true;
          }
          else
          {
              Response.Write("<span class=\"tn-icon tn-icon-big tn-icon-topic-normal\"  title=\"普通主题\"></span>");
          }%> 
        </a></td>
        <td class="tn-border-gray tn-border-bottom tn-width-auto">
        <%if (thread.Category != null)
          {%> 
              <a  class="tn-text-heading" href="<%=SPBUrlHelper.Action("ShowForumSection", "ClubForum", new RouteValueDictionary(categoriesRoute){{"categoryID",thread.CategoryID}})%>" title="<%=thread.Category.CategoryName%>">[<%=StringUtils.Trim(thread.Category.CategoryName,10)%>]</a> &nbsp; &nbsp;
        <%} %>
        <a class="tn-text-heading" <%=thread.HighlightStyle %> href="<%=SPBUrlHelper.Action("ShowForumThread","ClubForum",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"threadID",thread.ThreadID}}) %>"><%=thread.Subject%></a>
         <%Response.Write(StampManager.Instance().GetStamp(thread.StampID, true));
           string iconSpan = "<span class=\"{0}\"></span>";
           if (thread.IsEssential && !IsElite)
               Response.Write(string.Format(iconSpan, "tn-icon tn-icon-elite tn-icon-inline"));
           if (thread.Price > 0)
               Response.Write(string.Format(iconSpan, "tn-icon tn-icon-coins tn-icon-inline"));
           if (thread.IsHot && !isHot)
               Response.Write(string.Format(iconSpan, "tn-icon tn-icon-fire tn-icon-inline"));
           if (thread.IsLocked && !isLock)
               Response.Write(string.Format(iconSpan, "tn-icon tn-icon-lock tn-icon-inline"));%>
          <%=SPBHtmlHelper.Instance().ContentTypeThumbnail(thread.AttachmentFilename, ContentTypeThumbnailSize.Small)%>
          <span class="spb-topic-pages tn-text-note">        
              <%=SPBHtmlHelper.Instance().ShowForumThreadPager(thread, null)%>
          </span>
        </td>
        <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap"><cite><a href="<%=SiteUrls.Instance().UserChannelHome(thread.UserID,applicationID)%>" title="<%=thread.Author%>" target="_blank"><%=thread.Author%></a></cite><em class="tn-text-note"><%=Formatter.FormatFriendlyDate(thread.PostDate, false)%></em></td>
        <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap"><cite><a href="<%=SPBUrlHelper.Action("ShowForumThread","ClubForum",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"threadID",thread.ThreadID}}) %>" title="回复数"><%=thread.ReplyCount%></a></cite> <em class="tn-text-note"><%=thread.HitTimes%></em></td>
        <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
       <%if (thread.MostRecentPostID > 0)
         { %>
        <cite>
        <%if (thread.MostRecentPostAuthorID > 0)
          { %>
            <a href="<%=SiteUrls.Instance().UserChannelHome(thread.MostRecentPostAuthorID,applicationID)  %>" title="<%=thread.MostRecentPostAuthor%>" target="_blank"><%=thread.MostRecentPostAuthor%></a>
        <%}
          else
              Response.Write(thread.MostRecentPostAuthor); %>
        </cite> 
        <a href="<%=SiteUrls.Instance().ShowForumThreadGotoLastPostInClub(clubDomainName,thread.ThreadID,thread.MostRecentPostID) %>" title="<%=thread.LastRepliedDate %>"><em class="tn-text-note"><%=Formatter.FormatFriendlyDate(thread.LastRepliedDate)%></em></a>
        <%} %>
        </td>     
      </tr>
      <%
         i++;
            }
        } %>
     </tbody>
    </table>
    <div class="spb-post-operate tn-helper-clearfix">
      <div class="tn-actions">
         <%
             if (i > 6)
             {
                 if (CurrentUser != null)
                     Response.Write(SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Label_SendTopic", applicationID), SPBUrlHelper.Action("NewForumThread", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "sectionID", section.SectionID } }), ButtonSizes.Large, HighlightStyles.Primary, IconTypes.Topic, TextIconLayout.IconText, null, null));
                 else
                     Response.Write(SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Label_SendTopic", applicationID), SiteUrls.Instance().Login(true), ButtonSizes.Large, HighlightStyles.Primary, IconTypes.Topic, TextIconLayout.IconText, null, null));

                 if (hasManagePermissions || section.IsModerator(CurrentUser != null ? CurrentUser.UserID : 0))
                 {
                     Response.Write(SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Action_Manage"), SPBUrlHelper.Action("ManageForumThreads", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "sectionID", section.SectionID } }), ButtonSizes.Large, HighlightStyles.Secondary, IconTypes.Set, TextIconLayout.IconText, null, null));
                 }
             }%>      
       </div>
      <div class="tn-pagination tn-helper-align-right"><%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious,Model.TotalRecords,Model.PageSize,Model.PageIndex) %></div>
    </div>
  </div>
</div>     

<script type="text/javascript">
    $(document).ready(function () {
        $(".tn-collapsible").collapsibleBox();
        $("#setEssential").click(function () {
            if ($(this).attr("checked"))
                window.location.href = '<%=SPBUrlHelper.Action("ShowForumSection", "ClubForum",new RouteValueDictionary {  { "clubDomainName", clubDomainName },{ "sectionID", section != null ? section.SectionID : 0 }, { "isEssential", true }, { "categoryID", categoryID }, { "scopes", scopes }, { "sortBy", sortBy } } ) %>';
            else
                window.location.href = '<%=SPBUrlHelper.Action("ShowForumSection", "ClubForum",new RouteValueDictionary {  { "clubDomainName", clubDomainName },{ "sectionID", section != null ? section.SectionID : 0 }, { "isEssential", false }, { "categoryID", categoryID }, { "scopes", scopes }, { "sortBy", sortBy } } ) %>';
        });

        $("#menuButtons span[menu]").menuButton({ clickTrigger: true, notTriggerClose: ".tn-menu-list,.tn-menu input" });

        $('#OpenBlank').removeAttr("checked").click(function () {
            $("tr[id^=T]", "#sectionForumList_<%=section.SectionID %>").each(function () {
                if ($('#OpenBlank').is(":checked"))
                    $('#' + this.id + ' td:lt(2) a').attr("target", "_blank");
                else
                    $('#' + this.id + ' td:lt(2) a').removeAttr("target");
            });
        });

        $('#filterDate li').click(function () {
            $(this).find('a').attr("href");
            window.location = $(this).find('a').attr("href");
            return false;
        });

        $('#sortForum li').click(function () {
            $(this).find('a').attr("href");
            window.location = $(this).find('a').attr("href");
            return false;
        });
    });
    function toggleMode(obj, listID, mode) {
        $("#forumSectionForLoad_" + mode + "_" + listID).siblings("div[id^='forumSectionForLoad']").hide();
        $("#" + obj.id).parent("span.tn-action").addClass("tn-selected").siblings("span.tn-selected").removeClass("tn-selected");
        if (mode == 0)
            $("#forumSectionGroup_" + listID).addClass("spb-forum-group-detail").removeClass("spb-forum-group-medium");
        else
            $("#forumSectionGroup_" + listID).removeClass("spb-forum-group-detail").addClass("spb-forum-group-medium");
        if ($("#forumSectionForLoad_" + mode + "_" + listID + "table").length <= 0)
            $("#forumSectionForLoad_" + mode + "_" + listID).show().load('<%=SPBUrlHelper.Action("Control_ListForumSection", "ClubForum",new RouteValueDictionary {  { "clubDomainName", clubDomainName } })%>?sectionID=' + listID + '&mode=' + mode);
        else
            $("#forumSectionForLoad_" + mode + "_" + listID).show();
    }
</script>
  
</asp:content>
<asp:content contentplaceholderid="wideContentRegion" runat="server">
</asp:content>
