﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ClubDomainViewPage<PagingDataSet<ForumPost>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Forum-ShowClubForumThread"
</asp:content>
<asp:content id="wideContent" contentplaceholderid="wideContent" runat="server">
  <spb:Script runat="server" ID="shCore" Src="~/Utility/syntaxhighlighter/scripts/shCore-2.0.296.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="shLegacy" Src="~/Utility/syntaxhighlighter/scripts/shLegacy-2.0.296.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="shBrushAllLanguage" Src="~/Utility/syntaxhighlighter/scripts/shBrushAllLanguage-2.0.296.js" SetExpireDays="30" />
  <spb:Style runat="server" ID="shCore_css" Href="~/Utility/syntaxhighlighter/styles/shCore.css" />
  <spb:Style runat="server" ID="shThemeDefault_css" Href="~/Utility/syntaxhighlighter/styles/shThemeDefault.css" />
  <spb:Script runat="server" ID="metadata" Src="~/Utility/jquery/plugin/jquery.metadata-2.1.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="qtip" Src="~/Utility/jquery/plugin/jquery.qtip-1.0.0-rc3.js" SetExpireDays="30" />
  <spb:Script runat="server" ID="iColorPicker" Src="~/Utility/jquery/plugin/iColorPicker-noLink.js" SetExpireDays="30" />
  <%  StatusMessageData statusMessageData = TempData.Get<StatusMessageData>("StatusMessageData", null);
      bool errorAuditingStatus = ViewData.GetBool("errorAuditingStatus", false);
      int forumsApplication = ApplicationIDs.Instance().Forum();

      string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");

      ForumThread forumThread = ViewData.Get<ForumThread>("forumThread", null);
      if (forumThread == null)
      {
          throw new SPBException(ExceptionTypes.Instance().PostNotFound());
      }
      if (statusMessageData != null)
      {
          if (statusMessageData.MessageType == StatusMessageType.Success)
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData.MessageType, statusMessageData.MessageContent, 3000, false));
          else
              Response.Write(SPBHtmlHelper.Instance().StatusMessage(statusMessageData, 3000, false));
          statusMessageData = null;
      }
      bool hasManagePermission = ClubPermission.Validate(clubDomainName, CurrentUser, PermissionItemKeys.Instance().ApproveClubForumPost());
      bool isShowReply = !forumThread.IsLocked
                && ((SiteSettingsManager.GetSiteSettings().EnableAnonymousPosting && CurrentUser == null)
                     || ((ClubPermission.Validate(clubDomainName, CurrentUser, PermissionItemKeys.Instance().ReplyClubForumThread()) && CurrentUser != null)));
      if (CurrentUser == null && forumThread.IsHidden)
          isShowReply = false;


      int pageIndex = Request.QueryString.GetInt("pageIndex", 1);
      int number = (Model.PageIndex - 1) * Model.PageSize;
      if (errorAuditingStatus)
      {
          string errorMessage = ViewData.GetString("errorMessage", string.Empty);%>
      <div class="tn-widget">
          <div class="tn-cue-highlight tn-corner-all tn-message-box"><span class="tn-helper-left"><%=SPBHtmlHelper.Instance().Icon(IconTypes.Exclamation) %> </span>
            <div class="tn-helper-flowfix"> 
                 <%int postID = forumThread.PostID;
                   int threadID = forumThread.ThreadID;
                   Response.Write(errorMessage);%>
                <%if (CurrentUser != null && CurrentUser.IsAdministrator && CurrentUser.IsContentAdministrator)
                  {%> 
              <span><%=GetResourceString("Description_AdminLimit",forumsApplication)%></span>
                <a title="<%=GetResourceString("Description_ForumsPass",forumsApplication)%>" id="SetIsPassButton" href="<%=SPBUrlHelper.Action("UpdateForumAuditingStatus", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "threadID", threadID }, { "postID",postID } })%>"><%=GetResourceString("Action_Pass",forumsApplication)%></a>
        
                <%}%>
            </div>
          </div>
        </div>
        <div class="tn-blank10">
        </div> 
      <% }
      if (!errorAuditingStatus || hasManagePermission || (CurrentUser != null && CurrentUser.UserID == forumThread.UserID))
      {
    %>
    <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-post">
        <div class="tn-box-content tn-widget-content tn-corner-all">
    <div class="spb-post-operate tn-helper-clearfix">
            <div class="tn-actions">
             <% 
                
                 if (ClubPermission.Validate(clubDomainName, CurrentUser, PermissionItemKeys.Instance().CreateClubForumThread()))
                     Response.Write(SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Button_PublishThread", forumsApplication), SPBUrlHelper.Action("NewForumThread", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "sectionID", forumThread.SectionID } }), ButtonSizes.Large, HighlightStyles.Primary, IconTypes.Topic, TextIconLayout.IconText, null, null));
                 else if (CurrentUser == null)
                     Response.Write(SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Button_PublishThread", forumsApplication), SiteUrls.Instance().Login(true), ButtonSizes.Large, HighlightStyles.Primary, IconTypes.Topic, TextIconLayout.IconText, null, null));
                 if (isShowReply)
                     Response.Write(SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Button_ReplyThread", forumsApplication), SPBUrlHelper.Action("NewForumPost", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "parentID", forumThread.PostID } }), ButtonSizes.Large, HighlightStyles.Primary, IconTypes.Bubble, TextIconLayout.IconText, null, null));
                 else if (CurrentUser == null)
                     Response.Write(SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Button_ReplyThread", forumsApplication), SiteUrls.Instance().Login(true), ButtonSizes.Large, HighlightStyles.Primary, IconTypes.Bubble, TextIconLayout.IconText, null, null));
                 if (hasManagePermission)
                 { %>
		  <%=SPBHtmlHelper.Instance().Button("topManageButton", GetResourceString("Action_Manage"), ButtonSizes.Large, HighlightStyles.Primary, IconTypes.TriangleDown, TextIconLayout.MenuButton, new RouteValueDictionary { { "menu", "#manageThreadControl" } }, null)%>
		  <div id="manageThreadControl" class="tn-menu-button-position tn-menu tn-helper-reset tn-widget-content">
		  <ul>
            <li class="tn-menu-item">
            <%=SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Action_MoveThread", forumsApplication), SPBUrlHelper.Action("Control_MoveForumThread", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "threadID", forumThread.ThreadID } }), IconTypes.TriangleRight, TextIconLayout.IconText, new RouteValueDictionary { { "class", "tn-menu-text nyroModal" } }, null)%>
            </li><li class="tn-menu-item">
            <%if (!forumThread.IsEssential)
                  Response.Write(SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Label_SetEssential", forumsApplication), SPBUrlHelper.Action("SetEssential", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "threadID", forumThread.ThreadID }, { "isEssential", true } }), IconTypes.Elite, TextIconLayout.IconText, new RouteValueDictionary { { "class", "tn-menu-text" } }, null));
              else
                  Response.Write(SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Common_CancelEssential"), SPBUrlHelper.Action("SetEssential", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "threadID", forumThread.ThreadID }, { "isEssential", false } }), IconTypes.Elite, TextIconLayout.IconText, new RouteValueDictionary { { "class", "tn-menu-text" } }, null)); %>
            </li><li class="tn-menu-item">
            <%=SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Label_TopSet", forumsApplication), SPBUrlHelper.Action("Control_SetSticky", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "threadID", forumThread.ThreadID }}), IconTypes.Top, TextIconLayout.IconText, new RouteValueDictionary { { "class", "tn-menu-text nyroModal" } }, null)%>
            </li><li class="tn-menu-item">
            <%=SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Action_SetCategory", forumsApplication), SPBUrlHelper.Action("Control_SetThreadCategory", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "threadID", forumThread.ThreadID }, { "sectionID", forumThread.SectionID } }), IconTypes.Set, TextIconLayout.IconText, new RouteValueDictionary { { "class", "tn-menu-text nyroModal" } }, null)%>
            </li><li class="tn-menu-item">
            <%=SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Action_SetHighlight", forumsApplication), SPBUrlHelper.Action("Control_SetHighlight", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "threadID", forumThread.ThreadID }, { "sectionID", forumThread.SectionID } }), IconTypes.Color, TextIconLayout.IconText, new RouteValueDictionary { { "class", "tn-menu-text nyroModal" } }, null)%>
            </li><li class="tn-menu-item">
            <%if (!forumThread.IsLocked)
                  Response.Write(SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Action_SetLocked", forumsApplication), SPBUrlHelper.Action("SetLock", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "threadID", forumThread.ThreadID }, { "isLocked", true } }), IconTypes.Lock, TextIconLayout.IconText, new RouteValueDictionary { { "class", "tn-menu-text" } }, null));
              else
                  Response.Write(SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Action_CancelLocked", forumsApplication), SPBUrlHelper.Action("SetLock", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "threadID", forumThread.ThreadID }, { "isLocked", false } }), IconTypes.Lock, TextIconLayout.IconText, new RouteValueDictionary { { "class", "tn-menu-text" } }, null)); %>
            </li><li class="tn-menu-item">
            <%=SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Title_EditThread", forumsApplication), SPBUrlHelper.Action("EditForumThread", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "threadID", forumThread.ThreadID } }), IconTypes.Write, TextIconLayout.IconText, new RouteValueDictionary { { "class", "tn-menu-text" } }, null)%>
            </li>
            <li class="tn-menu-item"> <%=SPBHtmlHelper.Instance().ActionLink(string.Empty, "主题盖章", SPBUrlHelper.Action("Control_SetForumStamp", "ClubForum", new RouteValueDictionary {{"clubDomainName",clubDomainName}, { "threadID", forumThread.ThreadID } }), IconTypes.Flag, TextIconLayout.IconText, new RouteValueDictionary { { "class", "tn-menu-text nyroModal" } }, null)%> </li>
            <li class="tn-menu-item">
            <%=SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Action_DeleteThread", forumsApplication), SPBUrlHelper.Action("DeleteForumThread", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "threadID", forumThread.ThreadID } }), IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "class", "tn-menu-text" } }, null)%>
            </li>
		  </ul>
		  </div>
		  <%} %>
            </div>
            <div class="tn-pagination tn-helper-align-right">
            <%=SPBHtmlHelper.Instance().PagingButton( PaginationMode.NumericNextPrevious, Model.TotalRecords,Model.PageSize,Model.PageIndex,5,string.Empty) %>
            </div>
          </div>
          <div class="spb-post-head tn-widget-content tn-border-top">
            <table>
              <tbody>
              <tr>
                <td class="tn-widget-content spb-post-side"><em><span class="tn-text-note"><%=GetResourceString("Common_Browse") %><%=GetResourceString("Common_Colon")%></span><%=forumThread.HitTimes %></em><em><span class="tn-text-note"><%=GetResourceString("Common_Reply") %><%=GetResourceString("Common_Colon") %></span><%=forumThread.ReplyCount %></em></td>
                <td class="spb-post-content">
                <div class="spb-thumb">
                <% if (forumThread.PrevThreadID > 0) Response.Write(SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Action_BeforeThread", forumsApplication), SiteUrls.Instance().ShowForumThreadInClub(clubDomainName, forumThread.PrevThreadID), IconTypes.TriangleLeft, TextIconLayout.IconText, null, null)); %>
                <%if (forumThread.NextThreadID > 0) Response.Write(SPBHtmlHelper.Instance().ActionLink(string.Empty, GetResourceString("Action_NextThread", forumsApplication), SiteUrls.Instance().ShowForumThreadInClub(clubDomainName, forumThread.NextThreadID), IconTypes.TriangleRight, TextIconLayout.TextIcon, null, null));%>
                </div>
                  <div class="tn-text-heading">
                  <% if (forumThread.Category != null)
                     {        
                   %>
                  <span class="tn-category tn-text-note"><a href="<%=SiteUrls.Instance().ShowForumSectionInClub(clubDomainName,forumThread.SectionID,forumThread.CategoryID) %>">【<%=forumThread.Category.CategoryName %>】</a>
                  <%} %>
                  </span>
                    <h1 class="tn-helper-reset"><%=forumThread.Subject %></h1>
                    <% if (forumThread.IsSticky) Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Top, GetResourceString("Action_Top", forumsApplication), new RouteValueDictionary { { "class", "tn-icon-inline" } })); %>
                    <% if (forumThread.IsEssential) Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Elite, GetResourceString("Action_Essential", forumsApplication), new RouteValueDictionary { { "class", "tn-icon-inline" } })); %>
                    <% if (forumThread.Price > 0) Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Coins, GetResourceString("Action_NeedToBuy", forumsApplication), new RouteValueDictionary { { "class", "tn-icon-inline" } })); %>
                    <% if (forumThread.IsHot) Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Fire, GetResourceString("Title_HotThread", forumsApplication), new RouteValueDictionary { { "class", "tn-icon-inline" } })); %>
                    <% if (forumThread.IsLocked) Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Lock, GetResourceString("Action_Lock", forumsApplication), new RouteValueDictionary { { "class", "tn-icon-inline" } })); %>
                 </div>
                </td>
              </tr>
              <tr class="spb-post-space">
                <td class="tn-widget-content spb-post-side tn-bg-light"></td>
                <td class="tn-widget-content spb-post-content tn-bg-light"></td>
              </tr>
            </tbody>
            </table>
          </div>
          <div id="forumPostDiv">
          <% ViewData["isShowReply"] = isShowReply;
             if (pageIndex <= 1)
             {
                 Html.RenderPartial("Controls/Forums/ForumThreadFloor.ascx", ViewData);
             }
             Response.Write(SPBHtmlHelper.Instance().ShowAdvertisingInClubDomain("001302110004", clubDomainName, new RouteValueDictionary { { "class", "spb-ad-space" } }));
             ViewData["forumSection"] = forumThread.ForumSection;
             foreach (ForumPost forumPost in Model.Records)
             {
                 number++;
                 ViewData["number"] = number;
                 ViewData["forumPost"] = forumPost;
                 ViewData["threadID"] = forumThread.ThreadID;
                 ViewData["pageIndex"] = Model.PageIndex;
                 Html.RenderPartial("Controls/Forums/ForumPostFloor.ascx", ViewData);
             } %>
             </div>
           <div class="spb-post-foot tn-widget-content tn-border-top"></div>
           <div class="spb-post-operate tn-helper-clearfix">
            <div class="tn-actions">
             <% if (ClubPermission.Validate(clubDomainName, CurrentUser, PermissionItemKeys.Instance().CreateClubForumThread()))
                    Response.Write(SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Button_PublishThread", forumsApplication), SPBUrlHelper.Action("NewForumThread", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "sectionID", forumThread.SectionID } }), ButtonSizes.Large, HighlightStyles.Primary, IconTypes.Topic, TextIconLayout.IconText, null, null));
                else if (CurrentUser == null)
                    Response.Write(SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Button_PublishThread", forumsApplication), SiteUrls.Instance().Login(true), ButtonSizes.Large, HighlightStyles.Primary, IconTypes.Topic, TextIconLayout.IconText, null, null));
                if (isShowReply)
                    Response.Write(SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Button_ReplyThread", forumsApplication), SPBUrlHelper.Action("NewForumPost", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "parentID", forumThread.PostID } }), ButtonSizes.Large, HighlightStyles.Primary, IconTypes.Bubble, TextIconLayout.IconText, null, null));
                else if (CurrentUser == null)
                    Response.Write(SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Button_ReplyThread", forumsApplication), SiteUrls.Instance().Login(true), ButtonSizes.Large, HighlightStyles.Primary, IconTypes.Bubble, TextIconLayout.IconText, null, null));
                if (hasManagePermission)
                { %>
		  <%=SPBHtmlHelper.Instance().Button("underManageButton", GetResourceString("Action_Manage"), ButtonSizes.Large, HighlightStyles.Primary, IconTypes.TriangleDown, TextIconLayout.MenuButton, new RouteValueDictionary { { "menu", "#manageThreadControl" } }, null)%>
		  <%} %>
            </div>
            <div class="tn-pagination tn-helper-align-right">
            <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex, 5, string.Empty)%>
            </div>
          </div>
      </div>
  </div>
             

  <% if (isShowReply)
     {
    %>
    
     <div class="tn-blank10"></div>
     <div id="quickStatusMessage"></div>
     <div class="tn-blank10"></div>  
   <a name="quickReply"></a>
   <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-quick-reply">
        <div class="tn-box-content tn-widget-content tn-corner-all">
     <table>
            <tr>
            <td class="tn-widget-content spb-post-side">
            <div class="tn-avatar-medium">
                <%=SPBHtmlHelper.Instance().ShowUserAvatar(CurrentUser, true, HyperLinkTarget._blank, AvatarSizeTypes.Card,true,null)%>
                </div>
            </td>
            <td class="spb-post-content">
          <form class="tn-helper-reset" method="post" id="QuickFeedBackForm" name="QuickFeedBackForm" action="<%=SPBUrlHelper.Action("CreateQuickForumPost","ClubForum",new RouteValueDictionary{{ "clubDomainName", clubDomainName },{"parentID",forumThread.PostID}}) %>">
            <div class="tn-form">        
            <div class="tn-form-row">
                    <span class="tn-helper-right">
                        <%=SPBHtmlHelper.Instance().ActionLink("advancedFeedBack", GetResourceString("Action_HighReply", forumsApplication), SPBUrlHelper.Action("NewForumPost", "ClubForum", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "parentID", forumThread.PostID } }), null)%>
                    </span>                       
                <input name="subject" id="subject" type="text" value="<%=GetResourceString("Common_Reply")+GetResourceString("Common_Colon")+ forumThread.Subject %>"
                                class="tn-textbox tn-input-longest tn-border-gray" size="85" />
              </div>
             <div class="tn-form-row">
             <%=SPBHtmlHelper.Instance().HtmlEditor(HtmlEditorMode.Simple, "body", new RouteValueDictionary { { "style", "width: 100%;height:270px" }, { "id", "body" } })%>             
            </div>
            <%SiteSettings settings = SiteSettingsManager.GetSiteSettings();
              if (settings.VerifyCodeOption == VerifyCodeOption.Enabled || CurrentUser == null && settings.VerifyCodeOption == VerifyCodeOption.Anonymous)
              {%>
             <div class="tn-form-row tn-form-row-verifycode">
                <%=SPBHtmlHelper.Instance().ShowVerificationCode("verifyCode", VerificationCodeDifficultyLevel.Low)%> 
            </div>
            <%} %>          
            <div class="tn-form-row tn-form-row-button"> 
                <%=SPBHtmlHelper.Instance().SubmitButton("postButton", GetResourceString("Button_Submit"), ButtonSizes.Large, null, null)%>
             <span class="tn-text-note">[<%=GetResourceString("Action_PressEnter",forumsApplication) %>]</span></div>
             </div>
          </form>
          </td>
         </tr>
      </table>
    </div>
  </div>
  <%} %>
  
  <script type="text/javascript">
      $(document).ready(function() {
          $("#verifyCode").watermark('<%=GetResourceString("Title_ClickInputVerifyCode",forumsApplication)%>');

          $("#QuickFeedBackForm").validate({
              rules: {
                  verifyCode: { required: true },
                  subject: { required: true, maxBlength: 56 },
                  body: { htmlEditorRequired: true, htmlEditorRange: [1, 50000] }
              },
              messages: {
                  verifyCode: { required: '<%=GetResourceString("Validate_VerifyCode_Required",forumsApplication)%>' },
                  subject: { required: '<%=GetResourceString("Validate_InputTitle")%>', rangelength: '<%=string.Format(GetResourceString("Validate_VerifyCode_Required",forumsApplication),56)%>' },
                  body: { htmlEditorRequired: '<%=GetResourceString("Validate_InputThreadContent",forumsApplication) %>', htmlEditorRange: '<%=string.Format(GetResourceString("Validate_Pattern_Subject_Rangelength",forumsApplication),50000)%>' }
              }
          });
          $("#QuickFeedBackForm").ajaxForm({
              beforeSubmit: function() {
                  if (!$("#QuickFeedBackForm").valid())
                  { return false; }
                  $("#QuickFeedBackForm").block({
                      message: '<%=GetResourceString("Message_Loading")%>'
                  });
              },
              dataType: 'json',
              success: function(data) {
                  $("#QuickFeedBackForm").unblock();
                  if (data.ok) {
                      $.get('<%=SPBUrlHelper.Action("Control_ForumPostFloor","ClubForum",new RouteValueDictionary{{ "clubDomainName", clubDomainName },{"replyUserID",Html.GetParameterFromRouteDateOrQueryString<int>("replyUserID")},{"isDesc",Html.GetParameterFromRouteDateOrQueryString<bool>("isDesc")},{"threadID",forumThread.ThreadID},{"pageIndex",Model.PageIndex }}) %>', { postID: data.postID }, function(html) {
                          $(html).hide().insertAfter("div.spb-post-floor:last").fadeIn(2000);
                          window.location.hash = data.postID.toString();
                          tinyMCE.execCommand('mceSetContent', false, '');
                          $("#body").html("");
                      });
                  }
                  $("#quickStatusMessage").html(data.message);
                  $("#postButton_ForHide").hide();
                  $("#postButton").show();
                  $("div.tn-form-row-verifycode img").click();
                  $("#verifyCode").val('');

              }
          });
          $("#QuickFeedBackForm").bind('form-pre-serialize', function(event, form, options, veto) {
              tinyMCE.triggerSave();
          });
          $("a[name='quickReplyButton']").click(function() {
              var data = $(this).metadata();
              tinyMCE.execCommand('mceFocus', false, 'body');
              window.location.hash = 'quickReply';

              $('#subject').attr('value', '<%=GetResourceString("Common_Reply") %><%=GetResourceString("Common_Colon") %>' + data.number + " " + data.author);
              $('#QuickFeedBackForm').attr('action', '<%=SPBUrlHelper.Action("CreateQuickForumPost","ClubForum",new RouteValueDictionary{{ "clubDomainName", clubDomainName }}) %>?parentID=' + data.postID);
              $('#advancedFeedBack').attr('href', '<%=SPBUrlHelper.Action("NewForumPost","ClubForum",new RouteValueDictionary{{ "clubDomainName", clubDomainName }}) %>?parentID=' + data.postID + '&FloorNumber=' + data.number.replace(/[^0-9]/ig, ""));
              return false;
          });
          $("a[name='deletePostButton']").click(function() {
              if (!confirm('<%=GetResourceString("Message_ConfirmDeleteReplyTopic", forumsApplication)  %>'))
                  return false;
          });

          $("#topManageButton,#underManageButton").menuButton();

          $('#shareLink').nyroModal({
              resizeable: true
          });
      });

      SyntaxHighlighter.defaults['toolbar'] = false;
      SyntaxHighlighter.all();
    </script>
   <script type="text/javascript">
       $(document).ready(function() {
           $("div.tn-avatar-medium", $("#forumPostDiv")).each(function() {
               var self = $(this);
               self.qtip({
                   content: '<div class="tn-loading"></div>',
                   position: {
                       corner: {
                           target: 'rightTop',
                           tooltip: 'leftTop'
                       },
                       adjust: {
                           screen: true
                       }
                   },
                   show: {
                       when: 'mouseover',
                       solo: true,
                       delay: 1000
                   },
                   hide: { when: 'mouseout', fixed: true, delay: 480 },
                   style: {
                       tip: false,
                       border: {
                           width: 0,
                           radius: 0
                       },
                       background: 'none',
                       name: 'light',
                       width: 325,
                       padding: 1
                   },
                   api: { onShow: function() {
                       if (self.qtip('api').elements.content.is(":has(div.tn-loading)"))
                           $.get('<%=SPBUrlHelper.Action("Control_MemberCard", "Channel")%>', { userID: self.attr("value") }, function(data) {
                               self.qtip('api').updateContent(data);
                           });
                   }
                   }
               });
           });
           var coval = getCookie('ClubBrowsingHistory');
           if (coval == null)
               setCookie('ClubBrowsingHistory', 'T<%=forumThread.ThreadID %>');
           else if (coval.indexOf('T<%=forumThread.ThreadID %>') < 0)
               setCookie('ClubBrowsingHistory', coval + 'T<%=forumThread.ThreadID %>');
       });
</script>
    <%} %>
</asp:content>
<asp:content contentplaceholderid="outerContent" runat="server">
</asp:content>
