﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ClubDomainViewPage" %>

<asp:content id="manageMenusContent" contentplaceholderid="manageMenusContent" runat="server">
   <%ViewData["manageClubMenu"] = ManageClubMenu.BasicSetting;
     ViewData["manageClubSubMenu"] = ManageClubSubMenu.ClubBanner;
     Html.RenderPartial("Controls/Manage/ClubManageMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageContent" contentplaceholderid="manageContent" runat="server">
                 <%Club UserClub = null;
                   if (ViewData["UserClub"] != null)
                       UserClub = ViewData["UserClub"] as Club;
                   int applicationID = ApplicationIDs.Instance().Club();
                   string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");  %>
    

      <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-upload-avatar">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
      <h3 class="tn-helper-reset"><%=GetResourceString("Title_UpdateClubBanner", applicationID)%></h3>
      </div>
         <div class="tn-box-content tn-widget-content tn-corner-bottom">
         
          <div class="tn-helper-clearfix">
                 <div class="">
                     <div class="">
                         <div class="spb-upload-wrapper tn-border-gray tn-border-rbl">
                             <div class="spb-upload-fieldset tn-border-gray tn-border-top" id="fsUploadProgress">
                                 <span class="spb-upload-legend"></span></div>
                             <div style="display: none;" id="divStatus">
                             </div>
                             <div class="spb-upload-actions tn-border-gray tn-border-top">
                                <% 
                                    string handdlerUrl = Globals.GetFullUrlInFileHandlerSite(ClubLogos.StorageProviderName, WebUtils.ResolveUrl("~/Services/Club/ClubUploadBanner.ashx"));
                                    string flashUrl = Globals.GetFullUrlInFileHandlerSite(ClubLogos.StorageProviderName, WebUtils.ResolveUrl("~/Utility/UploadFiles/swfupload.swf"));
                                    string uploadFileTypes = "*.gif;*.jpg;*.jpeg;*.png;*.bmp;";
                                    int maxFileSize = 5 * 1024;
                %>
                 <% Html.RenderAction<ChannelController>(n => n.Control_UploadAvatarAttachment(string.Empty, handdlerUrl, flashUrl, UserClub.ClubID, uploadFileTypes, maxFileSize.ToString(), false, null)); %>
                             </div>
                         </div>
                         <div class="spb-upload-tips tn-border-gray tn-border-bottom tn-text-note">
                             <%=String.Format(GetResourceString("Description_Pattern_UploadAvatar", ApplicationIDs.Instance().User()),SiteSettingsManager.GetSiteSettings().SmallAvatarWidth + "x" + SiteSettingsManager.GetSiteSettings().SmallAvatarWidth)%></div>
                     </div>
                 </div>                                           
                 <div class="spb-avatar-box" style="overflow-x:auto;width:100%;">
                     <%= SPBHtmlHelper.Instance().ShowClubBanner(UserClub.ClubID, false, new RouteValueDictionary { { "id", "clublogo" } })%>
                 </div>
             </div>     
      </div>
    </div>

</asp:content>
