﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ClubDomainViewPage" %>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="Club-CropClbLogo"
</asp:content>
<asp:content id="manageMenusContent" contentplaceholderid="manageMenusContent" runat="server">
   <%ViewData["manageClubMenu"] = ManageClubMenu.BasicSetting;
     ViewData["manageClubSubMenu"] = ManageClubSubMenu.ClubLogo;
     Html.RenderPartial("Controls/Manage/ClubManageMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageContent" contentplaceholderid="manageContent" runat="server">

  <%string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
    int applicationID = ApplicationIDs.Instance().Club();%>
<spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js" SetExpireDays="30" />
    <spb:Script runat="server" ID="JqueryFormJs" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js" SetExpireDays="30" />
    <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-crop-avatar">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
    <span class="tn-helper-right"><a href="<%=SPBUrlHelper.Action("ClubLogo","ClubManage",new RouteValueDictionary(){{"clubDomainName",clubDomainName}}) %>"><%=GetResourceString("Action_Return") %></a></span>
      <h3 class="tn-helper-reset"><%=GetResourceString("Title_CropClubLogo", applicationID)%></h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom" id="ClubLogoModuleContent">
    <%   if (TempData["StatusMessageType"] != null)
         {
             StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
             Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
             TempData["StatusMessageType"] = null;
         }
         else
         {   
        %>
    
    <div class="tn-text-heading tn-border-gray tn-border-bottom"><%=GetResourceString("Description_DescriptionForCropClubLogo", applicationID)%></div>
          <div class="spb-avatar-box"> <%=SPBHtmlHelper.Instance().ShowClubLogo(ViewData.GetInt("CLubID", 0), ClubLogoSizeTypes.Original, false, new RouteValueDictionary { { "id", "clublogo" } })%> </div>
          <div class="spb-crop-avatar-actions">
             <%=SPBHtmlHelper.Instance().LinkButton("corpButton2", GetResourceString("Button_ElectoralDistrictLogo", applicationID),  "javascript:;", ButtonSizes.Default, HighlightStyles.Primary)%>
             <%=SPBHtmlHelper.Instance().LinkButton("autoCorpButton2", GetResourceString("Button_AutoCut", applicationID),"javascript:;", ButtonSizes.Default, HighlightStyles.Primary)%>
    <%=SPBHtmlHelper.Instance().LinkButton(string.Empty, GetResourceString("Button_ReUpdateLogo", applicationID), SPBUrlHelper.Action("ClubLogo", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } }), ButtonSizes.Default, HighlightStyles.Primary)%>
              
          <input id="cropImageWidth" name="cropImageWidth" type="hidden" />
          <input id="cropImageX" name="cropImageX" type="hidden" />
          <input id="cropImageY" name="cropImageY" type="hidden" />
          <input id="autoCrop" name="autoCrop" type="hidden" />
      </div>   
    <%
        SiteSettings siteSettings = SiteSettingsManager.GetSiteSettings();
        %>
    <spb:Script runat="server" ID="imgareaselect" Src="~/Utility/jquery/plugin/jquery.imgareaselect-0.9.6.js"
            SetExpireDays="30" />
    <script type="text/javascript">
                    $(document).ready(function() {
                        $('img#clublogo').imgAreaSelect({
                        borderColor1:"black",borderColor2:"black",outerColor:"black",outerOpacity:0.6,
                        selectionColor: 'white', onSelectEnd: selectionEnd, 
                        aspectRatio: "<%=siteSettings.AvatarWidth %> : <%=siteSettings.AvatarHeight %>",
                        minWidth:<%=siteSettings.AvatarWidth %>,
                        minHeight:<%=siteSettings.AvatarHeight %>,
                        x1:0,y1:25,x2:<%=siteSettings.AvatarWidth %>,y2:<%=siteSettings.AvatarHeight %>
                        }); 
                        
                         $("#corpButton2").click(function() { 
                            $('#ClubLogoModuleContent').block({ message: '<%=GetResourceString("Message_Loading")%>' });
                            $('#autoCrop').attr('value',"false");  
                            $.getJSON('<%=Globals.GetFullUrlInFileHandlerSite(ClubLogos.StorageProviderName,SPBUrlHelper.Action("CropClubLogoAction","ClubManage",new RouteValueDictionary{{"clubDomainName",clubDomainName}})) %>?cropImageWidth='+$('#cropImageWidth').attr("value")+'&cropImageX='+$('#cropImageX').attr("value")+'&cropImageY='+ $('#cropImageY').attr("value")+'&autoCrop='+ $('#autoCrop').attr("value")+'&jsoncallback=?', function(data) {
                                        $('#ClubLogoModuleContent').unblock();
                                        if (data.Status == 'Success') {
                                            alert(data.Message);
                                            window.location.href = '<%=SPBUrlHelper.Action("ClubLogo", "ClubManage", new RouteValueDictionary { { "clubDomainName", Html.GetParameterFromRouteDateOrQueryString("clubDomainName") } })%>';
                                        }
                                        else {
                                            alert(data.Message);
                                        }
                                    });
                         });
                         $("#autoCorpButton2").click(function() { 
                            $('#ClubLogoModuleContent').block({ message: '<%=GetResourceString("Message_Loading")%>' });
                            $('#autoCrop').attr('value',"true");  
                            $.getJSON('<%=Globals.GetFullUrlInFileHandlerSite(ClubLogos.StorageProviderName,SPBUrlHelper.Action("CropClubLogoAction","ClubManage",new RouteValueDictionary{{"clubDomainName",clubDomainName}})) %>?cropImageWidth='+$('#cropImageWidth').attr("value")+'&cropImageX='+$('#cropImageX').attr("value")+'&cropImageY='+ $('#cropImageY').attr("value")+'&autoCrop='+ $('#autoCrop').attr("value")+'&jsoncallback=?', function(data) {
                                        $('#ClubLogoModuleContent').unblock();
                                        if (data.Status == 'Success') {
                                            alert(data.Message);
                                            window.location.href = '<%=SPBUrlHelper.Action("ClubLogo", "ClubManage", new RouteValueDictionary { { "clubDomainName", Html.GetParameterFromRouteDateOrQueryString("clubDomainName") } })%>';
                                        }
                                        else {
                                            alert(data.Message);
                                        }
                                    });
                         });
                        
                    });
                    
                    function selectionEnd(img, selection) 
                    {
                        $('#cropImageWidth').attr('value',selection.width);
                        $('#cropImageX').attr('value',selection.x1);
                        $('#cropImageY').attr('value',selection.y1);
                    }

                    
        </script>
    <%} %></div>
  </div>
</asp:content>
