﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ClubDomainViewPage<Advertising>" %>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="Club-EditAdvertisings"
</asp:content>
<asp:content id="manageMenusContent" contentplaceholderid="manageMenusContent" runat="server">
   <%ViewData["manageClubMenu"] = ManageClubMenu.BasicSetting;
     ViewData["manageClubSubMenu"] = ManageClubSubMenu.ManageAdvertisings;
     Html.RenderPartial("Controls/Manage/ClubManageMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageContent" contentplaceholderid="manageContent" runat="server">
    <%string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
      Advertising advertising = ViewData.Model;
      int applicationID = ApplicationIDs.Instance().Club();
        %>
<div class="tn-box tn-widget tn-widget-content tn-corner-all">
          <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
            <h3 class="tn-helper-reset"><%if (advertising.AdvertisingID > 0) { Response.Write(GetResourceString("Title_EditAdvertising", applicationID)); } else { Response.Write(GetResourceString("Title_CreateAdvertising", applicationID)); } %></h3>
          </div>
          <div class="tn-box-content tn-widget-content tn-corner-bottom">
          <%   
              if (TempData["StatusMessageType"] != null)
              {
                  StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                  if (messageType == StatusMessageType.Success)
                  {
                      Response.Write(string.Format("<script type=\"text/javascript\">window.location.href='{0}'</script>", SPBUrlHelper.Action("ManageAdvertisings", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } })));
                  }
                  else
                  {
                      Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
                  }
                  TempData["StatusMessageType"]=null;
              }
                %>
            <form id="editor" class="tn-helper-reset" method="post" action="<%=SPBUrlHelper.Action("CreateUpdateAdvertising","ClubManage",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"advertisingID",advertising.AdvertisingID}}) %>">
            <div class="tn-form tn-label-right">
            <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_AdvertisingName", applicationID)%><%=GetResourceString("Common_Colon") %></label>
            <input type="text" id="advertisingName" class="tn-textbox tn-input-long tn-border-gray" name="advertisingName" value="<%=advertising.AdvertisingName %>" />
                                        <span class="tn-form-required">*</span>
            </div>
            <div class="tn-form-row">
            <label class="tn-form-label">
            <%=GetResourceString("Label_AdvertisingStartTime", applicationID)%><%=GetResourceString("Common_Colon") %>
            </label>
            <%Html.RenderAction<ChannelController>(n => n.Control_Datepicker("effectiveDateFrom", DateTime.Now.Year, DateTime.Now.Year + 10, advertising.EffectiveDateFrom, false, "tn-textbox tn-input-medium tn-border-gray")); %>
            </div>
            <div class="tn-form-row">
            <label class="tn-form-label">
            <%=GetResourceString("Label_AdvertisingEndTime", applicationID)%><%=GetResourceString("Common_Colon") %>
            </label>
            <%Html.RenderAction<ChannelController>(n => n.Control_Datepicker("effectiveDateTo", DateTime.Now.Year, DateTime.Now.Year + 10, advertising.EffectiveDateTo, false, "tn-textbox tn-input-medium tn-border-gray")); %>
            </div>
            <div class="tn-form-row">
              <label class="tn-form-label"> <%=GetResourceString("Label_IsEnabled")%><%=GetResourceString("Common_Colon") %></label>
              <div class="tn-input-multiple">
                <%=SPBHtmlHelper.Instance().YesNoRadioButtonList("isEnabled", advertising.IsEnabled, new RouteValueDictionary { {"Class","radiobutton" }})%>
              </div>
            </div>
            <div class="tn-form-row">
            <label class="tn-form-label">
            <%=GetResourceString("Label_JavaScript", applicationID)%><%=GetResourceString("Common_Colon") %>
            </label>
            <textarea id="script" class="tn-textarea tn-input-long tn-border-gray" name="script"><%=advertising.Script %></textarea>
                                        <span class="tn-form-required">*</span>
            </div>
            </div>
            <div id="apforjueryload">
                                <%Html.RenderAction<ClubManageController>(n => n.Control_ListAdvertisingPositions(Html.GetParameterFromRouteDateOrQueryString("clubDomainName"), advertising.AdvertisingID, null));%>
                            </div>
                            <div class="tn-form-row tn-form-row-button">
                                <%=SPBHtmlHelper.Instance().SubmitButton("submitButton", GetResourceString("Button_OK"), ButtonSizes.Default, null, null)%>
                            </div>
            </form>
          </div>
        </div>
    <script type="text/javascript">
        $(document).ready(function() {
            $("#editor").validate({
                rules: {
                    advertisingName:{required:true},
                    script:{required:true}
                },
                messages: {
                    advertisingName:{required: "<%=GetResourceString("Description_Required")%>"},
                    script:{required: "<%=GetResourceString("Description_Required")%>"}
                }
            });

            $("#submitButton").click(function() {
                if (!$("#editor").valid()) {
                        return false;
                    }
            });
            
        }); 

    </script>

</asp:content>
