﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ClubDomainViewPage<Club>" %>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="Club-EditClubPlacard"
</asp:content>
<asp:content id="manageMenusContent" contentplaceholderid="manageMenusContent" runat="server">
   <%ViewData["manageClubMenu"] = ManageClubMenu.BasicSetting;
     ViewData["manageClubSubMenu"] = ManageClubSubMenu.EditClubPlacard;
     Html.RenderPartial("Controls/Manage/ClubManageMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageContent" contentplaceholderid="manageContent" runat="server">
<%int applicationID = ApplicationIDs.Instance().Club(); %>  
  <div class="tn-box tn-widget tn-widget-content tn-corner-all">
            <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
              <h3 class="tn-helper-reset"><%=GetResourceString("Title_EditClubPlacard", applicationID)%></h3>
            </div>
            <div class="tn-box-content tn-widget-content tn-corner-bottom">
              <% if (TempData["StatusMessageType"] != null)
                 {
                     StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                     if (messageType == StatusMessageType.Success)
                     {
                         Response.Write(SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Success, string.Format(GetResourceString("Message_UpdateClubPlacardSuccess", applicationID), SiteUrls.Instance().ClubDomainHome(Html.GetParameterFromRouteDateOrQueryString("clubDomainName")), SPBUrlHelper.Action("EditClubPlacard", "ClubManage", new RouteValueDictionary { { "clubDomainName", Html.GetParameterFromRouteDateOrQueryString("clubDomainName") } }))));
                     }
                     else
                     {
                         Response.Write(SPBHtmlHelper.Instance().StatusMessage(StatusMessageType.Error, GetResourceString("Message_UpdateClubPlacardError", applicationID)));
                     }
                     TempData["StatusMessageType"] = null;
                 } %>
                       <form id="editPlacard" class="tn-helper-reset" action="<%=SPBUrlHelper.Action("UpdateClubNews", "ClubManage", new RouteValueDictionary { { "clubDomainName", Html.GetParameterFromRouteDateOrQueryString("clubDomainName") } })%>" method="post">
          <div class="tn-form-box">
          <table width="100%">
          <tr>
          <th><%=GetResourceString("Label_ClubPlacard", applicationID)%><%=GetResourceString("Common_Colon") %></th>
          <td>
          <span class="tn-form-row">
          <%=SPBHtmlHelper.Instance().HtmlEditor(HtmlEditorMode.Enhanced, "clubPlacardText", ViewData.Model.GetNews(true), new RouteValueDictionary { { "Class", "textArea" },{"style","width:100%"}})%>
          </span>
          </td>
          </tr>
          <tr>
          <th> </th>
          <td>
          <span class="tn-form-row"><%=string.Format(GetResourceString("Description_Pattern_ClubPlacardMaxLength",applicationID),"1000")%></span>
          </td>
          </tr>
          <tr>
          <th> </th>
          <td><%=SPBHtmlHelper.Instance().SubmitButton("button", GetResourceString("Button_OK"), ButtonSizes.Default, new RouteValueDictionary { { "onclick", "$('#editPlacard').valid()" } }, null)%></td>
          </tr>
          </table>
          </div>
        </form>
            </div>
          </div>
          <script type="text/javascript">
          $(document).ready(function(){
               $("#editPlacard").validate({
		           rules: {
			        clubPlacardText:{maxBlength:2000}
		          },
		          messages: {
			        clubPlacardText:{maxBlength:"<%=string.Format(GetResourceString("Validate_Pattern_MaxLengthViolated",applicationID),"1000")%>"}
		          }
                });
          });

        </script>
</asp:content>
