﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ClubDomainViewPage<ForumSection>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Club-EditForumSection"
</asp:content>
<asp:content id="manageMenusContent" contentplaceholderid="manageMenusContent" runat="server">
   <%
       ViewData["manageClubMenu"] = ManageClubMenu.ManageContent;
       ViewData["manageClubSubMenu"] = ManageClubSubMenu.ManageForumSections;
       Html.RenderPartial("Controls/Manage/ClubManageMenu.ascx", ViewData); 
   %>
</asp:content>
<asp:content id="manageContent" contentplaceholderid="manageContent" runat="server">
<%
    if (TempData["StatusMessageType"] != null)
    {
        StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
        Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000, false));
    }
    TempData["StatusMessageType"] = null;
    ForumSection section = ViewData.Model;
    int applicationID = ApplicationIDs.Instance().Forum();
    string action = Globals.GetFullUrlInFileHandlerSite(ForumSections.StorageProviderName, SPBUrlHelper.Action("CreateUpdateForumSection", "ClubForum", new RouteValueDictionary { { "clubDomainName", Html.GetParameterFromRouteDateOrQueryString("clubDomainName") }, { "sectionID", section.SectionID } }));
    bool ispublic = ViewData.GetBool("isPublic");   
    %>
<form  id="editSectionForm" method="post" action="<%=action %>" enctype="multipart/form-data">
 <div class="tn-form tn-label-right">
      <div class="tn-text-heading tn-border-gray tn-border-bottom">
     <h4>
      <%if (section.SectionID > 0) { Response.Write(GetResourceString("Title_EditModuel", applicationID)); } else { Response.Write("添加版块"); } %>
     </h4> 
    </div>  
     <div class="tn-form-box">          
            <table>
              <tr>
                <th><%=GetResourceString("Label_SectionName", applicationID)%><%=GetResourceString("Common_Colon")%></th>
                  <td><span class="tn-form-row">
                 <input type="text" class="tn-textbox tn-input-long tn-border-gray" name="forumSectionName" id="forumSectionName" value="<%=section.SectionName %>" />
                  </span>
                 </td>
              </tr> 
              <tr>
                <th><%=GetResourceString("Label_SignPicture",applicationID)%><%=GetResourceString("Common_Colon")%></th>
                  <td><span class="tn-form-row">
                   <input type="file" class="fileUpload" name="picfile" />
                  </span>
                 </td>
              </tr>               
              <%if (!string.IsNullOrEmpty(section.LogoUrl))
                { %>
              <tr>
                <th></th>
                  <td><span class="tn-form-row">
                    <%                   
                        Response.Write(string.Format("<img src=\"{0}\" width=\"110\" height=\"50\" /><br/>", SiteUrls.Instance().ForumSectionLogoUrl(section)));                  
                    %> 
                  </span>
                 </td>
              </tr> 
              <%} %>
              <tr>
                <th><%=GetResourceString("Label_Description")%><%=GetResourceString("Common_Colon") %></th>
                  <td><span class="tn-form-row">
                    <%=SPBHtmlHelper.Instance().HtmlEditor(HtmlEditorMode.Enhanced, "description", section.Description, new RouteValueDictionary { { "id", "description" }, { "style", "width:100%" } }, null, null)%>
                  </span>
                 </td>
              </tr> 
               <tr>
                <th><%=GetResourceString("Label_BrandRules",applicationID)%><%=GetResourceString("Common_Colon")%></th>
                  <td><span class="tn-form-row tn-textarea-wrap">
                    <textarea id="rules" name="rules" class="tn-textarea tn-input-text tn-input-long tn-border-gray" rows="4" cols="30"><%=section.Rules %></textarea>              
                    <span style="display:none"></span>
                  </span>
                 </td>
              </tr> 
               <tr>
                <th> 排序序号<%=GetResourceString("Common_Colon")%></th>
                  <td><span class="tn-form-row">
                     <input type="text" class="tn-textbox tn-input-short tn-border-gray" style="width: 50px" id="displayOrder" name="displayOrder"
                            maxlength="256" value="<%=section.DisplayOrder %>" />
                  </span>
                 </td>
              </tr> 
              <tr>
                <th>  <%=GetResourceString("Label_IsEnabled")%><%=GetResourceString("Common_Colon") %></th>
                  <td><span class="tn-form-row">
                    <%=SPBHtmlHelper.Instance().YesNoRadioButtonList("isActive", section.IsActive, new RouteValueDictionary { {"Class" , "radiobutton"}}) %>
                  </span>
                 </td>
              </tr> 
               <tr>
                <th><%=GetResourceString("Label_EnableAnonymousPosting", applicationID)%><%=GetResourceString("Common_Colon")%></th>
                  <td><span class="tn-form-row">
                     <%=SPBHtmlHelper.Instance().YesNoRadioButtonList("enableAnonymousPosting", section.EnableAnonymousPosting, new RouteValueDictionary { { "Class", "radiobutton" } })%>
                  </span>
                 </td>
              </tr> 
              <tr>
                <th><%=GetResourceString("Label_threadCategoryStatus",applicationID)%><%=GetResourceString("Common_Colon")%></th>
                  <td><span class="tn-form-row">
                    <%=SPBHtmlHelper.Instance().ShowRadioButtonList<int, string>("threadCategoryStatus", new Dictionary<int, string> { { (int)ThreadCategoryStatuses.Disabled, "禁用" }, { (int)ThreadCategoryStatuses.NotForceEnabled, "启用但不强制使用" }, { (int)ThreadCategoryStatuses.ForceEnabled, "启用并强制使用" } }, new RouteValueDictionary { { "class", "radiobutton" } }, (int)Model.ThreadCategoryStatus)%>
                  </span>
                 </td>
              </tr>           
              <tr>
                <th>&nbsp;</th>
                <td> <%=SPBHtmlHelper.Instance().SubmitButton("saveButton", GetResourceString("Button_Save"), ButtonSizes.Default, null, null)%>
            <% if (Request.UrlReferrer != null)
               {%>
              <%=SPBHtmlHelper.Instance().Button(string.Empty, GetResourceString("Button_Cancel"), ButtonSizes.Default, HighlightStyles.Secondary,new RouteValueDictionary() { { "onclick","window.location.href='" + Request.UrlReferrer.AbsoluteUri +"'"} },null)%>
              <%} %></td>
              </tr>
            </table>
     </div>
     </div>
</form>
<script type="text/javascript" rel="forceLoad">
    $(document).ready(function() {
        $("#editSectionForm").validate({
            rules: {
                forumSectionName: { required: true ,maxBlength:20}, 
                picfile:{required:false},
                picfile: { accept: "(.jpg|.png|.gif|.psd|.jpeg|.bmp|.TIFF|.TGA)$" }              
            },
            messages: {
                forumSectionName: { required: "必填" ,maxBlength:"版块组名称最长20个字"},
                picfile: { accept: "图片格式不正确！" }               
            }
        });
        $("#saveButton").click(function() {
            if (!$("#editSectionForm").valid()) {
                return false;
            }
        });
    });
</script>
</asp:content>
