﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ClubDomainViewPage<Club>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Club-Home"
</asp:content>
<asp:content contentplaceholderid="manageMenusContent" runat="server">
    <% Html.RenderPartial("Controls/Manage/ClubManageMenu.ascx"); %>
</asp:content>
<asp:content contentplaceholderid="manageContent" runat="server">
    <%
        if (TempData["StatusMessageType"] != null)
        {
            StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
            if (messageType == StatusMessageType.Success)
            {
                Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessage", string.Empty), 4000));
            }
            TempData["StatusMessageType"] = null;
        }
        string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
        
        int applicationID = ApplicationIDs.Instance().Club();
        Club currentClub = ViewData.Model; 
     %>   
    <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-club-manage-main">
          <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
            <h3 class="tn-helper-reset"><%=GetResourceString("Title_ManageClub", applicationID)%></h3>
          </div>
          <div class="tn-box-content tn-widget-content tn-corner-bottom">
            <%
                int requireJoinMemberCount = ViewData.GetInt("requireJoinMemberCount", -1);
                if (requireJoinMemberCount > 0)
                {%>                          
              <div class="tn-list-header tn-helper-clearfix tn-border-gray tn-border-bottom">
                <div class="tn-list-header-row">&nbsp;<span class="tn-icon tn-icon-notice tn-icon-inline"></span><a href="<%=SPBUrlHelper.Action("ManagePendingClubMembers","ClubMember",new RouteValueDictionary{{"clubDomainName",clubDomainName}}) %>"><%=string.Format( GetResourceString("Action_Pattern_ApplyMemberSetting", applicationID),requireJoinMemberCount)%></a>
                </div>
              </div>
                <%}%>
                <ul class="tn-list tn-helper-clearfix">
                <%
                    if (ClubPermission.Validate(currentClub, CurrentUser, PermissionItemKeys.Instance().ManageShareItemOfClub()))
                    {
                        %>
                <li class="tn-list-item">
                  <div class="tn-list-item-area-left">
                    <div class="spb-club-manage-icon spb-club-manage-icon-1"></div>
                  </div>
                  <div class="tn-list-item-area-main">
                    <div class="tn-list-item-row tn-list-item-heading">
                      <h5 class="tn-helper-reset"> <a href="<%=SPBUrlHelper.Action("Share","ClubManage",new RouteValueDictionary() { {"clubDomainName",clubDomainName} }) %>"><%=GetResourceString("Label_ShareMyContent", applicationID)%></a></h5>
                    </div>
                    <div class="tn-list-item-row"><%=GetResourceString("Description_DescriptionForShare", applicationID)%></div>
                  </div>
                </li>
                <% } %>
                <% if (ClubPermission.Validate(currentClub, CurrentUser, PermissionItemKeys.Instance().ManageClubForumSectioins()))
                   {
                       if (Applications.IsEnabled(ApplicationIDs.Instance().Forum()))
                       {%>
                <li class="tn-list-item">
                  <div class="tn-list-item-area-left">
                    <div class="spb-club-manage-icon spb-club-manage-icon-2"></div>
                  </div>
                  <div class="tn-list-item-area-main">
                    <div class="tn-list-item-row tn-list-item-heading">
                      <h5 class="tn-helper-reset"> <a href="<%=SPBUrlHelper.Action("ManageForumSections","ClubForum",new RouteValueDictionary{{"clubDomainName",clubDomainName}}) %>"><%=GetResourceString("Title_ClubSubject", applicationID)%></a></h5>
                    </div>
                    <div class="tn-list-item-row"><%=GetResourceString("Description_DescriptionForForum", applicationID)%></div>
                  </div>
                </li>
                <%}
                   } %>
                           <% if (ClubPermission.Validate(currentClub, CurrentUser, PermissionItemKeys.Instance().ManageClubMember()))
                              { %>        
                <li class="tn-list-item">
                  <div class="tn-list-item-area-left">
                    <div class="spb-club-manage-icon spb-club-manage-icon-3"></div>
                  </div>
                  <div class="tn-list-item-area-main">
                    <div class="tn-list-item-row tn-list-item-heading">
                      <h5 class="tn-helper-reset"> <a href="<%=SPBUrlHelper.Action("ManageClubMembers","ClubMember",new RouteValueDictionary{{"clubDomainName",clubDomainName}}) %>"><%=GetResourceString("Title_ClubMember",applicationID) %></a></h5>
                    </div>
                    <div class="tn-list-item-row"><%=GetResourceString("Description_DescriptionForMemberApply", applicationID)%></div>
                  </div>
                </li>
                <%} %>
                <li class="tn-list-item">
                  <div class="tn-list-item-area-left">
                    <div class="spb-club-manage-icon spb-club-manage-icon-4"></div>
                  </div>
                  <div class="tn-list-item-area-main">
                    <div class="tn-list-item-row tn-list-item-heading">
                      <h5 class="tn-helper-reset"> <a href="<%=SPBUrlHelper.Action("ClubInfo","ClubManage",new RouteValueDictionary{{"clubDomainName",clubDomainName}}) %>"><%=GetResourceString("Action_BaseSetting", applicationID)%></a></h5>
                    </div>
                    <div class="tn-list-item-row"><%=GetResourceString("Description_DescriptionForClubBaseSetting", applicationID)%></div>
                  </div>
                </li>
              </ul>
          </div>
        </div>
</asp:content>
