﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ClubDomainViewPage<IList<Application>>" %>

<asp:content id="manageMenusContent" contentplaceholderid="manageMenusContent" runat="server">
   <%
       ViewData["manageClubMenu"] = ManageClubMenu.ManageContent;
       ViewData["manageClubSubMenu"] = ManageClubSubMenu.ManageApplications;
       Html.RenderPartial("Controls/Manage/ClubManageMenu.ascx", ViewData); 
   %>
</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
  <%string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
    int applicationID = ApplicationIDs.Instance().User();
    Club currentClub = ViewData["CurrentClub"] as Club;
    if (currentClub == null)
        currentClub = new Club(); %>
<div class="tn-grid">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all">
      <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
      <span class="tn-helper-right"><a href="<%=SPBUrlHelper.Action("ManageApplications", "ClubManage", new RouteValueDictionary { {"clubDomainName",clubDomainName}})%>">返回应用管理</a></span>
        <h3 class="tn-helper-reset">添加应用</h3>
      </div>
      <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <%if (TempData["StatusMessageData"] != null)
        {
            StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, "添加应用程序失败！"));
            Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData, 5000, false));
            TempData["StatusMessageData"] = null;
        } %>
      <table class="tn-table-grid">
        <tbody>
          <tr class="tn-table-grid-header">
            <th class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_ApplicationName",applicationID) %> </th>
            <td class="tn-border-gray tn-border-bottom tn-text-note"></td>
          </tr>
          
          <%if (Model != null)
            {
                foreach (Application app in Model)
                {
                    if (Applications.IsInstalled(PresentAreaIDs.Instance().ClubDomain(), currentClub.ClubID, app.ApplicationID))
                        continue;
                    %>
          <tr class="tn-table-grid-row">
            <th class="tn-border-gray tn-border-bottom tn-width-auto"><%=app.ApplicationName%></th>
            <td class="tn-border-gray tn-border-bottom tn-width-action2 tn-nowrap">

            <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Action_InstallApplication", applicationID), SPBUrlHelper.Action("InstallApplication", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "applicationID", app.ApplicationID } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%>
            </td>
          </tr>
          <%
              }
            }%>
        </tbody>
      </table>
    </div>
  </div>
</div>
</asp:content>
