﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ClubDomainViewPage<PagingDataSet<Advertising>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Club-ManageAdvertisings"
</asp:content>
<asp:content id="manageMenusContent" contentplaceholderid="manageMenusContent" runat="server">
   <%ViewData["manageClubMenu"] = ManageClubMenu.BasicSetting;
     ViewData["manageClubSubMenu"] = ManageClubSubMenu.ManageAdvertisings;
     Html.RenderPartial("Controls/Manage/ClubManageMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageContent" contentplaceholderid="manageContent" runat="server">
    <%
        string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
        int applicationID = ApplicationIDs.Instance().Club();
      %>
        <div class="tn-box tn-widget tn-widget-content tn-corner-all">
          <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
            <h3 class="tn-helper-reset"><%=GetResourceString("Title_ManageAdvertisings",applicationID)%></h3>
          </div>
          <div class="tn-box-content tn-widget-content tn-corner-bottom">
          <form action="<%=SPBUrlHelper.Action("DeleteAdvertisings","ClubManage",new RouteValueDictionary{{"clubDomainName",clubDomainName}}) %>"
                            method="post" id="advertisingform">
            <div class="tn-list-header">
            <div class="tn-toolbar tn-helper-clearfix">
            <div class="tn-tool-form">
            <%=SPBHtmlHelper.Instance().LinkButton("",GetResourceString("Action_CreateAdvertising", applicationID),SPBUrlHelper.Action("EditAdvertising","ClubManage",new RouteValueDictionary{{"clubDomainName",clubDomainName}}), ButtonSizes.Default, HighlightStyles.Default) %>
            <%=SPBHtmlHelper.Instance().LinkButton("deleteADs",GetResourceString("Action_DeleteAdvertising", applicationID), ButtonSizes.Default, HighlightStyles.Default,null,null) %>                             
            </div>
            </div>
            </div>
            <table class="tn-table-grid">
            <tr class="tn-table-grid-header">
            <td class="tn-border-gray tn-border-bottom tn-text-note">
            <input type="checkbox" class="tn-checkbox" onclick="checkAll(this,'advertisingCheckBoxGroup')" />
            </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note">
            <%=GetResourceString("Label_AdvertisingName",applicationID)%> 
            </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note">
            <%=GetResourceString("Label_AdvertisingStartTime", applicationID)%> 
            </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note">
            <%=GetResourceString("Label_AdvertisingEndTime", applicationID)%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note">
            <%=GetResourceString("Label_IsEnabled")%>
            </td>
            <td class="tn-border-gray tn-border-bottom tn-text-note">
            <%=GetResourceString("Label_Actions")%>
            </td>
            </tr>
            <%foreach (var advertising in ViewData.Model.Records)
              {%>
                                <tr class="tn-table-grid-row">
                                    <td class="tn-border-gray tn-border-bottom tn-width-check">
                                        <input type="checkbox" name="advertisingCheckBoxGroup" class="tn-checkbox" value="<%=advertising.AdvertisingID %>" />
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-width-auto">
                                        <%=StringUtils.Trim(advertising.AdvertisingName,20) %>
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                                        <%=Formatter.FormatDate(advertising.EffectiveDateFrom) %>
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                                        <%=Formatter.FormatDate(advertising.EffectiveDateTo) %>
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-width-status tn-nowrap">
                                        <%if (advertising.IsEnabled)
                                          {%>
                                        <img style="border-width: 0px;" src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_true.gif") %>" />
                                        <%}
                                          else
                                          {%>
                                        <img style="border-width: 0px;" src="<%=Globals.GetFullUrlInResourceSite("~/Themes/Manages/Default/Appearances/Default/Images/icon_false.gif") %>" />
                                        <%}%>
                                    </td>
                                    <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap">
                                        <span class="tn-action">
                                        <a class="tn-action-text" href="<%=SPBUrlHelper.Action("EditAdvertising","ClubManage",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"advertisingID",advertising.AdvertisingID}}) %>">
                                            <%=GetResourceString("Action_Edit")%></a>
                                            </span>
                                    </td>
                                </tr>
                                <%}%>
            </table>
            </form>
            <%if (ViewData.Model.TotalRecords > ViewData.Model.PageSize)
              {%>
            <div class="tn-pagination tn-helper-align-center"> <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious,ViewData.Model.TotalRecords, ViewData.Model.PageSize, ViewData.Model.PageIndex)%> 
<div class="tn-page-results tn-text-note"><%=string.Format(GetResourceString("Label_Pattern_TotalRecords"), ViewData.Model.TotalRecords)%></div>
            </div>
            <%}%>
          </div>
        </div>
         <script type="text/javascript">
             $(document).ready(function() {
                 $("#deleteADs").click(function() {
                     if (confirm('<%=GetResourceString("Message_ConfirmDeleteAdvertising",applicationID)%>  ')) { $('#advertisingform').submit(); return false; } else { return false; };
                 });
             });
        </script>
</asp:content>
