﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ClubDomainViewPage<IList<Application>>" %>

<asp:content id="manageMenusContent" contentplaceholderid="manageMenusContent" runat="server">
   <%
       ViewData["manageClubMenu"] = ManageClubMenu.ManageContent;
       ViewData["manageClubSubMenu"] = ManageClubSubMenu.ManageApplications;
       Html.RenderPartial("Controls/Manage/ClubManageMenu.ascx", ViewData); 
   %>
</asp:content>
<asp:content id="manageContent" runat="server" contentplaceholderid="manageContent">
  <%string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
    Club currentClub = ViewData["CurrentClub"] as Club;
    if (currentClub == null)
        currentClub = new Club();
    int applicationID = ApplicationIDs.Instance().User();%>
<div class="tn-grid">
    <div class="tn-box tn-widget tn-widget-content tn-corner-all">
      <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
        <h3 class="tn-helper-reset"><%=GetResourceString("Label_ManageApplications",applicationID) %></h3>
      </div>
      <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <div class="tn-toolbar-area tn-helper-clearfix">
            <%=SPBHtmlHelper.Instance().LinkButton("", GetResourceString("Action_AddApplication", applicationID), SPBUrlHelper.Action("ListApplications", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%>
      </div>
            <div class="tn-box-content tn-widget-content tn-corner-bottom">

       <%if (TempData["StatusMessageData"] != null)
         {
             StatusMessageData messageData = TempData.Get<StatusMessageData>("StatusMessageData", new StatusMessageData(StatusMessageType.Error, "删除应用程序失败！"));
             Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageData, 3000, false));
             TempData["StatusMessageData"] = null;
         } %>
      <table class="tn-table-grid">
        <tbody>
          <tr class="tn-table-grid-header">
            <th class="tn-border-gray tn-border-bottom tn-text-note"><%=GetResourceString("Label_ApplicationName",applicationID) %> </th>
            <td class="tn-border-gray tn-border-bottom tn-text-note"></td>
            <td class="tn-border-gray tn-border-bottom tn-text-note"> <%=GetResourceString("Label_UnInstallApplication", applicationID)%> </td>
          </tr>
          <%if (Model != null)
            {
                foreach (Application app in Model)
                {%>
          <tr class="tn-table-grid-row">
            <th class="tn-border-gray tn-border-bottom tn-width-auto"><%=app.ApplicationName%></th>
            <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap"></td>
            <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap">
            <%if (!Applications.IsBuiltIn(PresentAreaIDs.Instance().ClubDomain(), app.ApplicationID) && Applications.IsInstalled(PresentAreaIDs.Instance().ClubDomain(), currentClub.ClubID, app.ApplicationID))
              { %>
            <%=SPBHtmlHelper.Instance().LinkButton("", SPBUrlHelper.Action("UnInstallApplication", "clubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "applicationID", app.ApplicationID } }), HighlightStyles.Lite, IconTypes.Cross, new RouteValueDictionary { { "onclick", "if(!confirm(\"确认卸载当前应用？删除应用会清除群组在该应用下的所有数据！\")) return false;" } }, null)%>
            <%} %>
            </td>
          </tr>
          <%}
            }%>
        </tbody>
      </table>
      </div>
    </div>
  </div>
</div>
</asp:content>
