﻿<%@ Page Language="C#"    Inherits="SpaceBuilder.Web.ClubDomainViewPage" %>
<asp:content id="manageMenusContent" contentplaceholderid="manageMenusContent" runat="server">
   <%
       ViewData["manageClubMenu"] = ManageClubMenu.ManageContent;
       ViewData["manageClubSubMenu"] = ManageClubSubMenu.ManageForumCategories;
       Html.RenderPartial("Controls/Manage/ClubManageMenu.ascx", ViewData); 
   %>
</asp:content>
<asp:Content ID="manageContent" ContentPlaceHolderID="manageContent" runat="server"> 
<%  Club currentClub = ViewData["currentClub"] as Club; %>
   <div class="tn-box tn-widget tn-widget-content tn-corner-all">
          <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
            <h3 class="tn-helper-reset"><%=GetResourceString("Title_ManageForumCategories",ApplicationIDs.Instance().Club())%></h3>
          </div>
            <div class="tn-blank10"></div>   
            <div class="tn-box-content tn-widget-content tn-corner-bottom">
               <div class="tn-list-header">
                 <div class="tn-toolbar tn-helper-clearfix">
                    <div class="tn-tool-form">
                   <%=GetResourceString("Label_Module",ApplicationIDs.Instance().Club())%><%=GetResourceString("Common_Colon")%>
                   <%int SectionID = Request.QueryString.GetInt("SectionID", 0);%>  
                   <%=SPBHtmlHelper.Instance().ModerateForumSectionsDropDownList("forumCategorieSselect",currentClub.ClubID, null,SectionID.ToString(), false,string.Empty, new RouteValueDictionary { { "Class", "tn-dropdownlist" }, { "id", "forumCategorieSselect" } })%>
               </div>
             </div>
               </div> 
            </div> 
          <div id="formCategories" class="tn-box-content tn-widget-content tn-corner-bottom">         
            <%Html.RenderAction<ClubForumController>(f => f.Control_ListForumCategories(SectionID)); %>
          </div>
   </div>
  <script type="text/javascript">
     $(document).ready(function() {
         $("#forumCategorieSselect").change(function() {
           $("#formCategories").load("<%=SPBUrlHelper.Action("Control_ListForumCategories", "ClubForum")%>?sectionID="+this.value+"&clubDomainName=<%=Html.GetParameterFromRouteDateOrQueryString("clubDomainName")%>");          
         }).change();
     });
 </script>
 </asp:Content>