﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ClubDomainViewPage" %>

<asp:content id="manageMenusContent" contentplaceholderid="manageMenusContent" runat="server">
<%ViewData["manageClubMenu"] = ManageClubMenu.ManageContent;
  ViewData["manageClubSubMenu"] = ManageClubSubMenu.ManageForumPost;
  Html.RenderPartial("Controls/Manage/ClubManageMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageContent" contentplaceholderid="manageContent" runat="server"> 
<%AuditingStatusesForDisplay auditingStatusesForDisplay = ViewData.Get<AuditingStatusesForDisplay>("auditingStatusesForDisplay", AuditingStatusesForDisplay.Pending);
  int pageIndex = ViewData.GetInt("pageIndex");
  int applicationID = ApplicationIDs.Instance().Club();
  string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
  Club currentClub = ViewData["currentClub"] as Club;
  string forumSectionSselect = Html.GetParameterFromRouteDateOrQueryString("forumSectionSselect");
  string KeyWords = Html.GetParameterFromRouteDateOrQueryString("KeyWords");
  string SelectStatuses = Html.GetParameterFromRouteDateOrQueryString("SelectStatuses");
  string autoID = Html.GetParameterFromRouteDateOrQueryString("autoID");%>
<div>
    <form method="get" action="<%=SPBUrlHelper.Action("ManageForumPosts", "ClubForum",new RouteValueDictionary {{"clubDomainName",clubDomainName}})%>">
    <div class="tn-form-box tn-border-gray tn-border-all">
        <table>
            <tr>
                <th>
                    <%=GetResourceString("Label_Module",applicationID)%><%=GetResourceString("Common_Colon")%>
                </th>
                <td colspan="3">
                    <%
                        int SectionID = Request.QueryString.GetInt("forumSectionSselect", 0);                
                    %>
                    <%=SPBHtmlHelper.Instance().ModerateForumSectionsDropDownList("forumSectionSselect", currentClub.ClubID, null, SectionID.ToString(), false, null, new RouteValueDictionary { { "Class", "tn-dropdownlist" }, { "id", "forumSectionSselect" } })%>
                </td>
            </tr>              
            <tr>
                <th>
                    <%=GetResourceString("Label_KeyWords",applicationID)%><%=GetResourceString("Common_Colon")%>
                </th>
                <td>
                    <input type="text" id="KeyWords" name="KeyWords" class="tn-textbox tn-input-medium tn-border-gray"
                        value="<%=KeyWords%>" />
                </td>
                <th>
                    <%=GetResourceString("Label_AutoID",applicationID)%><%=GetResourceString("Common_Colon")%>
                </th>
                <td>
                    <input type="text" id="autoID" name="autoID" class="tn-textbox tn-input-medium tn-border-gray"
                        value="<%=autoID %>">
                </td>
                <th>
                    <%=GetResourceString("Label_Status",applicationID)%><%=GetResourceString("Common_Colon")%>
                </th>
                <td>
                    <select name="SelectStatuses" class="tn-dropdownlist" id="SelectStatuses">
                        <option value="<%=(int)AuditingStatusesForDisplay.Success %>" <% if(auditingStatusesForDisplay==AuditingStatusesForDisplay.Success) Response.Write("selected"); %>>
                            <%=GetResourceString("Common_PassSuccess")%></option>
                        <option value="<%=(int)AuditingStatusesForDisplay.Fail %>" <% if(auditingStatusesForDisplay==AuditingStatusesForDisplay.Fail) Response.Write("selected"); %>>
                            <%=GetResourceString("Common_NotPassAudit")%></option>
                        <option value="<%=(int)AuditingStatusesForDisplay.Again %>" <% if(auditingStatusesForDisplay==AuditingStatusesForDisplay.Again) Response.Write("selected"); %>>
                            <%=GetResourceString("Common_PassAgain")%></option>
                        <option value="<%=(int)AuditingStatusesForDisplay.Pending %>" <% if(auditingStatusesForDisplay==AuditingStatusesForDisplay.Pending) Response.Write("selected"); %>>
                            <%=GetResourceString("Common_PassPending")%></option>
                    </select>
                </td>
                <td>
                    <%=SPBHtmlHelper.Instance().SubmitButton("submit", GetResourceString("Button_Search"), ButtonSizes.Default, null, null) %>
                </td>
            </tr>
        </table>
    </div>
    </form>
    <div class="tn-blank10">
    </div>
</div>
<div class="ui-tabs ui-widget ui-widget-content ui-corner-all">
    <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
        <li class="ui-state-default ui-corner-top  <% if (auditingStatusesForDisplay == AuditingStatusesForDisplay.Pending) Response.Write("ui-tabs-selected ui-state-active"); %>"">
            <a href="<%=SPBUrlHelper.Action("ManageForumPosts", "ClubForum", new RouteValueDictionary { { "auditingStatusesForDisplay", AuditingStatusesForDisplay.Pending },{"clubDomainName",clubDomainName}, { "forumSectionSselect", forumSectionSselect }, { "KeyWords", KeyWords },{"autoID",autoID}})%>">
                <span>
                    <%=GetResourceString("Common_PassPending")%></span></a></li>
        <li class="ui-state-default ui-corner-top  <% if (auditingStatusesForDisplay == AuditingStatusesForDisplay.Success) Response.Write("ui-tabs-selected ui-state-active"); %>"">
            <a href="<%=SPBUrlHelper.Action("ManageForumPosts", "ClubForum", new RouteValueDictionary { { "auditingStatusesForDisplay", AuditingStatusesForDisplay.Success },{"clubDomainName",clubDomainName}, { "forumSectionSselect", forumSectionSselect }, { "KeyWords", KeyWords },{"autoID",autoID}})%>">
                <span>
                    <%=GetResourceString("Common_PassSuccess")%></span></a></li>
        <li class="ui-state-default ui-corner-top  <% if (auditingStatusesForDisplay == AuditingStatusesForDisplay.Again) Response.Write("ui-tabs-selected ui-state-active"); %>"">
            <a href="<%=SPBUrlHelper.Action("ManageForumPosts", "ClubForum", new RouteValueDictionary { { "auditingStatusesForDisplay", AuditingStatusesForDisplay.Again },{"clubDomainName",clubDomainName}, { "forumSectionSselect", forumSectionSselect }, { "KeyWords", KeyWords },{"autoID",autoID}})%>">
                <span>
                    <%=GetResourceString("Common_PassAgain")%></span></a></li>
        <li class="ui-state-default ui-corner-top  <% if (auditingStatusesForDisplay == AuditingStatusesForDisplay.Fail) Response.Write("ui-tabs-selected ui-state-active"); %>"">
            <a href="<%=SPBUrlHelper.Action("ManageForumPosts", "ClubForum", new RouteValueDictionary { { "auditingStatusesForDisplay", AuditingStatusesForDisplay.Fail },{"clubDomainName",clubDomainName}, { "forumSectionSselect", forumSectionSselect }, { "KeyWords", KeyWords },{"autoID",autoID}})%>">
                <span>
                    <%=GetResourceString("Common_NotPassAudit")%></span></a></li>
    </ul>
    <div id="tabs1" class="ui-tabs-panel ui-widget-content ui-corner-bottom">
        <%Html.RenderAction<ClubForumController>(f => f.Control_ListForumPosts(auditingStatusesForDisplay, pageIndex, clubDomainName)); %>
    </div>
</div>
    
</asp:content>
