﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ClubDomainViewPage<PagingDataSet<ForumThread>>" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Forum-ManageForumThreads"
</asp:content>
<asp:content id="manageMenusContent" contentplaceholderid="manageMenusContent" runat="server">
   <%
       ViewData["manageClubMenu"] = ManageClubMenu.ManageContent;
       ViewData["manageClubSubMenu"] = ManageClubSubMenu.ManageForumThreads;
       Html.RenderPartial("Controls/Manage/ClubManageMenu.ascx", ViewData); 
   %>
</asp:content>
<asp:content id="manageContent" contentplaceholderid="manageContent" runat="server"> 
 <spb:Script runat="server" ID="menuButton" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
    SetExpireDays="30" /> 
    <spb:Script runat="server" ID="iColorPicker" Src="~/Utility/jquery/plugin/iColorPicker-noLink.js"
    SetExpireDays="30" />
  <%int applicationID = ApplicationIDs.Instance().Forum();
    int? pageIndex = Html.GetParameterFromRouteDateOrQueryString<int>("pageIndex");
    int? groupID = Html.GetParameterFromRouteDateOrQueryString<int>("groupID");
    string keywords = Html.GetParameterFromRouteDateOrQueryString("keywords");
    int? userID = Request.QueryString.GetInt("userID", 0);
    ForumSection section = ViewData["section"] as ForumSection;
    section = section == null ? new ForumSection() : section;
    Club currentClub = ViewData["currentClub"] as Club;
    currentClub = currentClub == null ? new Club() : currentClub;
    string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
    if (userID.HasValue && userID.Value == 0) userID = null;
    RouteValueDictionary routeDictionary = new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "sectionID", section.SectionID }, { "keywords", keywords }, { "userID", userID }, { "pageIndex", pageIndex } };  %>
<form method="Get" action="<%=SPBUrlHelper.Action("ManageForumThreads", "ClubForum", new RouteValueDictionary { {"clubDomainName",clubDomainName},{ "sectionID", section.SectionID }})%>" id="ManageSearchForm">
     <div class="tn-form-box tn-border-gray tn-border-all">
     <table>
         <tbody>
              <tr>
                 <th>版块：</th>
                 <td><%=SPBHtmlHelper.Instance().ModerateForumSectionsDropDownList("SectionID", currentClub.ClubID, null, section.SectionID.ToString(), false, string.Empty, new RouteValueDictionary { { "Class", "tn-dropdownlist" }, { "id", "sectionID" } })%></td>
              </tr>
              <tr>
                 <th>关键字：</th>
                 <td><input type="text" id="keywords" class="tn-textbox tn-input-medium tn-border-gray" name="keywords" value="<%=keywords %>"/></td>
                 <th>用户ID：</th>
                 <td><input type="text" id="userID" class="tn-textbox tn-input-medium tn-border-gray" name="userID" value="<%=userID %>"/></td>
                 <td><%=SPBHtmlHelper.Instance().SubmitButton("","搜索",ButtonSizes.Default,null,null) %></td>
             </tr>
         </tbody>
       </table>
     </div>                                                                                  
  </form>   
<div class="tn-blank10">
</div>
<div class="tn-box tn-widget tn-widget-content tn-corner-all">
<%if (TempData["StatusMessageType"] != null)
  {
      StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
      Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
      TempData["StatusMessageType"] = null;
  } %>
   <div class="tn-box-content tn-widget-content tn-corner-bottom">
      <div class="tn-list-header">
        <div class="tn-toolbar-area tn-helper-clearfix">
          <label class="tn-check-all">
            <input type="checkbox" class="tn-checkbox" id="checkbox" name="checkbox"  onclick="checkAll(this,'threadIDCheckBox');" />
            全选
          </label>
          <%=SPBHtmlHelper.Instance().LinkButton("setEssential", "设为精华", "#", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Elite, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "if(isCheck()) return false;$('#manageForumThreadsForm').attr(\"action\",'" + SPBUrlHelper.Action("BatchSetEssential", "ClubForum", new RouteValueDictionary(routeDictionary) { { "isEssential", true } }) + "').submit();" } }, null)%>
          <%=SPBHtmlHelper.Instance().LinkButton("setSticky", "设置置顶", "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Top, TextIconLayout.IconText,null, null)%>
          <%=SPBHtmlHelper.Instance().LinkButton("setLock", "设置锁定", "#", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Lock, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "if(isCheck()) return false;$('#manageForumThreadsForm').attr(\"action\",'" + SPBUrlHelper.Action("BatchSetLock", "ClubForum", new RouteValueDictionary(routeDictionary) { { "isLocked", true } }) + "').submit();" } }, null)%>
          <%=SPBHtmlHelper.Instance().LinkButton("move","移动","javascript:;",ButtonSizes.Default,HighlightStyles.Default,IconTypes.TriangleRight,TextIconLayout.IconText,null,null)%>
          <%if (section != null && section.ThreadCategories != null && section.ThreadCategories.Count > 0)
            { %>
          <%=SPBHtmlHelper.Instance().LinkButton(string.Empty,"设置类别","#", ButtonSizes.Default, HighlightStyles.Default, IconTypes.TriangleDown, TextIconLayout.MenuButton,null, new RouteValueDictionary { { "menu", "#forumCategoryControl" } })%>
          <div id="forumCategoryControl" class="tn-menu-button-position tn-menu tn-helper-reset tn-widget-content">
              <ul class="tn-menu-list">
                  <%if (section.ThreadCategories != null)
                    {
                        foreach (ForumThreadCategory category in section.ThreadCategories)
                        {
                  %>
                  <li class="tn-menu-item"><a class="tn-menu-text" href="#" onclick="$('#manageForumThreadsForm').attr('action','<%=SPBUrlHelper.Action("BatchSetThreadCategory", "ClubForum", new RouteValueDictionary(routeDictionary) { { "categoryID",category.CategoryID } })%>').submit();">
                      <%=category.CategoryName%></a></li>               
                  <%}
                    } %>
              </ul>
          </div>
          <%} %>
          <%=SPBHtmlHelper.Instance().LinkButton("deleteForumThreads", "删除", "#", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, null, null)%>      
          <%=SPBHtmlHelper.Instance().LinkButton("", "更多操作","javascript:;", ButtonSizes.Default, HighlightStyles.Lite, IconTypes.TriangleDown, TextIconLayout.MenuButton, null, new RouteValueDictionary { { "menu", "#moreSettings" } })%>
          <div id="moreSettings" class="tn-menu-button-position tn-menu tn-helper-reset tn-widget-content">
              <ul>
                  <li class="tn-menu-item"><a id="cancelEssential" class="tn-menu-text" href="#" onclick="if(isCheck()) return false;$('#manageForumThreadsForm').attr('action','<%=SPBUrlHelper.Action("BatchSetEssential", "ClubForum", new RouteValueDictionary(routeDictionary) { { "isEssential", false } }) %>').submit();">
                      取消精华</a></li>
                  <li class="tn-menu-item"><a id="cancelSticky" class="tn-menu-text" href="#" onclick="if(isCheck()) return false;$('#manageForumThreadsForm').attr('action', '<%=SPBUrlHelper.Action("BatchSetLock", "ClubForum", new RouteValueDictionary(routeDictionary){ { "isLocked",false } })%>').submit();">
                      取消锁定</a></li>
                  <li class="tn-menu-item"><a id="setHighlight" class="tn-menu-text" href="javascript:;">
                      高亮显示</a></li>
              </ul>
          </div>
        </div>
      </div>
      <form id="manageForumThreadsForm" action="" method="post">
       <table class="tn-table-grid">
        <tbody>
          <tr class="tn-table-grid-header">
            <th class="tn-border-gray tn-border-bottom tn-text-note">&nbsp;</th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">Title</th>
            <th class="tn-border-gray tn-border-bottom tn-text-note">&nbsp;</th>
            <td class="tn-border-gray tn-border-bottom tn-text-note">所在版块</td>
            <td class="tn-border-gray tn-border-bottom tn-text-note">作者</td>
            <td class="tn-border-gray tn-border-bottom tn-text-note">发布时间</td>
          </tr>
          <%if (Model != null)
            {
                foreach (ForumThread thread in Model.Records)
                {%>
          <tr class="tn-table-grid-row">
            <td class="tn-border-gray tn-border-bottom tn-width-check"><input type="checkbox" class="tn-checkbox" name="threadIDCheckBox" value="<%=thread.ThreadID %>" /></td>
            <th class="tn-border-gray tn-border-bottom tn-width-auto"><a <%=thread.HighlightStyle %>  href="<%=SPBUrlHelper.Action("ShowForumThread", "ClubForum", new RouteValueDictionary { {"clubDomainName",clubDomainName},{"threadID",thread.ThreadID}})%>" ><%=HtmlUtils.TrimHtml(thread.Subject,30) %></a></th>
            <th class="tn-border-gray tn-border-bottom tn-width-icon3">                                  
            <%if (thread.IsSticky) Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Top, "置顶"));
              if (thread.IsLocked) Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Lock, "锁定"));
              if (thread.IsEssential) Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Elite, "精华"));%>
            </th>
            <td class="tn-border-gray tn-border-bottom tn-text-note"><%=thread.ForumSection != null ?  string.Format("<a href=\"{1}\">{0}</a>",thread.ForumSection.SectionName,SiteUrls.Instance().ShowForumSection(thread.ForumSection.SectionID)) : string.Empty %></td>                                                
            <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap"><cite><a href="<%=SiteUrls.Instance().UserChannelHome(thread.UserID,applicationID) %>"><%=thread.Author%></a></cite></td>
            <td class="tn-border-gray tn-border-bottom tn-width-datetime tn-nowrap"><%=Formatter.FormatFriendlyDate(thread.PostDate) %></td>
          </tr>
          <%}
            } %>
        </tbody>
       </table>                            
       <input type="hidden" name="sectionID" value="<%=section.SectionID %>"/>
      </form>
      <div class="tn-pagination tn-helper-align-center">
        <%if (Model.TotalRecords > Model.PageSize)
          {%>
        <%=SPBHtmlHelper.Instance().PagingButton(PaginationMode.NumericNextPrevious, Model.TotalRecords, Model.PageSize, Model.PageIndex)%>
        <%} %>
        <div class="tn-page-results tn-text-note">共<%=Model.TotalRecords %>条</div>
      </div>
  </div>                                                
</div>         
<script type="text/javascript">
    $(document).ready(function() {
        $("div.tn-list-header span[menu]").menuButton({ clickTrigger: true, notTriggerClose: ".tn-menu-list,.tn-menu input" });
        $("#deleteForumThreads").click(function() {
            if(isCheck())
                return false;
            if(confirm('确认要删除选中的主题？'))
                $("#manageForumThreadsForm").attr("action", '<%=SPBUrlHelper.Action("DeleteForumThreads", "ClubForum", routeDictionary)%>').submit();
            return false;
        });

        $("#setSticky").click(function() {
            if(isCheck())
                return false;
            $("#manageForumThreadsForm").attr("action", "<%=SPBUrlHelper.Action("Control_SetStickys","ClubForum", new RouteValueDictionary { {"clubDomainName",clubDomainName}})%>").nyroModalManual();
            return false;
        });
        $("#move").click(function(){
            if(isCheck())
                return false;
            $("#manageForumThreadsForm").attr("action", "<%=SPBUrlHelper.Action("Control_MoveForumThreads","ClubForum", new RouteValueDictionary { {"clubDomainName",clubDomainName}})%>").nyroModalManual();
                return false;
        });
        $("#setHighlight").click(function(){
            if(isCheck())
                return false;
            $("#manageForumThreadsForm").attr("action", "<%=SPBUrlHelper.Action("Control_BatchSetHighlight","ClubForum", new RouteValueDictionary { {"clubDomainName",clubDomainName}})%>").nyroModalManual();
                return false;
        });
          
        
    });
    
    function isCheck()
    {
        if($("input[name='threadIDCheckBox']:checked").length <= 0)
        {
            alert("至少选择一个论坛主题！");
            return true;           
        }
        return false;
    }
    
</script>  
</asp:content>
