﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ClubDomainViewPage" %>

<asp:content contentplaceholderid="setPageID" runat="server">
    id="Club-ManageLinkCategories"
</asp:content>
<asp:content id="manageMenusContent" contentplaceholderid="manageMenusContent" runat="server">
  <% 
      ViewData["manageClubMenu"] = ManageClubMenu.BasicSetting;
      ViewData["manageClubSubMenu"] = ManageClubSubMenu.ManageClubLinkCategories;
      Html.RenderPartial("Controls/Manage/ClubManageMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageContent" contentplaceholderid="manageContent" runat="server">

    <%string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
      int applicationID = ApplicationIDs.Instance().Club();
        %>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
      <h3 class="tn-helper-reset">
                    <%=GetResourceString("Title_ManageFriendlyLinkCategory", applicationID)%></h3>
            </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">

                        <div class="tn-filter-controls tn-helper-clearfix tn-border-gray tn-border-bottom">
                             <%=SPBHtmlHelper.Instance().LinkButton("LinkCategory", GetResourceString("Action_AddLinkCategory", applicationID), SPBUrlHelper.Action("Control_AddLinkCategory", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%>
                        
                        <%=SPBHtmlHelper.Instance().LinkButton("BatchDeleteLink", GetResourceString("Action_DeleteLinkCategory", applicationID), "javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText, new RouteValueDictionary { { "onclick", "if (confirm('" + GetResourceString("Message_ConfirmDeleteLinkCategory", applicationID) + "')) { $('#categroyform').submit(); return false; } else { return false; } ;" } }, null)%>
                      <div class="tn-blank10"></div>
                        
                        </div>
                        <form action="<%=SPBUrlHelper.Action("DeleteLinkCategoryAction","ClubManage",new RouteValueDictionary{{"clubDomainName",clubDomainName}}) %>"
                        method="post" id="categroyform">
                        <table class="tn-table-grid">
                            <tr class="tn-table-grid-header">
                                <th class="tn-border-gray tn-border-bottom tn-text-note">
                                    <input type="checkbox" class="tn-checkbox" onclick="checkAll(this,'CategroyGroup')" />
                                </th>
                                <th class="tn-border-gray tn-border-bottom tn-text-note">
                                   <%=GetResourceString("Label_CategoryName",applicationID) %> 
                                </th>
                                <th class="tn-border-gray tn-border-bottom tn-text-note">
                                    <%=GetResourceString("Label_Description")%>
                                </th>
                                <th class="tn-border-gray tn-border-bottom tn-text-note">
                                    <%=GetResourceString("Label_RankOrder", applicationID)%> 
                                </th>
                                <th class="tn-border-gray tn-border-bottom tn-text-note">
                                    <%=GetResourceString("Label_Actions")%>
                                </th>
                            </tr>
                            <%
                                if (ViewData["LinkCategories"] != null)
                                {
                                    List<LinkCategory> LinkCategories = ViewData["LinkCategories"] as List<LinkCategory>;
                                    foreach (var item in LinkCategories)
                                    {
                            %>
                            <tr class="tn-table-grid-row">
                                <td class="tn-border-gray tn-border-bottom tn-width-check">
                                    <input type="checkbox" class="tn-checkbox" name="CategroyGroup" value="<%=item.CategoryID %>" />
                                </td>
                                <td class="tn-border-gray tn-border-bottom tn-width-category tn-nowrap">
                                    <%=StringUtils.Trim(item.CategoryName,25) %>
                                </td>
                                 <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                    <%=StringUtils.Trim(item.Description,25) %>
                                </td>
                                <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                                    <%=item.DisplayOrder %>
                                </td>
                                <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap">
                                 <span class="tn-action"><a class="tn-action-text" href="<%=SPBUrlHelper.Action("Control_EditLinkCategory","ClubManage",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"CateID",item.CategoryID}}) %>"
                                        name="LinkCategory">
                                      <%=GetResourceString("Description_EditLinkCategory", applicationID)%></a></span>
                                </td>
                            </tr>
                            <%
                                }
                                }
                            %>
                        </table>
                        </form>
                    </div>
    
</div>

    <script type="text/javascript">
        $(document).ready(function() {
            $('#LinkCategory,a[name="LinkCategory"]').nyroModal({
                resizeable: true,
                width: 450,
                height: 300
            });
        });
    </script>

</asp:content>
