﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ClubDomainViewPage" %>
<asp:content contentplaceholderid="setPageID" runat="server">
    id="Club-ManageLinks"
</asp:content>
<asp:content id="manageMenusContent" contentplaceholderid="manageMenusContent" runat="server">
  <% 
      ViewData["manageClubMenu"] = ManageClubMenu.BasicSetting;
      ViewData["manageClubSubMenu"] = ManageClubSubMenu.ManageClubLinks;
      Html.RenderPartial("Controls/Manage/ClubManageMenu.ascx", ViewData); %>
</asp:content>
<asp:Content ID="manageContent" ContentPlaceHolderID="manageContent" runat="server">

    <%string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
      int applicationID = ApplicationIDs.Instance().Club();%>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
      <h3 class="tn-helper-reset">
                    <%=GetResourceString("Title_ManageFriendlyLink", applicationID)%></h3>
            </div>
         <div class="tn-box-content tn-widget-content tn-corner-bottom">
                        <div class="tn-filter-controls tn-helper-clearfix tn-border-gray tn-border-bottom">
                        <%=SPBHtmlHelper.Instance().LinkButton("ClubLinkAdd", GetResourceString("Action_AddLink", applicationID), SPBUrlHelper.Action("Control_AddLink", "ClubManage", new RouteValueDictionary { { "clubDomainName", clubDomainName } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.Add, TextIconLayout.IconText)%>
                        
                        <%=SPBHtmlHelper.Instance().LinkButton("BatchDeleteLink", GetResourceString("Action_DeleteLink", applicationID),"javascript:;", ButtonSizes.Default, HighlightStyles.Default, IconTypes.Cross, TextIconLayout.IconText,new RouteValueDictionary {{"onclick","if (confirm('"+GetResourceString("Message_ConfirmDeleteLink", applicationID)+"')) { $('#Linkform').submit(); return false; } else { return false; } ;"}},null)%>
                      <div class="tn-blank10"></div>
                      </div>
                      
                        <form action="<%=SPBUrlHelper.Action("DeleteLinkAction","ClubManage",new RouteValueDictionary{{"clubDomainName",clubDomainName}}) %>"
                        method="post" id="Linkform">
                        <table class="tn-table-grid">
                            <tr class="tn-table-grid-header">
                                <th class="tn-border-gray tn-border-bottom tn-text-note">
                                    <input type="checkbox" class="tn-checkbox" onclick="checkAll(this,'LinkGroup')" />
                                </th>
                                <th class="tn-border-gray tn-border-bottom tn-text-note">
                                    <%=GetResourceString("Label_LinkTitle", applicationID)%> 
                                </th>
                                <th class="tn-border-gray tn-border-bottom tn-text-note">
                                   <%=GetResourceString("Label_CategoryName", applicationID)%> 
                                </th>
                                <th class="tn-border-gray tn-border-bottom tn-text-note">
                                    <%=GetResourceString("Label_FriendlyLinkKind", applicationID)%> 
                                </th>
                                <th class="tn-border-gray tn-border-bottom tn-text-note">
                                    <%=GetResourceString("Label_RankOrder", applicationID)%>
                                </th>
                                <th class="tn-border-gray tn-border-bottom tn-text-note">
                                    <%=GetResourceString("Label_Status") %>
                                </th>
                                <th class="tn-border-gray tn-border-bottom tn-text-note">
                                    <%=GetResourceString("Label_Actions")%>
                                </th>
                            </tr>
                            <%
                                if (ViewData["ClubLinks"] != null)
                                {
                                    List<Link> ClubLinks = ViewData["ClubLinks"] as List<Link>;
                                    foreach (var item in ClubLinks)
                                    {
                            %>
                            <tr class="tn-table-grid-row">
                                <td class="tn-border-gray tn-border-bottom tn-width-check">
                                    <input type="checkbox" class="tn-checkbox" name="LinkGroup" value="<%=item.LinkID %>" />
                                </td>
                                <td class="tn-border-gray tn-border-bottom tn-width-auto">
                                    <%=StringUtils.Trim(item.Title,25) %>
                                </td>
                                <td class="tn-border-gray tn-border-bottom tn-width-category tn-nowrap">
                                    <%=StringUtils.Trim(item.CategoryName,25) %>
                                </td>
                                <td class="tn-border-gray tn-border-bottom tn-nowrap">
                                    <%if (item.LinkType == LinkTypes.Text) Response.Write(GetResourceString("Label_TextLink", applicationID)); else Response.Write(GetResourceString("Label_ImageLink", applicationID)); %>
                                </td>
                                <td class="tn-border-gray tn-border-bottom tn-width-number tn-nowrap">
                                    <%=item.DisplayOrder %>
                                </td>
                                <td class="tn-border-gray tn-border-bottom tn-width-icon1">
                                    <%if (item.IsEnabled)
                                      { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Accept)); }
                                      else
                                      { Response.Write(SPBHtmlHelper.Instance().Icon(IconTypes.Cross)); }%>
                                </td>
                                <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap">
                                   <span class="tn-action"><a class="tn-action-text"href="<%=SPBUrlHelper.Action("Control_EditLink","ClubManage",new RouteValueDictionary{{"clubDomainName",clubDomainName},{"linkID",item.LinkID}}) %>"
                                        name="ClubLinkAdd">
                                            <%=GetResourceString("Description_EditLink", applicationID)%></a></span>
                                </td>
                            </tr>
                            <%
                                }
                                } %>
                        </table>
                        </form>
            </div>
    
</div>

    <script type="text/javascript">
        $(document).ready(function() {
        $('#ClubLinkAdd,a[name="ClubLinkAdd"]').nyroModal({
                resizeable: true,
                width: 450,
                height: 450
            });
        });
    </script>

</asp:content>
