﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ClubDomainViewPage" %>

<asp:content id="manageMenusContent" contentplaceholderid="manageMenusContent" runat="server">
  <% 
      ViewData["manageClubMenu"] = ManageClubMenu.BasicSetting;
      ViewData["manageClubSubMenu"] = ManageClubSubMenu.ManageClubInfo;
      Html.RenderPartial("Controls/Manage/ClubManageMenu.ascx", ViewData); %>
</asp:content>
<asp:content id="manageContent" contentplaceholderid="manageContent" runat="server">

<%int applicationID = ApplicationIDs.Instance().Club(); %>
  <div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
      <h3 class="tn-helper-reset"><%=GetResourceString("Title_UpdateClubBaseInfo", applicationID)%> </h3>
    </div>
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <form id="ClubInfo" class="tn-helper-reset" action="<%=SPBUrlHelper.Action("UpdateClubInfo","ClubManage",new RouteValueDictionary{{"clubDomainName",Html.GetParameterFromRouteDateOrQueryString("clubDomainName")}}) %>" method="post" enctype="multipart/form-data">
          <%        
              string rootAreaCode = ClubDomainConfiguration.Instance().RootAreaCode;
              int areaLevel = ClubDomainConfiguration.Instance().AreaLevel;
              bool allowEnableClub = ViewData.GetBool("allowEnableClub", false);
              if (TempData["StatusMessageType"] != null)
              {
                  StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
                  Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
                  TempData["StatusMessageType"] = null;
              }

              Club UserClub = null;
              if (ViewData["UserClub"] != null)
                  UserClub = ViewData["UserClub"] as Club;

              bool isManager = ViewData.GetBool("isManager", false);

                %>
          <%
              if (UserClub != null)
              {
                %>
          <div class="tn-form tn-label-right">
            <div class="tn-form-row">
            <label class="tn-form-label"><span class="tn-form-required">*</span><%=GetResourceString("Label_ClubName", applicationID)%><%=GetResourceString("Common_Colon") %></label>
                <input class="tn-textbox tn-input-long tn-border-gray" name="ClubName" type="text" id="ClubName" value="<%=Formatter.FormatSingleLinePlainTextForEdit(UserClub.ClubName)%>" maxlength="30" />
            </div>
             
            <% if (isManager)
               { %>
             <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_ClubStateSetting", applicationID)%><%=GetResourceString("Common_Colon") %></label>
            
                <select name="AuditingStatus" class="tn-dropdownlist">
                  <option value="<%=(int)AuditingStatuses.Success %>" <%if (UserClub.AuditingStatus == AuditingStatuses.Success) Response.Write("selected"); %>> <%=GetResourceString("Enum_AccountStatuses_Approved")%></option>
                  <option value="<%=(int)AuditingStatuses.Fail %>" <%if (UserClub.AuditingStatus == AuditingStatuses.Fail) Response.Write("selected"); %>> <%=GetResourceString("Enum_AccountStatuses_Disapproved")%></option>
                  <option value="<%=(int)AuditingStatuses.Pending %>" <%if (UserClub.AuditingStatus == AuditingStatuses.Pending) Response.Write("selected"); %>> <%=GetResourceString("Enum_AccountStatuses_ApprovalPending")%></option>
                  <option value="<%=(int)AuditingStatuses.Again %>" <%if (UserClub.AuditingStatus == AuditingStatuses.Again) Response.Write("selected"); %>> <%=GetResourceString("Enum_AccountStatuses_Again")%></option>
                </select>
            </div>
            <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_IsEnabled")%><%=GetResourceString("Common_Colon") %></label>
                <div class="tn-input-multiple">
                <input type="radio" class="tn-radiobutton" value="true" name="IsEnabled" id="IsEnabled-true" <%if (UserClub.IsEnabled) { Response.Write(" checked=\"checked\""); } %>>
                <label for="IsEnabled-true"> <%=GetResourceString("Common_Yes") %></label>
                <input type="radio" class="tn-radiobutton" value="false" name="IsEnabled" id="IsEnabled-false" <%if (!UserClub.IsEnabled) { Response.Write(" checked=\"checked\""); } %>>
                <label for="IsEnabled-false"> <%=GetResourceString("Common_No") %></label>
              </div>
            </div>
            <%} %>
            <div class="tn-form-row">
            <label class="tn-form-label"><span class="tn-form-required">*</span><%=GetResourceString("Label_ClubCategory", applicationID)%><%=GetResourceString("Common_Colon") %></label>
              
                <% Html.RenderAction<ChannelController>(n => n.Control_SiteCategoryDropDownList(ApplicationIDs.Instance().Club(), 1, "CategoryID", UserClub.CategoryID, "tn-dropdownlist"));%>
            </div>
            <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_ClubArea", applicationID)%><%=GetResourceString("Common_Colon") %></label>
                <% Html.RenderAction<ChannelController>(n => n.Control_AreasDropDownList("AreaCode", rootAreaCode, UserClub.AreaCode, areaLevel, "tn-dropdownlist")); %>
              </div>
              <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_HeaderShowType", applicationID)%><%=GetResourceString("Common_Colon") %></label>
                <select name="headerShowType" class="tn-dropdownlist">
                <option value="<%=(int)ClubHeaderShowTypes.ShowBannerAndText %>" <%if (UserClub.ClubHeaderShowTypes == ClubHeaderShowTypes.ShowBannerAndText) { Response.Write("selected=\"selected\""); } %>><%=GetResourceString("Enum_ClubHeaderShowTypes_ShowBannerAndText", applicationID)%></option>
                <option value="<%=(int)ClubHeaderShowTypes.OnlyShowText %>" <%if (UserClub.ClubHeaderShowTypes == ClubHeaderShowTypes.OnlyShowText) { Response.Write("selected=\"selected\""); } %>><%=GetResourceString("Enum_ClubHeaderShowTypes_OnlyShowText", applicationID)%></option>
                <option value="<%=(int)ClubHeaderShowTypes.OnlyShowBanner %>" <%if (UserClub.ClubHeaderShowTypes == ClubHeaderShowTypes.OnlyShowBanner) { Response.Write("selected=\"selected\""); } %>><%=GetResourceString("Enum_ClubHeaderShowTypes_OnlyShowBanner", applicationID)%></option>
                </select>
              </div>
             <div class="tn-form-row">
            <label class="tn-form-label"><%=GetResourceString("Label_ClubPublic", applicationID)%><%=GetResourceString("Common_Colon") %></label>
                <input class="radiobutton" type="radio" <% if (UserClub.IsPublic) Response.Write("checked=\"checked\""); %> id="clubSecrecyTypePublic" name="clubSecrecyType" value="true" />
                <label for="clubSecrecyTypePublic"> <%=GetResourceString("Enum_PrivacyStatuses_Public")%></label>
                <em class="tn-text-note"><%=GetResourceString("Description_ClubSecrecyTypePublic", applicationID)%> </em>
              </div>
              <div id="needApproveDiv" class="tn-form-row">
            <label class="tn-form-label"></label>
               &nbsp; &nbsp; &nbsp;<input class="tn-checkbox" type="checkbox" <% if (UserClub.IsMemberNeedAuthorize) Response.Write("checked=\"checked\""); %> id="needApproveCheckbox" name="needApproveCheckbox" value="true" />
                <label for="needApproveCheckbox"> <%=GetResourceString("Label_JoinClubNeedApprove", applicationID)%></label>
            </div>
             <div class="tn-form-row"> 
             <label class="tn-form-label"></label>
                <input class="radiobutton" type="radio" <% if (!UserClub.IsPublic) Response.Write("checked=\"checked\""); %> id="clubSecrecyTypePrivate" name="clubSecrecyType" value="false" />
                <label for="clubSecrecyTypePrivate"> <%=GetResourceString("Description_IsPrivate", applicationID)%></label>
                <em class="tn-text-note"><%=GetResourceString("Description_clubSecrecyTypePrivate", applicationID)%></em>
            </div>
             <div class="tn-form-row tn-textarea-wrap">
            <label class="tn-form-label"> <span class="tn-form-required">*</span><%=GetResourceString("Label_ClubIntroduction", applicationID)%><%=GetResourceString("Common_Colon") %></label>
                <textarea id="Brief" name="Brief" class="tn-textarea tn-input-long tn-border-gray" cols="20" rows="2" ><%=UserClub.Brief%></textarea>
               <span style="display:none"></span>
            </div>
             <div class="tn-form-row tn-textarea-wrap">
            <label class="tn-form-label"><%=GetResourceString("Label_ApplyInClubInfo", applicationID)%><%=GetResourceString("Common_Colon") %></label>
                <textarea id="JoinNotice" name="JoinNotice" class="tn-textarea tn-input-long tn-border-gray" cols="20" rows="2" ><%=UserClub.JoinNotice %></textarea>
                <span style="display:none"></span>               
            </div>
            <div class="tn-form-row tn-form-row-button">
            <label class="tn-form-label"></label>
            <%=SPBHtmlHelper.Instance().SubmitButton("submit", GetResourceString("Button_Save")) %>
            </div>
          </div>
          <%} %>
        </form>
      </div>
  <script type="text/javascript">
          $(document).ready(function(){
               $("#ClubInfo").validate({
		           rules: {
		            ClubName: { required: true },
			        CategoryID:{ required: true, min: 1 },
			        Brief: { required: true, rangelength: [1, 60] },
			        JoinNotice: { rangelength: [1, 60] }
		          },
		          messages: {
			        ClubName: {required:"<%=GetResourceString("Validate_ClubName_PleaseWriteClubName",applicationID)%>"},
                    CategoryID: { required: "<%=GetResourceString("Validate_PleaseChooseCategory",applicationID)%>", min: "<%=GetResourceString("Validate_PleaseChooseCategory",applicationID)%>" },
                    Brief: { required: "<%=GetResourceString("Validate_PleaseWriteClubBrief",applicationID)%>", rangelength: "<%=GetResourceString("Validate_LengthForClubBriefMessage",applicationID)%>" },
                    JoinNotice: { rangelength: "<%=GetResourceString("Validate_LengthForClubBriefMessage",applicationID)%>" }
                  }
                });
                $("#clubSecrecyTypePublic").click(function(){
                $("#needApproveDiv").show();
                });
                $("#clubSecrecyTypePrivate").click(function(){
                $("#needApproveDiv").hide();
                });
                <% if (UserClub.IsPublic){%>
                $("#needApproveDiv").show();
                <%}else{ %>
                $("#needApproveDiv").hide();
                <%} %>
                <%if(!allowEnableClub)
                { %>
                $("#IsEnabled-true").click(function(){
                alert('<%=GetResourceString("Message_notenabled", applicationID) %>');
                $("#IsEnabled-false").attr("checked","checked");
                });
                <%} %>
          });
    </script>
    </div>
</asp:content>
