﻿<%@ Page Title="" Language="C#" AutoEventWireup="true" Inherits="SpaceBuilder.Web.ClubDomainViewPage<Club>" %>

<asp:content id="setPageID" contentplaceholderid="setPageID" runat="server"> id="Club-NewJoinClubInvitation" </asp:content>
<asp:content contentplaceholderid="mainContent" runat="server">
<div class="tn-box tn-widget tn-widget-content tn-corner-all spb-invite-friends">
    <div class="tn-box-content tn-widget-content tn-corner-bottom">
        <% if (TempData["StatusMessageType"] != null)
         {
             StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
             if (messageType == StatusMessageType.Success)
                 Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
             else
                 Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
             TempData["StatusMessageType"] = null;
         }
        %>
        <% 
    string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
        %>
        <form id="NewJoinClubInvitationForm" name="NewJoinClubInvitationForm" action="<%=SPBUrlHelper.Action("CreateJoinClubInvitation","ClubDomain",new RouteValueDictionary{{"userDomainName",CurrentUser.UserName},{"relativeItemID",Model.ClubID}}) %>"
        method="post">
        <div class="tn-form tn-label-right spb-message-form">
            <div class="tn-form-row">
                <label class="tn-form-label">
                    <%=GetResourceString("Label_Receiver",ApplicationIDs.Instance().User()) %><%=GetResourceString("Common_Colon") %></label>
                <% Html.RenderAction<ChannelController>(n => n.Control_FriendSelector("receiverIDs", string.Empty, 10)); %>
                <div class="tn-text-note">
                    <%=GetResourceString("Message_NewMessageMaxReceiverNum", ApplicationIDs.Instance().User())%></div>
            </div>
            <div class="tn-form-row tn-emotion-box">
                <label class="tn-form-label">
                    <%=GetResourceString("Label_Body")%><%=GetResourceString("Common_Colon") %>
                </label>
                <div class="tn-emotion-textarea tn-textarea-wrap">
                    <%  Html.RenderAction<ChannelController>(n => n.Control_SmileySelector("smiley", "body"));%>
                    <textarea name="body" id="body" cols="80" rows="8" class="tn-textarea tn-input-longest tn-border-gray"></textarea>
                    <span style="display:none"></span>
                </div>
                <div class="tn-text-note tn-helper-clear">
                    <%=GetResourceString("Message_NewMessageMaxBobyHint",ApplicationIDs.Instance().User())%>
                </div>
            </div>
            <div class="tn-form-row tn-form-row-button">
                <label class="tn-form-label">
                    &nbsp;</label>
                <%=SPBHtmlHelper.Instance().SubmitButton("sendButton", GetResourceString("Button_Send"))%>
                <% if (Request.UrlReferrer != null)
               {%>
                <%=SPBHtmlHelper.Instance().CancelButton(Request.UrlReferrer.AbsoluteUri) %>
                <%} %>
            </div>
        </div>
        </form>
        <div class="tn-collapsible tn-collapsible-opened">
            <div class="tn-border-bottom tn-border-gray tn-collapsible-header">
                <h4 class="tn-helper-reset">
                    <a href="#">
                        <%=GetResourceString("Title_EmailNewInvitation",ApplicationIDs.Instance().User()) %></a></h4>
            </div>
            <div class="tn-collapsible-content" style="display: block;">
                <form id="InvatationAddClubByEmailForm" name="InvatationAddClubByEmailForm" action="<%=SPBUrlHelper.Action("CreateFriendInvitationByEmail","ClubDomain",new RouteValueDictionary(){{"clubDomainName",clubDomainName}}) %>"
                method="post">
                <div class="tn-form tn-label-top">
                    <div class="tn-form-row">
                        <label class="tn-form-label">
                            <%=GetResourceString("Label_Receiver",ApplicationIDs.Instance().User()) %><%=GetResourceString("Common_Colon") %></label>
                        <textarea class="tn-textarea tn-input-longest tn-border-gray" id="receivers" name="receivers"><%=Request.QueryString.GetString("Tomail",string.Empty)%></textarea>
                        <div class="tn-text-note">
                            <%=GetResourceString("Description_NewFriendInvitByEmailHint",ApplicationIDs.Instance().User()) %></div>
                    </div>
                    <div class="tn-form-row">
                        <label class="tn-form-label">
                            <%=GetResourceString("Label_InvitMsnFriendSendMsg", ApplicationIDs.Instance().User())%><%=GetResourceString("Common_Colon") %></label>
                        <textarea name="invitationBody" class="tn-textarea tn-input-longest tn-border-gray"
                            id="invitationBody"><%=TempData.GetString("invitationBody", string.Empty)%></textarea>
                    </div>
                    <div class="tn-form-row tn-form-row-button">
                        <label class="tn-form-label">
                        </label>
                        <%=SPBHtmlHelper.Instance().SubmitButton("sendInvitation",GetResourceString("Button_Send"),ButtonSizes.Default,null,null) %>
                        <% if (Request.UrlReferrer != null)
                             {%>
                        <%=SPBHtmlHelper.Instance().CancelButton(ButtonSizes.Default, Request.UrlReferrer.AbsoluteUri)%>
                        <%} %>
                    </div>
                    <div class="tn-form-row">
                        <label class="tn-form-label">
                            <%=GetResourceString("Label_InvitEmailBodyPreview",ApplicationIDs.Instance().User()) %><%=GetResourceString("Common_Colon") %></label>
                        <%=ViewData.GetString("subject",string.Empty) %>
                        <%=ViewData.GetString("body",string.Empty) %>
                    </div>
                </div>
                </form>
            </div>
        </div>
    </div>
</div>
<script type="text/javascript">
$(document).ready(function() {
    $("#NewJoinClubInvitationForm").validate({
        rules: {
            body: { rangelength: [1, 3000] }
        },
        messages: {
            body: { rangelength: "<%=string.Format(GetResourceString("Validate_Pattern_InvitBodyMaxLength",ApplicationIDs.Instance().User()),3000) %>" }
        }
    });

      $("#InvatationAddClubByEmailForm").validate({
        rules: {
            receivers: { required: true },
            subject: { required: true, rangelength: [1, 30] },
            body: { htmlEditorRequired: true, htmlEditorRange: [1, 3000] }
        },
        messages: {
            receivers: { required: "<%=GetResourceString("Message_SendErrorForReceiverEmpty", ApplicationIDs.Instance().User())%>"},
            subject: { required: "<%=GetResourceString("Message_SendErrorForSubjectEmpty", ApplicationIDs.Instance().User())%>", rangelength: "<%=string.Format(GetResourceString("Message_SendErrorForReceiverEmpty", ApplicationIDs.Instance().User()),30)%>" },
            body: { htmlEditorRequired: "<%=GetResourceString("Message_SendErrorForBodyEmpty", ApplicationIDs.Instance().User())%>", htmlEditorRange: "<%=string.Format(GetResourceString("Message_SendErrorForReceiverEmpty", ApplicationIDs.Instance().User()),3000)%>" }
        }
    });

            $("#sendInvitation").click(function() {
        if (!$("#InvatationAddClubByEmailForm").valid()) {
            return false;
        }
        else {
            $("#sendInvitation").val('<%=GetResourceString("Message_Loading")%>');
        }
    });

    $("#sendButton").click(function() {
        if (!$("#NewJoinClubInvitationForm").valid()) {
            return false;
        }
        else {
            $("#sendButton").hide();
            $("#saveButtonA").show();
        }

    });

    $('#getReceivers').nyroModal({
        resizeable: true,
        endShowContent: function(elts, settings) {
            $('#submitButton', elts.contentWrapper).click(function(e) {
                e.preventDefault();
                var receiverDispalyNames = new Array();
                var receiverIDs = new Array();
                $('input[checked][name="userSelectorCheckBox"]', elts.contentWrapper).each(function(i) {
                    var result = eval('(' + $(this).val() + ')');
                    receiverIDs[i] = result.userid;
                    receiverDispalyNames[i] = result.displayname;
                });
                $("#receiverDispalyNames").attr("value", receiverDispalyNames.toString());
                $("#receiverIDs").attr("value", receiverIDs.toString());
                $.nyroModalRemove();
            });
        }
    });
});
</script>
</asp:content>


