﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ClubDomainViewPage" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<spb:Header ID="Header1" runat="Server">
    <spb:Script runat="server" ID="Script1" Src="~/Utility/jquery/jquery.min-1.4.2.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="cookie" Src="~/Utility/jquery/plugin/jquery.cookie.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="core" Src="~/Utility/jquery/ui.core.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="widget" Src="~/Utility/jquery/ui.widget.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="global" Src="~/Utility/tunynet_web_ui/global.js" />
    <spb:Script runat="server" ID="nyroModal" Src="~/Utility/jquery/plugin/jquery.nyroModal-1.6.2.min.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="tabs" Src="~/Utility/jquery/ui.tabs.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="superfish" Src="~/Utility/jquery/plugin/jquery.superfish-1.4.8.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="menuButton" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="watermarkinput" Src="~/Utility/jquery/plugin/jquery.watermarkinput.js" />
    <spb:Script runat="server" ID="validate" Src="~/Utility/jquery/plugin/jquery.validate-1.7.js"
        SetExpireDays="30" />
    
</spb:Header>
<body id="Club-ShareContents" class="tn-page-bg">
    <div class="tn-doc-bg" id="tn-doc">
        <div class="tn-header-bg" id="tn-header">
            <div class="tn-wrapper">
                <%  string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
                    Club currentClub = Clubs.GetClub(clubDomainName, false);
                    ViewData["applicationID"] = ClubDomainSpecialAppIDs.Instance().Share();
                    Html.RenderPartial("Controls/Header.ascx");
                %>
                <div class="spb-header-bottom">
                    <div class="tn-wrapper-inner tn-helper-clearfix">
                        <div class="tn-pagename">
                            <h1 class="tn-helper-reset tn-text-heading">
                                <%=GetResourceString("Title_ClubShare",ApplicationIDs.Instance().Club()) %></h1>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="tn-content-bg tn-doc2" id="tn-content">
            <div class="tn-wrapper tn-template-r-230 tn-helper-clearfix">
                <% int applicationID = ViewData.GetInt("SharedApplicationID", -1);
                   int clubApplicationID = ApplicationIDs.Instance().Club();%>
                <div class="tn-block">
                    <% Html.RenderAction<ClubDomainController>(n => n.Control_ShareStickyContents(clubDomainName, applicationID)); %>
                    <div class="tn-blank10">
                    </div>
                    <% if (CurrentUser != null && Globals.GetCurrentUser().UserType == UserTypes.PersonUser)
                           Html.RenderAction<ClubDomainController>(n => n.Control_MyShareContents(clubDomainName, applicationID)); %>
                    <div class="tn-blank10">
                    </div>
                    <div class="tn-box tn-widget tn-widget-content tn-corner-all">
                        <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
                            <h3 class="tn-helper-reset">
                                <%=GetResourceString("Title_HotTag") %></h3>
                        </div>
                        <div class="tn-box-content tn-widget-content tn-corner-bottom">
                            <%Html.RenderAction("Control_HotTags", "ClubDomain", clubDomainName);%>
                        </div>
                    </div>
                </div>
                <div class="tn-main">
                    <div class="tn-block">
                        <div class="ui-tabs ui-widget ui-widget-content ui-corner-all spb-share-list">
                            <ul class="ui-tabs-nav ui-helper-reset ui-helper-clearfix ui-widget-header ui-corner-all">
                                <%--<li class="caption"><b>
                                    <%=GetResourceString("Title_ClubMemberShare", clubApplicationID)%></b></li>--%>
                                <li class="<%=applicationID == -1 ? "ui-state-default ui-corner-top ui-tabs-selected ui-state-active" : "ui-state-default ui-corner-top" %>">
                                    <a href="<%=SPBUrlHelper.Action("Share","ClubDomain",new RouteValueDictionary{{"clubDomainName",clubDomainName}}) %>">
                                        <span>
                                            <%=GetResourceString("Title_ClubShareAll", clubApplicationID)%></span></a></li>
                                <%  //被分享内容的所属应用ID
                                    if (ViewData["listNavigation"] != null)
                                    {
                                        IList<int> list = ViewData["listNavigation"] as IList<int>;
                                        foreach (var item in list)
                                        {
                                            if (Applications.IsEnabled(item))
                                            {
                                %>
                                <li class="<%=applicationID == item ? "ui-state-default ui-corner-top ui-tabs-selected ui-state-active" : "ui-state-default ui-corner-top" %>">
                                    <a href="<%=SPBUrlHelper.Action("Share", "ClubDomain", new RouteValueDictionary { { "clubDomainName", clubDomainName }, { "applicationID", item } }) %>">
                                        <span>
                                            <%=Applications.GetApplication(item).GetMultilingualApplicationName(CurrentUserLanguage)%></span></a></li>
                                <%   }
                                        }
                                    }
                                %>
                            </ul>
                            <div class="ui-tabs-panel ui-widget-content ui-corner-bottom">
                                <% 
                                    int pageIndex = Request.QueryString.GetInt("pageIndex", 1);
                                    //int isThumb = Request.QueryString.GetInt("isThumb", -1);
                                    string tagName = Request.QueryString.GetString("TagName", string.Empty);
                                    //if (isThumb > 0)
                                    //{
                                    //    Html.RenderAction<ClubDomainController>(n => n.Control_ListThumbPhotos(clubDomainName, applicationID, pageIndex));
                                    //}
                                    //else
                                    //{
                                    Html.RenderAction<ClubDomainController>(n => n.Control_ListShareContents(clubDomainName, pageIndex, applicationID, tagName));
                                    //}
                                %>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="tn-footer-bg" id="tn-footer">
            <div class="tn-wrapper">
                <% Html.RenderPartial("Controls/Footer.ascx"); %>
            </div>
        </div>
    </div>
</body>
</html>
