﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.ClubDomainViewPage<PagingDataSet<VoteComment>>" %>

<asp:content id="manageMenusContent" contentplaceholderid="manageMenusContent" runat="server">
   <%
       ViewData["manageClubMenu"] = ManageClubMenu.ManageContent;
       ViewData["manageClubSubMenu"] = ManageClubSubMenu.ManageVoteComments;
       Html.RenderPartial("Controls/Manage/ClubManageMenu.ascx", ViewData); 
   %>
</asp:content>
<asp:content id="manageContent" contentplaceholderid="manageContent" runat="server">
<%int clubApplicationID = ApplicationIDs.Instance().Club();%>
    <div class="tn-box tn-widget tn-widget-content tn-corner-all">
       <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
         <h3 class="tn-helper-reset"><%=GetResourceString("Title_MangerVoteReview",ApplicationIDs.Instance().Vote())%></h3>
       </div>
       <div id="manageClubShareItemDiv" class="tn-box-content tn-widget-content tn-corner-bottom">
       <%
           string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
           if (TempData["StatusMessageType"] != null)
           {
               StatusMessageType messageType = (StatusMessageType)TempData.GetInt("StatusMessageType", (int)StatusMessageType.Error);
               if (messageType == StatusMessageType.Success)
                   Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty), 3000));
               else
                   Response.Write(SPBHtmlHelper.Instance().StatusMessage(messageType, TempData.GetString("StatusMessageContent", string.Empty)));
               TempData["StatusMessageType"] = null;
           }%>
       <div class="tn-list-header">
           <div class="tn-toolbar tn-helper-clearfix">
               <div class="tn-tool-form">                
                   <%=SPBHtmlHelper.Instance().LinkButton("deleteVoteComments",GetResourceString("Action_Delete"),"javascript:;", ButtonSizes.Default, HighlightStyles.Default,IconTypes.Cross,TextIconLayout.IconText,null,null) %>
               </div>
           </div>
       </div>
       <form id="ManageCommentsForm" method="post" action="<%=Url.Action("DeleteComments","ClubVote",new {clubDomainName=Html.GetParameterFromRouteDateOrQueryString("clubDomainName"),returnUrl= Request.RawUrl}) %>">
          <table class="tn-table-grid">
              <tr class="tn-table-grid-header">
                  <td class="tn-border-gray tn-border-bottom tn-text-note">
                      <input type="checkbox" id="TopCheckBox" class="tn-checkbox" onclick="checkAll(this,'ManageCommentsCheckBoxGroup')" />
                  </td>
                  <td class="tn-border-gray tn-border-bottom tn-text-note">
                      <%=GetResourceString("Label_Body")%>
                  </td>
                  <td class="tn-border-gray tn-border-bottom tn-text-note">
                      <%=GetResourceString("Label_CommentUser")%>
                  </td>
                  <td class="tn-border-gray tn-border-bottom tn-text-note">
                      <%= GetResourceString("Label_CommentDate")%>
                  </td>
                  <td class="tn-border-gray tn-border-bottom tn-text-note">
                       <%=GetResourceString("Label_Actions")%>
                  </td>
              </tr>
              <% 
                  if (Model != null)
                  {
                      foreach (VoteComment comment in Model.Records)
                      {%>
              <tr class="tn-table-grid-row">
                  <td class="tn-border-gray tn-border-bottom tn-width-check">
                      <input type="checkbox" class="tn-checkbox" name="ManageCommentsCheckBoxGroup" value="<%=comment.CommentID %>" />
                  </td>                                                                                    
                  <td class="tn-border-gray tn-border-bottom tn-width-auto">
                      <span><a href="<%=SiteUrls.Instance().ShowClubVoteThread(clubDomainName,comment.ThreadID) %>" target="_blank">
                        <%=HtmlUtils.TrimHtml(comment.Body,40)%>
                        </a> </span>
                  </td>
                  <td class="tn-border-gray tn-border-bottom tn-width-user-name tn-nowrap">
                      <a href="<%=SiteUrls.Instance().UserDomainHome(comment.UserID) %>" target="_blank">
                      <%=comment.Author%></a>
                  </td>
                  <td class="tn-border-gray tn-border-bottom tn-width-date tn-nowrap">
                       <%=Formatter.FormatDate(comment.DateCreated) %>
                  </td>
                  <td class="tn-border-gray tn-border-bottom tn-width-action1 tn-nowrap">
                    <span class="tn-action">
                        <a class="class="tn-action-text"" onclick="if (!confirm('<%=GetResourceString("Valedate_AskDeleteVote",ApplicationIDs.Instance().Vote())%>') ) return false;" href="<%=Url.Action("DeleteCommentInManage", "ClubVote", new { commentID = comment.CommentID,returnUrl= Request.RawUrl}) %>"><%=GetResourceString("Action_Delete")%></a>
                    </span>
                  </td>
              </tr>
              <%}
                  } %>
          </table>
       </form>
    <div class="tn-pagination tn-helper-align-center">
    <%=SPBHtmlHelper.Instance().PagingButton( PaginationMode.NumericNextPrevious,Model.TotalRecords,Model.PageSize, ViewData.Model.PageIndex)%> 
    </div>
   </div>
</div>
<script type="text/javascript">
    $(document).ready(function() {
        $("#deleteVoteComments").click(function() {
            if ($("#ManageCommentsForm :checkbox:checked").length <= 0) {
                alert('至少选择一条评论！');
                return false;
            }
            if (confirm('<%=GetResourceString("Valedate_AskDeleteVote",ApplicationIDs.Instance().Vote())%>'))
                $('#ManageCommentsForm').submit();
            return false;
        });
    });
</script>
</asp:content>
