﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%  
    string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
    Club currentClub = Clubs.GetClub(clubDomainName, false);

    int applicationID = ViewData.GetInt("applicationID", 0);

    int currentUserPresentAreaID = PresentAreaIDs.Instance().ClubDomain();

    bool isRealTime = ClubPermission.Validate(currentClub, CurrentUser, PermissionItemKeys.Instance().EditClub());
    IList<OwnerNavigation> clubNavigations = Navigations.GetOwnerNavigations(currentUserPresentAreaID, currentClub.ClubID, isRealTime);
    PresentArea presentArea = PresentAreas.GetPresentArea(PresentAreaIDs.Instance().ClubDomain(), false);
    int clubApplicationID = ApplicationIDs.Instance().Club();

%>
<div class="spb-branding-area">
    <div class="tn-wrapper-inner">
        <%if (currentClub.ClubHeaderShowTypes != ClubHeaderShowTypes.OnlyShowText && currentClub.HasBanner)
          { %>
        <div class="spb-club-image">
            <%=SPBHtmlHelper.Instance().ShowClubBanner(currentClub.ClubID, true,null)%>
        </div>
        <%} %>
        <%if (currentClub.ClubHeaderShowTypes != ClubHeaderShowTypes.OnlyShowBanner)
          { %>
        <h1 class="spb-club-name">
            <%=currentClub.ClubName%></h1>
        <p class="spb-club-intro">
            <%=currentClub.Brief %></p>
        <%} %>
    </div>
</div>
<div class="spb-nav1-area">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <div class="tn-shortcut">
            <% if (CurrentUser != null && (ClubMembers.HasClubManagerPermission(currentClub.ClubID, CurrentUser.UserID) || CurrentUser.IsContentAdministrator))
               {%>
            <%=SPBHtmlHelper.Instance().LinkButton("clubManage", GetResourceString("Action_Manage"), SPBUrlHelper.Action("Home", "ClubManage", new RouteValueDictionary { { "clubDomainName", currentClub.DomainName } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.TriangleDown, TextIconLayout.MenuButton, new RouteValueDictionary { { "menu", "#manage" }, { "class", "tn-menu-button-active" } }, null)%>
            <ul id="manage" class="tn-menu-button-position tn-menu tn-menu-text-icon tn-helper-reset tn-widget-content">
                <%if (presentArea != null && presentArea.EnableThemes)
                  { %>
                <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ModifyHome","ClubManage",new RouteValueDictionary{{"clubDomainName", currentClub.DomainName}}) %>">
                    <%=GetResourceString("Action_ModifyClubHome", clubApplicationID)%></a></li>
                <%} %>
                <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("Home", "ClubManage", new RouteValueDictionary { { "clubDomainName", currentClub.DomainName } }) %>">
                    进入控制面板</a></li>
                <% if (CurrentUser.IsContentAdministrator)
                   {%>
                <li class="tn-menu-item"><a class="tn-menu-text" id="recommendClubModel" href="<%=SiteUrls.Instance().RecommendItem(ApplicationIDs.Instance().Club(),currentClub.ClubOwnerUserID,currentClub.ClubID,currentClub.ClubName)%>">
                    <%=GetResourceString("Common_ManagerRecommend")%></a></li>
                <%}%>
            </ul>
            <%} %>
            <%    bool isClubMember = false;
                  if (CurrentUser != null)
                  {
                      ClubMember member = ClubMembers.GetClubMember(currentClub.ClubID, CurrentUser.UserID, true);
                      if (member != null)
                          isClubMember = true;
                  } if (currentClub.IsPublic && CurrentUser != null && !isClubMember)
                  {%>
            <%=SPBHtmlHelper.Instance().LinkButton("applyJionClub", GetResourceString("Action_ApplyClubMember", clubApplicationID), SPBUrlHelper.Action("ApplyClubMember", "ClubDomain", new RouteValueDictionary { { "clubDomainName", currentClub.DomainName }, { "inviteUserID", -1 } }), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.Join, TextIconLayout.IconText)%>
            <%}
                  string excetionType = ExceptionTypes.Instance().AccessDenied();
                  if (ClubPermission.Validate(currentClub, CurrentUser, PermissionItemKeys.Instance().InviteFriendJoinClub(), ref excetionType) && isClubMember)
                  {%>
            <%=SPBHtmlHelper.Instance().LinkButton("inviteFirends",GetResourceString("Action_InvitationFriend"), SPBUrlHelper.Action("NewJoinClubInvitation", "ClubDomain", new RouteValueDictionary { { "clubDomainName", currentClub.DomainName } }), ButtonSizes.Default, HighlightStyles.Primary, IconTypes.UserInvite, TextIconLayout.IconText)%>
            <%}%>
        </div>
        <ul class="spb-nav1">
            <li <% if(applicationID==ClubDomainSpecialAppIDs.Instance().Home()) Response.Write("class=\"spb-nav-item tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("Home","ClubDomain",new RouteValueDictionary{{"clubDomainName",currentClub.DomainName}}) %>">
                    <span>
                        <%=GetResourceString("Navigation_ClubDomain_Home")%></span></a></li>
            <%
                foreach (var navigation in clubNavigations)
                {
                    if (navigation.IsEnabled)
                        Response.Write(string.Format("<li class=\"{2}\"><a target=\"{0}\" href=\"{1}\"><span>{3}</span></a></li>", navigation.NavigationTarget, navigation.GetClubNavigationUrl(currentClub.DomainName), applicationID == navigation.ApplicationID ? "spb-nav-item tn-selected" : "spb-nav-item", HtmlUtils.TrimHtml(navigation.GetMultilingualNavigationName(CurrentUserLanguage), 6)));
                }
            %>
            <li <% if(applicationID==ClubDomainSpecialAppIDs.Instance().Share()) Response.Write("class=\"spb-nav-item tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("Share","ClubDomain",new RouteValueDictionary{{"clubDomainName",currentClub.DomainName}}) %>">
                    <span>
                        <%=GetResourceString("Navigation_ClubDomain_Share")%></span></a></li>
            <% if (CurrentUser != null && (ClubMembers.HasClubManagerPermission(currentClub.ClubID, CurrentUser.UserID) || CurrentUser.IsContentAdministrator))
               {%>
            <li <% if(applicationID==ClubDomainSpecialAppIDs.Instance().Activities()) Response.Write("class=\"spb-nav-item tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("ListClubActivities","ClubDomain",new RouteValueDictionary{{"clubDomainName",currentClub.DomainName}}) %>">
                    <span>群动态</span></a></li>
            <li <% if(applicationID==ClubDomainSpecialAppIDs.Instance().Members()) Response.Write("class=\"spb-nav-item tn-selected\""); else Response.Write("class=\"spb-nav-item\""); %>>
                <a href="<%=SPBUrlHelper.Action("Home","ClubMember",new RouteValueDictionary{{"clubDomainName",currentClub.DomainName}}) %>">
                    <span>群成员</span></a></li>
            <%} %>
        </ul>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $("a[menu]").menuButton();
        $('#recommendClubModel').nyroModal({
            resizeable: true,
            height: 450,
            width: 400
        });
    });  
</script>

