﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
    <spb:Script runat="server" ID="JqueryFormJs" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    SetExpireDays="30" />
<spb:script runat="server" id="artDialog" src="~/Utility/jquery/plugin/jquery.artDialog.min-3.0.5.js"
    setexpiredays="30" />
<spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="superfish" Src="~/Utility/jquery/plugin/jquery.superfish-1.4.8.js"
    SetExpireDays="30" />
<% 
    
    int notReadMessageCount = 0;
    int unsettledInvitationTotalCount = 0;
    int notReadNoticeCount = 0;
    int applicationID = ViewData.GetInt("applicationID", 0);
    if (CurrentUser != null)
    {
        //获取未读消息
        notReadMessageCount = PrivateMessages.GetNoReadCount(CurrentUser.UserID);

        //获取未处理邀请字典集合
        Dictionary<int, int> unsettledInvitationCounts = Invitations.GetUnsettledCounts(CurrentUser.UserID);

        foreach (KeyValuePair<int, int> pair in unsettledInvitationCounts)
        {
            unsettledInvitationTotalCount += pair.Value;
        }
        notReadNoticeCount = InstationNotices.GetNoReadCount(CurrentUser.UserID);
    }
    int totalCount = notReadMessageCount + unsettledInvitationTotalCount + notReadNoticeCount;
    // IList<Navigation> list = Navigations.GetChannelNavigations();
%>
<div id="menubar">
    <div id="spb-logo">
        <a href="<%=SiteUrls.Instance().Home() %>">
           <%=Globals.SiteName %> <%--<img src="<%=WebUtils.ResolveUrl("~/Themes/Channels/Kaixin/Appearances/Default/Images/logo.png") %>" />--%></a></div>
    <div class="tn-search-box">
        <form id="searchForm" action="<%=SPBUrlHelper.Action("Search","ChannelClub") %>" method="post">
        <input type="text" name="keyword" id="keyword" class="tn-search-input">
        <span class="tn-search-button tn-search-ico-button">
            <button onclick="$('#searchForm').submit();">
                <span class="tn-icon tn-icon-find"></span>
            </button>
        </span>
        </form>
    </div>
    <% 
        if (CurrentUser != null)
        { %>
    <div class="spb-user-menu">
        <ul>
            <% if (CurrentUser.UserType == UserTypes.PersonUser)
               { %>
            <li><a href="<%=SiteUrls.Instance().NewFriendInvitationByEmail(CurrentUser.UserName) %>">
                <%=GetResourceString("Action_InvitationFriend")%></a></li>
            <% } %>
            <li class="spb-separator"></li>
            <li><a href="<%=SPBUrlHelper.Action("Logout","ChannelUser") %>">
                <%=GetResourceString("Action_Logout")%></a></li>
            <li class="spb-separator"></li>
            <li><a href="<%=WebUtils.ResolveUrl("~/Help/Home.html") %>" target="_blank">
                <%=GetResourceString("Common_Help")%></a></li>
        </ul>
    </div>
    <div class="spb-nav-area">
        <div class="tn-wrapper-inner">
            <ul class="spb-nav tn-helper-reset tn-helper-clearfix sf-menu">
                <li class="spb-nav-item"><span><a href="<%=SiteUrls.Instance().UserDomainHome(CurrentUser.UserName)%>">
                    <%=GetResourceString("Navigation_UserDomain_MyHome") %>
                </a></span></li>
                <li class="spb-separator"></li>
                <li class="spb-nav-item"><span><a href="<%=SiteUrls.Instance().UserDomainMasterHome(CurrentUser.UserName)%>">
                    <%=GetResourceString("Label_PersonalWebAdress")%></a></span></li>
                <li class="spb-separator"></li>
                <li class="spb-nav-item"><span><a href="<%=SiteUrls.Instance().Home() %>">
                    <%=GetResourceString("Navigation_CasualLookAt") %></a></span></li>
                <li class="spb-separator"></li>
                <li class="spb-nav-item"><a href="<%=SiteUrls.Instance().ListMessageInBox(CurrentUser.UserName) %>"
                    class="sf-with-ul"><span>
                        <%=GetResourceString("Navigation_UserDomain_MessageCenter_KaiXin")%></span></a>
                    <% if (totalCount > 0)
                       { %>
                    <span class="tn-msg-bubble"><span class="tn-img-sprite tn-msg-bubble-left"></span><span
                        class="tn-img-sprite tn-msg-bubble-center">
                        <%=totalCount %></span> <span class="tn-img-sprite tn-msg-bubble-right"></span>
                    </span>
                    <%} %>
                    <ul class="tn-bg-gray tn-border-gray" style="visibility: hidden; display: none;">
                        <li><a href="<%=SiteUrls.Instance().ListMessageInBox(CurrentUser.UserName) %>">
                            <%=GetResourceString("Action_PrivateMessage")%>
                            <% if (notReadMessageCount > 0)
                                   Response.Write(string.Format("({0})", notReadMessageCount)); %>
                        </a></li>
                        <% if (CurrentUser.UserType == UserTypes.PersonUser)
                           { %>
                        <li><a href="<%=SiteUrls.Instance().ListInvitationInBox(CurrentUser.UserName) %>">
                            <%=GetResourceString("Action_Invitation")%>
                            <% if (unsettledInvitationTotalCount > 0)
                                   Response.Write(string.Format("({0})", unsettledInvitationTotalCount)); %>
                        </a></li>
                        <%} %>
                        <li><a href="<%=SiteUrls.Instance().ListNoticeRecords(CurrentUser.UserName) %>">
                            <%=GetResourceString("Action_Notice")%>
                            <% if (notReadNoticeCount > 0)
                                   Response.Write(string.Format("({0})", notReadNoticeCount)); %>
                        </a></li>
                    </ul>
                </li>
                <li class="spb-separator"></li>
                <li class="spb-nav-item"><a href="<%=SiteUrls.Instance().UserEditProfile(CurrentUser) %>"
                    class="sf-with-ul"><span>
                        <%=GetResourceString("Navigation_UserDomain_UserSetting")%></span></a>
                    <ul class="tn-bg-gray tn-border-gray" style="visibility: hidden; display: none;">
                        <li><a href="<%=SPBUrlHelper.Action("ModifyHome","UserDomainSettings",new RouteValueDictionary {{"userDomainName",CurrentUser.UserName} })%>">
                            <%=GetResourceString("Title_ModifyHome",ApplicationIDs.Instance().User()) %></a>
                        </li>
                        <li><a href="<%=SiteUrls.Instance().UserEditProfile(CurrentUser) %>">
                            <%=GetResourceString("Title_UpdateProfile",ApplicationIDs.Instance().User()) %></a></li>
                        <li><a href="<%=SiteUrls.Instance().UserPrivacySettings(CurrentUser.UserName) %>">
                            <%=GetResourceString("Label_PrivacySetting")%></a></li>
                        <li><a href="<%=SiteUrls.Instance().UserNoticeSettings(CurrentUser.UserName) %>">
                            <%=GetResourceString("Title_NoticeSettings",ApplicationIDs.Instance().User()) %></a></li>
                        <li class="spb-separator tn-border-light tn-border-bottom"></li>
                        <% if (CurrentUser.IsInRoles(SiteSettingsManager.GetSiteSettings().RoleNamesForEnterControlPanel))
                           { %>
                        <li><a target="_blank" href="<%=SiteUrls.Instance().ManageHome() %>">
                            <%=GetResourceString("Navigation_Manage_Home")%></a></li>
                        <%} %>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
    <%}
        else
        { %>
    <div class="spb-user-menu">
        <ul>
            <li><a href="<%=SiteUrls.Instance().LoginInModal() %>" id="loginInModalButton">
                <%=GetResourceString("Action_Login")%></a></li>
            <li class="spb-separator"></li>
             <%if (SiteSettingsManager.GetSiteSettings().RegistrationMode == RegistrationModes.EnableAll)
                  { %>
            <li><a href="<%=SiteUrls.Instance().UserRegister() %>">
                <%=GetResourceString("Action_Register")%></a></li>
                <%} %>
            <li class="spb-separator"></li>
            <li><a href="<%=WebUtils.ResolveUrl("~/Help/Home.html") %>" target="_blank">
                <%=GetResourceString("Action_Help")%></a></li>
        </ul>
    </div>
    <div class="spb-nav-area">
        <div class="tn-wrapper-inner">
            <ul class="spb-nav tn-helper-reset tn-helper-clearfix sf-menu">
                <li class="spb-nav-item"><span><a href="<%=SiteUrls.Instance().Home() %>">
                    <%=GetResourceString("Navigation_CasualLookAt") %></a></span></li>
            </ul>
        </div>
    </div>
    <%} %>
</div>

<script type="text/javascript">
    $(document).ready(function() {
    $("#keyword").watermark("<%=GetResourceString("Label_FindClubs",ApplicationIDs.Instance().Club()) %>");         
        $('ul.sf-menu').superfish();
        $('#loginInModalButton').dialog({
                id: 'loginDialog',
                title: '登录',
                width: 400             
            });
        if(<%=totalCount %> > 0)
        newMessageHint('<%=GetResourceString("Description_NewMessage")%>');
    });  
</script>