﻿<%@ Page Title="" Language="C#" AutoEventWireup="true" CodeBehind="Home.aspx.cs"
    Inherits="SpaceBuilder.Web.ClubDomainViewPage<Club>" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<spb:Header ID="Header1" runat="Server">
    <spb:Script runat="server" ID="Script1" Src="~/Utility/jquery/jquery.min-1.4.2.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="cookie" Src="~/Utility/jquery/plugin/jquery.cookie.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="core" Src="~/Utility/jquery/ui.core.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="widget" Src="~/Utility/jquery/ui.widget.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="global" Src="~/Utility/tunynet_web_ui/global.js" />
    <spb:Script runat="server" ID="nyroModal" Src="~/Utility/jquery/plugin/jquery.nyroModal-1.6.2.min.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="tabs" Src="~/Utility/jquery/ui.tabs.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="superfish" Src="~/Utility/jquery/plugin/jquery.superfish-1.4.8.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="menuButton" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="watermarkinput" Src="~/Utility/jquery/plugin/jquery.watermarkinput.js" />
    <spb:Script runat="server" ID="validate" Src="~/Utility/jquery/plugin/jquery.validate-1.7.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="jqueryForm" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js"
        SetExpireDays="30" />
    
</spb:Header>
<body class="tn-page-bg spb-club-home" id="Club-Home">
    <div id="tn-doc" class="tn-doc-bg">
        <div id="tn-header" class="tn-header-bg">
            <div class="tn-wrapper tn-helper-clearfix">
                <%  string clubDomainName = Html.GetParameterFromRouteDateOrQueryString("clubDomainName");
                    
                    Club currentClub = Clubs.GetClub(clubDomainName, false);
                    if (currentClub == null)
                        throw new SPBException(ExceptionTypes.Instance().ClubDomainNotFond());
                    Html.RenderPartial("Controls/Header.ascx");
                %>
            </div>
        </div>
        <div id="tn-content" class="tn-content-bg tn-doc2">
            <div class="tn-wrapper">
                <div class="spb-page-container">
                    <% ViewData["applicationID"] = ClubDomainSpecialAppIDs.Instance().Home();
                       Html.RenderPartial("Controls/ClubChannelMenu.ascx", ViewData); %>
                    <div class="tn-grid spb-section-0">
                        <div class="tn-unit tn-first">
                            <%
                                //群组资料
                                SPBHtmlHelper.Instance().RenderWidgetInClubDomain(Html, "ff138c189655b2fa", currentClub);
                                //群主
                                SPBHtmlHelper.Instance().RenderWidgetInClubDomain(Html, "bc19353223ead625", currentClub);


                            %>
                        </div>
                        <div class="tn-grid">
                            <div class="tn-unit tn-first">
                                <% SPBHtmlHelper.Instance().RenderWidgetInClubDomain(Html, "758e366d28410f03", currentClub);

                                   //群组动态
                                   SPBHtmlHelper.Instance().RenderWidgetInClubDomain(Html, "84392c1ae417fb17", currentClub);

                                   //群组话题
                                   SPBHtmlHelper.Instance().RenderWidgetInClubDomain(Html, "3d99ab72e41c3703", currentClub);

                                   //群组活动
                                   SPBHtmlHelper.Instance().RenderWidgetInClubDomain(Html, "5b378bbd2f714c22", currentClub);

                                   //群组分享
                                   SPBHtmlHelper.Instance().RenderWidgetInClubDomain(Html, "27dc9166abefcdbf", currentClub); %>
                            </div>
                            <div class="tn-unit">
                                <%   //最近访客
                                    SPBHtmlHelper.Instance().RenderWidgetInClubDomain(Html, "5a3a98cb19a47145", currentClub);

                                    //群组友情链接
                                    SPBHtmlHelper.Instance().RenderWidgetInClubDomain(Html, "b70a7f37d002a83a", currentClub);%>
                            </div>
                        </div>
                    </div>
                </div>
        </div>
        <div class="tn-footer-bg" id="tn-footer">
            <div class="tn-wrapper">
                <% Html.RenderPartial("Controls/Footer.ascx"); %>
            </div>
        </div>
    </div>
</body>
</html>
