﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<% 
    int BlogApplicationID = ApplicationIDs.Instance().Blog();
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
    User currentDomainUser = Users.GetUser(userDomainName, false);

    bool isOwner = false;
    if (CurrentUser != null && (CurrentUser.UserID == currentDomainUser.UserID || CurrentUser.IsContentAdministrator))
        isOwner = true;
%>
<% if (isOwner)
   {%>

<div class="spb-nav2-area">
  <div class="tn-wrapper-inner tn-helper-clearfix">
    <ul class="spb-nav2 tn-helper-left">
      <li class="spb-nav-item tn-text-note tn-selected"><a href="<%=SPBUrlHelper.Action("Home", "Blog", new RouteValueDictionary { { "userDomainName", userDomainName } })%>"> <span> <%=GetResourceString("Navigation_MyBlog", BlogApplicationID)%></span></a></li>
      <li class="spb-nav-item"><a href="<%=SiteUrls.Instance().ChannelBlogHome() %>" target="_blank"> <span> <%=GetResourceString("Navigation_ElseUserBlog", BlogApplicationID)%></span></a></li>
    </ul>
    <div class="tn-helper-right"> <%=SPBHtmlHelper.Instance().LinkButton("blogManage", GetResourceString("Title_BlogManage", BlogApplicationID),SPBUrlHelper.Action("ManageBlogThreads", "Blog", new RouteValueDictionary { { "userDomainName", userDomainName } }), ButtonSizes.Default, HighlightStyles.Default, IconTypes.TriangleDown, TextIconLayout.MenuButton,null, new RouteValueDictionary { { "menu", "#manage" }, { "class", "tn-menu-button-active" } })%>
      <ul id="manage" class="tn-menu-button-position tn-menu tn-menu-text-icon tn-widget-content">
        <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageBlogThreads", "Blog", new RouteValueDictionary { { "userDomainName", userDomainName } })%>"> <%=GetResourceString("Action_ArticleManage",BlogApplicationID)%></a></li>
        <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageBlogComments","Blog",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"> <%=GetResourceString("Action_CommentManage")%></a></li>
        <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageBlogUserTags", "Blog", new RouteValueDictionary { { "userDomainName", userDomainName } })%>"> <%=GetResourceString("Action_TagManage")%></a></li>
        <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageBlogUserCategories", "Blog", new RouteValueDictionary { { "userDomainName", userDomainName } })%>"> <%=GetResourceString("Common_ManageCategory")%></a></li>
        <li class="tn-menu-item"><a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ManageBlogSettings","Blog",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>"> <%=GetResourceString("Action_BlogSet", BlogApplicationID)%></a></li>
      </ul>
      <%=SPBHtmlHelper.Instance().LinkButton("newBlogThreadLink", GetResourceString("Button_ReleaseArticle", BlogApplicationID), SPBUrlHelper.Action("NewBlogThread", "Blog", new RouteValueDictionary { { "userDomainName", userDomainName } }), ButtonSizes.Default, HighlightStyles.Primary,IconTypes.Write,TextIconLayout.IconText)%> </div>
  </div>
  <script type="text/javascript">
        $(document).ready(function() {
            $("[menu]", $(".spb-nav2-area")).menuButton();
        });
    </script>
</div>
<%} %>
