﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
    <spb:Script runat="server" ID="JqueryFormJs" Src="~/Utility/jquery/plugin/jquery.form.min-2.7.3.js"
    SetExpireDays="30" />
<spb:script runat="server" id="artDialog" src="~/Utility/jquery/plugin/jquery.artDialog.min-3.0.5.js"
    setexpiredays="30" />
<spb:Script runat="server" ID="blockUI" Src="~/Utility/jquery/plugin/jquery.blockUI-2.3.3.js"
    SetExpireDays="30" />
<spb:Script runat="server" ID="superfish" Src="~/Utility/jquery/plugin/jquery.superfish-1.4.8.js"
    SetExpireDays="30" />
<%
    
    int UserapplicationID = ApplicationIDs.Instance().User();
    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");
    User currentDomainUser = Users.GetUser(userDomainName, false);
    CompanyUser companyUser = currentDomainUser as CompanyUser;
    if (companyUser == null)
        throw new ArgumentNullException(GetResourceString("Exception_CompanyUserNotFound", UserapplicationID));

    int notReadMessageCount = 0;
    int unsettledInvitationTotalCount = 0;
    int notReadNoticeCount = 0;
    int applicationID = ViewData.GetInt("applicationID", 0);
    if (CurrentUser != null)
    {
        //获取未读消息
        notReadMessageCount = PrivateMessages.GetNoReadCount(CurrentUser.UserID);

        //获取未处理邀请字典集合
        Dictionary<int, int> unsettledInvitationCounts = Invitations.GetUnsettledCounts(CurrentUser.UserID);

        foreach (KeyValuePair<int, int> pair in unsettledInvitationCounts)
        {
            unsettledInvitationTotalCount += pair.Value;
        }
        notReadNoticeCount = InstationNotices.GetNoReadCount(CurrentUser.UserID);
    }
    int totalCount = notReadMessageCount + unsettledInvitationTotalCount + notReadNoticeCount;
    IList<Navigation> list = Navigations.GetDefaultNavgitions(PresentAreaIDs.Instance().Channel(), false);
    bool isUserDomainOwnerOrAdministrator = false;
    if (CurrentUser != null && (currentDomainUser.UserID == CurrentUser.UserID || CurrentUser.IsContentAdministrator || CurrentUser.IsAdministrator))
        isUserDomainOwnerOrAdministrator = true;
    int currentUserPresentAreaID = PresentAreaIDs.Instance().UserDomain();
    if (CurrentUser != null && CurrentUser.UserType == UserTypes.CompanyUser)
        currentUserPresentAreaID = PresentAreaIDs.Instance().CompanyUserDomain();
    IList<OwnerNavigation> currentUserNavigations = Navigations.GetOwnerNavigations(currentUserPresentAreaID, CurrentUser != null ? CurrentUser.UserID : 0, true);
    IList<OwnerNavigation> currentDomainUserNavigations = Navigations.GetOwnerNavigations(PresentAreaIDs.Instance().CompanyUserDomain(), currentDomainUser.UserID, isUserDomainOwnerOrAdministrator);

    int count = UserDomainConfiguration.Instance().MaxApplicationMenuCount;//一级导航最多显示几个菜单
    if (count < 1) count = 1;
    if (count > currentDomainUserNavigations.Count) count = currentDomainUserNavigations.Count;

%>
<div class="spb-top-menubar">
    <div class="tn-wrapper-inner tn-helper-clearfix">
        <div class="spb-home-link">
            <span class="tn-icon tn-icon-home"></span><a class="spb-top-logo-link" href="<%=SiteUrls.Instance().Home() %>">
                <%=Globals.SiteName %></a>
        </div>
        <div class="spb-user-menu">
            <% 
                if (CurrentUser != null)
                { %>
            <ul class="sf-menu">
                <li><a href="<%=WebUtils.ResolveUrl("~/Help/Home.html") %>" target="_blank">
                    <%=GetResourceString("Common_Help")%></a></li>
                <li><a href="<%=SPBUrlHelper.Action("Logout","ChannelUser") %>">
                    <%=GetResourceString("Action_Logout")%></a></li>
                <li><a href="<%=SiteUrls.Instance().UserEditProfile(CurrentUser) %>" class="sf-with-ul">
                  <%=GetResourceString("Navigation_UserDomain_UserSetting")%></a>
                    <ul class="tn-widget tn-widget-content tn-bg-light tn-corner-all" style="visibility: hidden;
                        display: none;">
                        <li><a href="<%=SiteUrls.Instance().UserEditProfile(CurrentUser) %>">
                            <%=GetResourceString("Title_UserProfileInfo", UserapplicationID)%></a></li>
                        <li><a href="<%=SiteUrls.Instance().UserPrivacySettings(CurrentUser.UserName) %>">
                            <%=GetResourceString("Title_ArchivesPrivacySetting", UserapplicationID)%></a></li>
                        <li><a href="<%=SiteUrls.Instance().UserNoticeSettings(CurrentUser.UserName) %>">
                            <%=GetResourceString("Title_NoticeSettings", UserapplicationID)%></a></li>
                    </ul>
                </li>
                <li class="tn-msg-bubble-position"><a href="<%=SiteUrls.Instance().ListMessageInBox(CurrentUser.UserName) %>"
                    class="sf-with-ul">
                    <%=GetResourceString("Navigation_UserDomain_MessageCenter")%></a>
                    <% if (totalCount > 0)
                       { %>
                    <span class="tn-msg-bubble"><span class="tn-img-sprite tn-msg-bubble-left"></span><span
                        class="tn-img-sprite tn-msg-bubble-center">
                        <%=totalCount %></span> <span class="tn-img-sprite tn-msg-bubble-right"></span>
                    </span>
                    <%} %>
                    <ul class="tn-widget tn-widget-content tn-bg-light tn-corner-all">
                        <li><a href="<%=SiteUrls.Instance().ListMessageInBox(CurrentUser.UserName) %>">
                            <%=GetResourceString("Action_PrivateMessage")%>
                            <% if (notReadMessageCount > 0)
                                   Response.Write(string.Format("({0})", notReadMessageCount)); %>
                        </a></li>
                        <% if (CurrentUser.UserType == UserTypes.PersonUser)
                           { %>
                        <li><a href="<%=SiteUrls.Instance().ListInvitationInBox(CurrentUser.UserName) %>">
                            <%=GetResourceString("Action_Invitation")%>
                            <% if (unsettledInvitationTotalCount > 0)
                                   Response.Write(string.Format("({0})", unsettledInvitationTotalCount)); %>
                        </a></li>
                        <%} %>
                        <li><a href="<%=SiteUrls.Instance().ListNoticeRecords(CurrentUser.UserName) %>">
                            <%=GetResourceString("Action_Notice")%>
                            <% if (notReadNoticeCount > 0)
                                   Response.Write(string.Format("({0})", notReadNoticeCount)); %>
                        </a></li>
                    </ul>
                </li>
                <li><a href="<%=SiteUrls.Instance().UserDomainHome(CurrentUser) %>">
                    <%=SPBHtmlHelper.Instance().UserDisplayName(CurrentUser)%></a>
                    <ul class="tn-widget tn-widget-content tn-bg-light tn-corner-all">
                        <li><a href="<%=Globals.GetFullUrlInMainSite(SiteUrls.Instance().UserDomainHome(CurrentUser.UserName))%>">
                            <% if (CurrentUser.UserType == UserTypes.PersonUser) Response.Write(GetResourceString("Navigation_UserDomain_MyHome")); else Response.Write(GetResourceString("Navigation_UserDomain_Home"));%></a></li>
                        <%  if (CurrentUser.IsInRoles(SiteSettingsManager.GetSiteSettings().RoleNamesForEnterControlPanel))
                            { %>
                        <li><a target="_blank" href="<%=SiteUrls.Instance().ManageHome() %>">
                            <%=GetResourceString("Navigation_Manage_Home")%></a></li>
                        <%} if (currentUserNavigations != null)
                            { %>
                        <%  foreach (OwnerNavigation navigation in currentUserNavigations)
                            {
                                if (!navigation.IsVisible(true))
                                    continue;                            
                        %>
                        <li><a href="<%=navigation.GetUserNavigationUrl(CurrentUser.UserName) %>">
                            <%=string.Format(GetResourceString("Navigation_Pattern_MyNavigation"), navigation.GetMultilingualNavigationName(CurrentUserLanguage))%></a></li>
                        <%}
                            }%>
                    </ul>
                </li>
            </ul>
            <%}
                else
                { %>
            <ul id="AnonymousPanel" class="sf-menu">
                <li><a href="<%=WebUtils.ResolveUrl("~/Help/Home.html") %>" target="_blank">
                    <%=GetResourceString("Common_Help")%></a></li>
                     <%if (SiteSettingsManager.GetSiteSettings().RegistrationMode == RegistrationModes.EnableAll)
                  { %>
                <li><a href="<%=SiteUrls.Instance().UserRegister() %>">
                    <%=GetResourceString("Action_Register")%></a></li>
                    <%} %>
                <li><a href="<%=SiteUrls.Instance().LoginInModal() %>" id="loginInModalButton">
                    <%=GetResourceString("Action_Login")%></a></li>
            </ul>
            <%} %>
        </div>
    </div>
</div>
<div class="spb-branding-area">
    <div class="tn-wrapper-inner">
        <% if (Avatars.GetCompanyLogo(companyUser.UserID) != null && companyUser.IsShowLogo)
           {  %>
        <div class="spb-company-image">
            <img src="<%=SiteUrls.Instance().CompanyLogoUrl(companyUser.UserID)%>" title="<%=companyUser.DisplayName %>" />
        </div>
        <br />
        <%}
           else
           {%>
        <h1 class="spb-company-name">
            <%=companyUser.DisplayName%></h1>
        <h2 class="spb-company-intro">
            <%=companyUser.UserDomainDescription%>
        </h2>
        <%} %>
    </div>
</div>
<div class="spb-nav1-area">
    <div class="tn-wrapper-inner">
        <ul class="spb-nav1 tn-helper-reset tn-helper-clearfix sf-menu">
            <li class="spb-nav-item <% if(applicationID==UserDomainSpecialAppIDs.Instance().Home()){ Response.Write(" tn-selected"); } %>">
                <a href="<%=SPBUrlHelper.Action("Home","UserDomain",new RouteValueDictionary{{"userDomainName",currentDomainUser.UserName}}) %>">
                    <span>
                        <%=GetResourceString("Navigation_UserDomain_Home")%></span></a></li>
            <li class="spb-nav-item <% if(applicationID==UserDomainSpecialAppIDs.Instance().AboutCompany()){ Response.Write(" tn-selected"); } %>">
                <a href="<%=SiteUrls.Instance().UserChannelHome(currentDomainUser,UserDomainSpecialAppIDs.Instance().AboutCompany()) %>">
                    <span>
                        <%=GetResourceString("Navigation_UserDomain_AboutCompany")%></span></a></li>
            <li class="spb-nav-item <% if(applicationID==UserDomainSpecialAppIDs.Instance().MessageHome()){ Response.Write(" tn-selected"); } %>">
                <a href="<%=SiteUrls.Instance().UserMessageHome(currentDomainUser) %>"><span>
                    <%=GetResourceString("Navigation_UserDomain_MessageCenter")%></span></a></li>
      <% 
                int i = 0;//遍历序号
                int j = 0;//已显示的导航个数
                foreach (OwnerNavigation navigation in currentDomainUserNavigations)
                {
                    i++;
                    if (!navigation.IsVisible(isUserDomainOwnerOrAdministrator))
                        continue;
                    j++;
                    if (j <= count)
                    {                    
            %>
            <li <% if(applicationID==navigation.ApplicationID){ Response.Write("class=\"spb-nav-item tn-selected\""); } else {Response.Write("class=\"spb-nav-item\"");} %>>
                <a href="<%=navigation.GetUserNavigationUrl(currentDomainUser.UserName) %>" target="<%=navigation.NavigationTarget %>"
                    value="<%=navigation.ApplicationID %>">
                    <span>
                        <%=navigation.GetMultilingualNavigationName(CurrentUserLanguage)%></span></a></li>
            <%
                if (i == currentDomainUserNavigations.Count)
                {
            %>
            <% 
                break;
                }
                    }
                    if (j == count)
                    {%>
            <%} if (j == count + 1)
                    { %>
            <li class="spb-nav-item">
                <a href="javascript:;">
                    <span>&nbsp;</span></a>
                <ul style="display: none; visibility: hidden;">
                    <% }
                    if (j > count)
                    { %><li>
                        <a href="<%=navigation.GetUserNavigationUrl(currentDomainUser.UserName) %>">
                            <%=navigation.GetMultilingualNavigationName(CurrentUserLanguage)%></a></li>
                    <%}%>
                    <%}%>
                    <%if (i == currentDomainUserNavigations.Count && j > count)
                      { %>
                    <% if (isUserDomainOwnerOrAdministrator)
                       { %>
                    <li class="spb-separator"></li>
                    <li>
                        <a href="<%=SPBUrlHelper.Action("ManageUserNavigations", "UserDomainSettings", new RouteValueDictionary { { "userDomainName", currentDomainUser.UserName } })%>">
                            <%=GetResourceString("Title_NavigationsSettings",ApplicationIDs.Instance().User())%>
                        </a>
                    </li>
                    <%} %>
                </ul>
            </li>
        </ul>
        <%}%>
    </div>
</div>

<script type="text/javascript">
    $(document).ready(function() {
        $('ul.sf-menu').superfish();
        $('#loginInModalButton').dialog({
                id: 'loginDialog',
                title: '登录',
                width: 400             
            });
            if(<%=totalCount %> > 0)
      newMessageHint('<%=GetResourceString("Description_NewMessage")%>');

    });  
</script>

