﻿<%@ Control Language="C#" Inherits="SpaceBuilder.Web.SPBViewUserControl" %>
<%
    CompanyProfileMenu menuType = CompanyProfileMenu.CompanySetting;
    try
    {
        menuType = (CompanyProfileMenu)ViewData["CompanyProfileMenu"];
    }
    catch
    {
    }

    string userDomainName = Html.GetParameterFromRouteDateOrQueryString("UserDomainName");
    User currentDomainUser = Users.GetUser(userDomainName, false);

    int applicationID = ApplicationIDs.Instance().User();
%>
<div class="tn-box tn-widget tn-widget-content tn-corner-all">
    <div class="tn-box-content tn-widget-content tn-corner-all">
        <ul class="tn-side-menu">
            <li <%if (menuType == CompanyProfileMenu.CompanySetting) Response.Write(" class=\"tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("EditProfile","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <%=GetResourceString("Title_AccountInfo", applicationID)%></a></li>
            <li <%if (menuType == CompanyProfileMenu.BasicMessage) Response.Write(" class=\"tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("EditCompanyBasicInfo","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <%=GetResourceString("Title_BasicInfo", applicationID)%></a></li>
            <li <%if (menuType == CompanyProfileMenu.CompanyLogo) Response.Write(" class=\"tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("EditCompanyAvatarFile","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <span>头部标示</span></a></li>
            <li <%if (menuType == CompanyProfileMenu.UploadAvatar) Response.Write(" class=\"tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("UploadAvatar","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <span>
                        <%=GetResourceString("Title_UploadAvatar",applicationID)%></span></a></li>
            <li <%if (menuType == CompanyProfileMenu.ForumSignature) Response.Write(" class=\"tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ForumSignature","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <span>
                        <%=GetResourceString("Title_ForumInfor",applicationID) %></span></a></li>
            <li <%if (menuType == CompanyProfileMenu.ChangePassword) Response.Write(" class=\"tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("ChangePassword","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <span>
                        <%=GetResourceString("Title_ChangePassword",applicationID)%></span></a></li>
            <li <%if (menuType == CompanyProfileMenu.AccountBinding) Response.Write(" class=\"tn-text-note tn-selected tn-widget-content tn-bg-light tn-corner-all\"");%>>
                <a class="tn-menu-text" href="<%=SPBUrlHelper.Action("AccountBinding","UserDomainSettings",new RouteValueDictionary{{"userDomainName",userDomainName}}) %>">
                    <span>账号绑定</span></a></li>
        </ul>
    </div>
</div>