﻿<%@ Page Language="C#" Inherits="SpaceBuilder.Web.UserDomainViewPage<CompanyUser>" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<spb:Header ID="Header1" runat="server">
    <spb:Script runat="server" ID="jquery" Src="~/Utility/jquery/jquery.min-1.4.2.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="cookie" Src="~/Utility/jquery/plugin/jquery.cookie.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="core" Src="~/Utility/jquery/ui.core.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="widget" Src="~/Utility/jquery/ui.widget.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="nyroModal" Src="~/Utility/jquery/plugin/jquery.nyroModal-1.6.2.min.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="tabs" Src="~/Utility/jquery/ui.tabs.min-1.8.12.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="superfish" Src="~/Utility/jquery/plugin/jquery.superfish-1.4.8.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="menuButton" Src="~/Utility/jquery/plugin/jquery.spb.menuButton.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="watermarkinput" Src="~/Utility/jquery/plugin/jquery.watermarkinput.js" />
    <spb:Script runat="server" ID="validate" Src="~/Utility/jquery/plugin/jquery.validate-1.7.js"
        SetExpireDays="30" />
    <spb:Script runat="server" ID="global" Src="~/Utility/tunynet_web_ui/global.js" />
</spb:Header>
<body class="tn-page-bg" id="spb-company-page">
    <div id="tn-doc" class="tn-doc-bg">
        <div id="tn-header" class="tn-header-bg">
            <div class="tn-wrapper">
                <% string userDomainName = Html.GetParameterFromRouteDateOrQueryString("userDomainName");
                   int UserApplicationID = ApplicationIDs.Instance().User(); %>
                <%  ViewData["ApplicationID"] = UserDomainSpecialAppIDs.Instance().AboutCompany();
                    Html.RenderPartial("Controls/Header.ascx", ViewData); %></div>
        </div>
        <div id="tn-content" class="tn-content-bg tn-doc2">
            <div class="tn-wrapper">
                <div class="tn-grid-1-3">
                    <div class="tn-unit tn-first">
                        <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-company-news">
                            <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
                                <span class="tn-helper-right">
                                    <%
                                        if (CurrentUser != null && (Globals.GetCurrentUser().UserName == ViewData.Model.UserName || Globals.GetCurrentUser().IsContentAdministrator))
                                        {
                                    %>
                                    <a href="<%=SPBUrlHelper.Action("EditCompanyBasicInfo","UserDomainSettings",new RouteValueDictionary{{"userDomainName",ViewData.Model.UserName}}) %>">
                                        <%=GetResourceString("Action_Edit")%></a>
                                    <%} %>
                                </span>
                                <h3 class="tn-helper-reset">
                                    <%=GetResourceString("Title_BasicUserInfo",UserApplicationID) %></h3>
                            </div>
                            <div class="tn-box-content tn-widget-content tn-corner-bottom">
                                <div class="tn-info-part">
                                    <%
                                        if (CurrentUser != null && Globals.GetCurrentUser().IsContentAdministrator)
                                        {
                                    %>
                                    <dl>
                                        <dt>
                                            <%=GetResourceString("Label_CompanyUserLicence",UserApplicationID) %><%=GetResourceString("Common_Colon") %></dt>
                                        <dd>
                                            <%=ViewData.Model.Licence%></dd>
                                    </dl>
                                    <%} %>
                                    <dl>
                                        <dt>
                                            <%=GetResourceString("Label_CompanyUserTrade",UserApplicationID) %><%=GetResourceString("Common_Colon") %></dt>
                                        <dd>
                                            <%
                                                if (ViewData.Model.Trade > 0)
                                                    Response.Write(CodeItems.GetCodeItems(CodeSetCodes.Instance().Trade())[ViewData.Model.Trade].Name);
                                            %></dd>
                                    </dl>
                                    <dl>
                                        <dt>
                                            <%=GetResourceString("Label_CompanyUserProperty",UserApplicationID) %><%=GetResourceString("Common_Colon") %></dt>
                                        <dd>
                                            <%
                                                if (ViewData.Model.CompanyProperty > 0)
                                                    Response.Write(CodeItems.GetCodeItems(CodeSetCodes.Instance().CompanyProperty())[ViewData.Model.CompanyProperty].Name);
                                            %>
                                        </dd>
                                    </dl>
                                    <dl>
                                        <dt>
                                            <%=GetResourceString("Label_CompanyUserEmployeeNum",UserApplicationID) %><%=GetResourceString("Common_Colon") %></dt>
                                        <dd>
                                            <%
                                                if (ViewData.Model.EmployeeNum > 0)
                                                    Response.Write(CodeItems.GetCodeItems(CodeSetCodes.Instance().EmployeeCount())[ViewData.Model.EmployeeNum].Name);
                                            %>
                                        </dd>
                                    </dl>
                                    <dl>
                                        <dt>
                                            <%=GetResourceString("Label_CompanyUserFund",UserApplicationID) %><%=GetResourceString("Common_Colon") %></dt>
                                        <dd>
                                            <%
                                                if (ViewData.Model.Fund > 0)
                                                    Response.Write(CodeItems.GetCodeItems(CodeSetCodes.Instance().Fund())[ViewData.Model.Fund].Name);
                                            %>
                                        </dd>
                                    </dl>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tn-unit">
                        <div class="tn-box tn-widget tn-widget-content tn-corner-all spb-company-news">
                            <div class="tn-box-header tn-widget-header tn-corner-top tn-border-bottom">
                                <span class="tn-helper-right">
                                    <%
                                        if (CurrentUser != null && (Globals.GetCurrentUser().UserName == ViewData.Model.UserName || Globals.GetCurrentUser().IsContentAdministrator))
                                        {
                                    %>
                                    <a href="<%=SPBUrlHelper.Action("EditCompanyBasicInfo","UserDomainSettings",new RouteValueDictionary{{"userDomainName",ViewData.Model.UserName}}) %>#Intro">
                                        <%=GetResourceString("Action_Edit")%></a>
                                    <%} %>
                                </span>
                                <h3 class="tn-helper-reset">
                                    <%=GetResourceString("Label_CompanyUserIntro",UserApplicationID) %></h3>
                            </div>
                            <div class="tn-box-content tn-widget-content tn-corner-bottom">
                                <%=ViewData.Model.Intro %>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="tn-footer-bg" id="tn-footer">
            <div class="tn-wrapper">
                <% Html.RenderPartial("Controls/Footer.ascx"); %>
            </div>
        </div>
    </div>
</body>
</html>
